/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.tentaisho;

import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.AreaEditStep;
import pencilbox.common.core.BoardBase;
import pencilbox.resource.Messages;
import pencilbox.tentaisho.Area;
import pencilbox.tentaisho.StarAddress;
import pencilbox.util.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Board
extends BoardBase {
    static final int NOSTAR = 0;
    static final int WHITESTAR = 1;
    static final int BLACKSTAR = 2;
    private int[][] star;
    private Area[][] area;
    private List<Area> areaList;

    @Override
    protected void setup() {
        super.setup();
        this.star = new int[this.rows() * 2 - 1][this.cols() * 2 - 1];
        this.area = new Area[this.rows()][this.cols()];
        this.areaList = new LinkedList<Area>();
    }

    @Override
    public void clearBoard() {
        super.clearBoard();
        this.areaList.clear();
        ArrayUtil.initArrayObject2(this.area, null);
    }

    @Override
    public void initBoard() {
        this.initAreas();
    }

    public void initAreas() {
        for (Area a : this.areaList) {
            this.initArea(a);
        }
    }

    int[][] getStar() {
        return this.star;
    }

    public int getStar(int r, int c) {
        return this.star[r][c];
    }

    public int getStar(Address pos) {
        return this.getStar(pos.r(), pos.c());
    }

    public void setStar(int r, int c, int st) {
        this.star[r][c] = st;
    }

    public void setStar(Address pos, int st) {
        this.setStar(pos.r(), pos.c(), st);
    }

    public boolean isOnStar(int r, int c) {
        return r >= 0 && r < this.rows() * 2 - 1 && c >= 0 && c < this.cols() * 2 - 1;
    }

    public boolean isOnStar(Address pos) {
        return this.isOnStar(pos.r(), pos.c());
    }

    public boolean isCovered(int r, int c) {
        return this.area[r][c] != null;
    }

    public Area getArea(int r, int c) {
        return this.area[r][c];
    }

    public Area getArea(Address pos) {
        return this.getArea(pos.r(), pos.c());
    }

    public void setArea(int r, int c, Area a) {
        this.area[r][c] = a;
    }

    public void setArea(Address pos, Area a) {
        this.setArea(pos.r(), pos.c(), a);
    }

    public void addArea(Area newArea) {
        for (Address pos : newArea) {
            this.setArea(pos.r(), pos.c(), newArea);
        }
        this.areaList.add(newArea);
    }

    public void removeArea(Area oldArea) {
        for (Address pos : oldArea) {
            if (this.getArea(pos.r(), pos.c()) != oldArea) continue;
            this.setArea(pos.r(), pos.c(), null);
        }
        this.areaList.remove(oldArea);
    }

    void addCellToAreaA(Address pos, Area area) {
        Address p0 = Address.NOWHERE;
        if (area.size() > 0) {
            p0 = (Address)area.toArray()[0];
        }
        this.fireUndoableEditUpdate(new AreaEditStep(pos, p0, 1));
        this.addCellToArea(pos, area);
    }

    void removeCellFromAreaA(Address pos, Area area) {
        Address p0 = Address.NOWHERE;
        if (area.size() > 1 && (p0 = (Address)area.toArray()[0]).equals(pos)) {
            p0 = (Address)area.toArray()[1];
        }
        this.fireUndoableEditUpdate(new AreaEditStep(pos, p0, 0));
        this.removeCellFromArea(pos, area);
    }

    @Override
    public void undo(AbstractStep step) {
        Area a;
        AreaEditStep s = (AreaEditStep)step;
        if (s.getOperation() == 1) {
            Area a2 = this.getArea(s.getPos());
            if (a2 != null) {
                this.removeCellFromArea(s.getPos(), a2);
            }
        } else if (s.getOperation() == 0 && (a = Address.NOWHERE.equals(s.getP0()) ? new Area() : this.getArea(s.getP0())) != null) {
            this.addCellToArea(s.getPos(), a);
        }
    }

    @Override
    public void redo(AbstractStep step) {
        Area a;
        AreaEditStep s = (AreaEditStep)step;
        if (s.getOperation() == 1) {
            Area a2 = Address.NOWHERE.equals(s.getP0()) ? new Area() : this.getArea(s.getP0());
            if (a2 != null) {
                this.addCellToArea(s.getPos(), a2);
            }
        } else if (s.getOperation() == 0 && (a = this.getArea(s.getPos())) != null) {
            this.removeCellFromArea(s.getPos(), a);
        }
    }

    public void addCellToArea(int r, int c, Area area) {
        if (area.isEmpty()) {
            this.areaList.add(area);
        }
        this.setArea(r, c, area);
        area.add(r, c);
        this.initArea(area);
    }

    public void addCellToArea(Address pos, Area area) {
        this.addCellToArea(pos.r(), pos.c(), area);
    }

    public void removeCellFromArea(int r, int c, Area area) {
        this.setArea(r, c, null);
        area.remove(r, c);
        if (area.isEmpty()) {
            this.areaList.remove(area);
        } else {
            this.initArea(area);
        }
    }

    public void removeCellFromArea(Address pos, Area area) {
        this.removeCellFromArea(pos.r(), pos.c(), area);
    }

    void initArea(Area newArea) {
        int nStar = 0;
        StarAddress starPos = StarAddress.NOWHERE;
        for (Address pos : newArea) {
            int i = 2 * pos.r() - 1;
            while (i <= 2 * pos.r() + 1) {
                int j = 2 * pos.c() - 1;
                while (j <= 2 * pos.c() + 1) {
                    if (this.isOnStar(i, j) && this.getStar(i, j) > 0) {
                        if (nStar == 0) {
                            nStar = this.getStar(i, j);
                            starPos = StarAddress.address(i, j);
                        } else if (!(nStar != 1 && nStar != 2 || starPos.equals(i, j))) {
                            nStar = -1;
                            starPos = StarAddress.NOWHERE;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        newArea.setStarType(nStar);
        newArea.setStarPos(starPos);
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        for (Area a : this.areaList) {
            if (a.isPointSymmetry()) continue;
            result |= 1;
        }
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.area[r][c] == null) {
                    result |= 2;
                }
                ++c;
            }
            ++r;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("tentaisho.AnswerCheckMessage1"));
        } else if ((result & 2) == 2) {
            message.append(Messages.getString("tentaisho.AnswerCheckMessage2"));
        }
        return message.toString();
    }

    List<Area> getAreaList() {
        return this.areaList;
    }

    Area[][] getArea() {
        return this.area;
    }
}

