/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shikaku;

import java.awt.Color;
import javax.swing.JMenuItem;
import pencilbox.common.gui.MenuBase;
import pencilbox.resource.Messages;
import pencilbox.shikaku.Panel;

public class Menu
extends MenuBase {
    private JMenuItem numberColorItem;
    private JMenuItem areaBorderColorItem;
    private JMenuItem areaPaintColorItem;
    private JMenuItem indicateErrorItem;
    private JMenuItem separateAreaColorItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    protected void buildEditMenu() {
        this.addSymmetricPlacementMenuItem();
        super.buildEditMenu();
    }

    protected void buildViewMenu() {
        super.buildViewMenu();
        this.numberColorItem = this.addColorMenuItem(Messages.getString("Menu.numberColorItem"));
        this.areaBorderColorItem = this.addColorMenuItem(Messages.getString("Menu.areaBorderColorItem"));
        this.areaPaintColorItem = this.addColorMenuItem(Messages.getString("Menu.areaPaintColorItem"));
        this.indicateErrorItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.indicateCompletionItem"), 'E', false);
        this.addToViewMenu(this.indicateErrorItem);
        this.separateAreaColorItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.separateAreaColorItem"), 'R', false);
        this.addToViewMenu(this.separateAreaColorItem);
        this.addRenewColorMenuItem();
    }

    public void executeCommand2(JMenuItem target) {
        if (target == this.indicateErrorItem) {
            this.getPanel().setIndicateErrorMode(target.isSelected());
        } else if (target == this.separateAreaColorItem) {
            this.getPanel().setSeparateAreaColorMode(target.isSelected());
        }
    }

    public Color getColor(JMenuItem target) {
        if (target == this.areaBorderColorItem) {
            return this.getPanel().getAreaBorderColor();
        }
        if (target == this.areaPaintColorItem) {
            return this.getPanel().getAreaPaintColor();
        }
        if (target == this.numberColorItem) {
            return this.getPanel().getNumberColor();
        }
        return super.getColor(target);
    }

    public void setColor(JMenuItem target, Color color) {
        if (target == this.areaBorderColorItem) {
            this.getPanel().setAreaBorderColor(color);
        } else if (target == this.areaPaintColorItem) {
            this.getPanel().setAreaPaintColor(color);
        } else if (target == this.numberColorItem) {
            this.getPanel().setNumberColor(color);
        } else {
            super.setColor(target, color);
        }
    }

    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.indicateErrorItem.setSelected(this.getPanel().isIndicateErrorMode());
        this.separateAreaColorItem.setSelected(this.getPanel().isSeparateAreaColorMode());
    }
}

