/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.heyawake;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.heyawake.Board;
import pencilbox.heyawake.Panel;
import pencilbox.heyawake.Square;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private Address dragStart = new Address(-1, -1);
    private int currentState = 0;

    public PanelEventHandler() {
        this.setMaxInputNumber(9);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftPressed(Address pos) {
        if (this.isProblemEditMode()) {
            Address dragEnd = pos;
            this.dragStart.set(dragEnd);
            this.setDraggingSquare(new Square(this.dragStart.r(), this.dragStart.c(), dragEnd.r(), dragEnd.c()));
        } else {
            this.board.toggleState(pos.r(), pos.c(), 1);
        }
    }

    protected void rightPressed(Address pos) {
        if (this.isProblemEditMode()) {
            Address dragEnd = pos;
            this.board.removeSquareIncluding(dragEnd.r(), dragEnd.c());
        } else {
            this.board.toggleState(pos.r(), pos.c(), 2);
            this.currentState = this.board.getState(pos.r(), pos.c());
        }
    }

    protected void leftDragged(Address pos) {
        if (this.isProblemEditMode()) {
            if (this.getDraggingSquare() == null) {
                return;
            }
            this.getDraggingSquare().set(this.dragStart.r(), this.dragStart.c(), pos.r(), pos.c());
        }
    }

    protected void leftDragFixed(Address pos) {
        if (this.isProblemEditMode()) {
            Address dragEnd = pos;
            if (this.getDraggingSquare() == null) {
                return;
            }
            this.setDraggingSquare(null);
            this.board.addSquareSpanning(this.dragStart.r(), this.dragStart.c(), dragEnd.r(), dragEnd.c());
            this.dragStart.setNowhere();
        }
    }

    protected void rightDragged(Address pos) {
        if (this.isProblemEditMode()) {
            Address dragEnd = pos;
            this.board.removeSquareIncluding(dragEnd.r(), dragEnd.c());
        } else {
            int st = this.board.getState(pos.r(), pos.c());
            if (st == this.currentState) {
                return;
            }
            this.board.changeStateA(pos.r(), pos.c(), this.currentState);
        }
    }

    protected void dragFailed() {
        this.setDraggingSquare(null);
        this.dragStart.setNowhere();
    }

    protected void numberEntered(Address pos, int num) {
        if (!this.isProblemEditMode()) {
            return;
        }
        Square square = this.board.getSquare(pos.r(), pos.c());
        if (square != null) {
            square.setNumber(num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (!this.isProblemEditMode()) {
            return;
        }
        Square square = this.board.getSquare(pos.r(), pos.c());
        if (square != null) {
            square.setNumber(-1);
        }
    }

    void setDraggingSquare(Square draggingSquare) {
        ((Panel)this.getPanel()).setDraggingSquare(draggingSquare);
    }

    Square getDraggingSquare() {
        return ((Panel)this.getPanel()).getDraggingSquare();
    }
}

