#ifndef WIN32FORK_H
#define WIN32FORK_H

#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x0500
#endif

#include <windows.h>
#include <winternl.h>

#define STATUS_SUCCESS ((NTSTATUS)0x00000000L)

namespace NT{

typedef
NTSTATUS
(NTAPI *TypeZwCreateProcess)( 
  OUT PHANDLE            ProcessHandle, 
  IN  ACCESS_MASK        DesiredAccess, 
  IN  POBJECT_ATTRIBUTES ObjectAttributes, 
  IN  HANDLE             InheriteFromProcessHandle, 
  IN  BOOLEAN            InheritHandles, 
  IN  HANDLE             SectionHandle    OPTIONAL, 
  IN  HANDLE             DebugPort        OPTIONAL, 
  IN  HANDLE             ExceptionPort    OPTIONAL);

typedef enum _SYSTEM_INFORMATION_CLASS
{
	SystemHandleInformation = 0x10
	// there are more enums actually
} SYSTEM_INFORMATION_CLASS;

typedef
NTSTATUS (WINAPI *TypeZwQuerySystemInformation)(
  NT::SYSTEM_INFORMATION_CLASS SystemInformationClass,
  PVOID SystemInformation,
  ULONG SystemInformationLength,
  PULONG ReturnLength
);

#define STATUS_INFO_LENGTH_MISMATCH      ((NTSTATUS)0xC0000004L)

/*
typedef struct _SYSTEM_HANDLE_INFORMATION {
    ULONG NumberOfHandles;
    SYSTEM_HANDLE_TABLE_ENTRY_INFO Handles[ 1 ];
} SYSTEM_HANDLE_INFORMATION, *PSYSTEM_HANDLE_INFORMATION;
*/

typedef struct _SYSTEM_HANDLE_INFORMATION {
	ULONG ProcessId;
	UCHAR ObjectTypeNumber;
	UCHAR Flags;
	USHORT Handle;
	PVOID Object;
	ACCESS_MASK GrantedAccess;
} SYSTEM_HANDLE_INFORMATION, *PSYSTEM_HANDLE_INFORMATION;

typedef short CSHORT;

#define LPC_CLIENT_ID CLIENT_ID
#define LPC_SIZE_T SIZE_T

typedef struct _CLIENT_ID {
    HANDLE UniqueProcess;
    HANDLE UniqueThread;
} CLIENT_ID;
typedef CLIENT_ID *PCLIENT_ID;

typedef struct _PORT_MESSAGE {
    union {
        struct {
            CSHORT DataLength;
            CSHORT TotalLength;
        } s1;
        ULONG Length;
    } u1;
    union {
        struct {
            CSHORT Type;
            CSHORT DataInfoOffset;
        } s2;
        ULONG ZeroInit;
    } u2;
    union {
        LPC_CLIENT_ID ClientId;
        double DoNotUseThisField;       // Force quadword alignment
    };
    ULONG MessageId;
    union {
        LPC_SIZE_T ClientViewSize;          // Only valid on LPC_CONNECTION_REQUEST message
        ULONG CallbackId;                   // Only valid on LPC_REQUEST message
    };
//  UCHAR Data[];
} PORT_MESSAGE, *PPORT_MESSAGE;

typedef
NTSTATUS
(NTAPI *TypeCsrClientCallServer)(
	IN PVOID Message,
	IN PVOID arg, // __unused
	IN ULONG Opcode,
	IN ULONG Size
	);

typedef struct _CONTEXT {
    ULONG ContextFlags;
    ULONG   Dr0;
    ULONG   Dr1;
    ULONG   Dr2;
    ULONG   Dr3;
    ULONG   Dr6;
    ULONG   Dr7;

    FLOATING_SAVE_AREA FloatSave;

    ULONG   SegGs;
    ULONG   SegFs;
    ULONG   SegEs;
    ULONG   SegDs;

    ULONG   Edi;
    ULONG   Esi;
    ULONG   Ebx;
    ULONG   Edx;
    ULONG   Ecx;
    ULONG   Eax;

    ULONG   Ebp;
    ULONG   Eip;
    ULONG   SegCs;              // MUST BE SANITIZED
    ULONG   EFlags;             // MUST BE SANITIZED
    ULONG   Esp;
    ULONG   SegSs;

    UCHAR   ExtendedRegisters[MAXIMUM_SUPPORTED_EXTENSION];

} CONTEXT;

typedef CONTEXT *PCONTEXT;

typedef 
NTSTATUS
(NTAPI *TypeZwGetContextThread)(
IN HANDLE ThreadHandle,
OUT PCONTEXT Context
);

typedef enum _MEMORY_INFORMATION_{
MemoryBasicInformation,
MemoryWorkingSetList,
MemorySectionName,
MemoryBasicVlmInformation
} MEMORY_INFORMATION_CLASS;

typedef
NTSTATUS
(NTAPI *TypeZwQueryVirtualMemory)(
IN HANDLE ProcessHandle,
IN PVOID BaseAddress,
IN MEMORY_INFORMATION_CLASS MemoryInformationClass,
OUT PVOID MemoryInformation,
IN ULONG MemoryInformationLength,
OUT PULONG ReturnLength OPTIONAL
);

typedef struct _USER_STACK {
    PVOID FixedStackBase;
    PVOID FixedStackLimit;
    PVOID ExpandableStackBase;
    PVOID ExpandableStackLimit;
    PVOID ExpandableStackBottom;
} USER_STACK, *PUSER_STACK;

typedef
NTSTATUS
(NTAPI *TypeZwCreateThread)(
    OUT PHANDLE ThreadHandle,
    IN ACCESS_MASK DesiredAccess,
    IN POBJECT_ATTRIBUTES ObjectAttributes,
    IN HANDLE ProcessHandle,
    OUT PCLIENT_ID ClientId,
    IN PCONTEXT ThreadContext,
    IN PUSER_STACK UserStack,
    IN BOOLEAN CreateSuspended); 

typedef LONG KPRIORITY;
typedef ULONG_PTR KAFFINITY;
typedef KAFFINITY *PKAFFINITY;

typedef struct _THREAD_BASIC_INFORMATION {
  NTSTATUS                ExitStatus;
  PVOID                   TebBaseAddress;
  CLIENT_ID               ClientId;
  KAFFINITY               AffinityMask;
  KPRIORITY               Priority;
  KPRIORITY               BasePriority;
} THREAD_BASIC_INFORMATION, *PTHREAD_BASIC_INFORMATION;

typedef enum _THREAD_INFORMATION_CLASS {
    ThreadBasicInformation,
    ThreadTimes,
    ThreadPriority,
    ThreadBasePriority,
    ThreadAffinityMask,
    ThreadImpersonationToken,
    ThreadDescriptorTableEntry,
    ThreadEnableAlignmentFaultFixup,
    ThreadEventPair,
    ThreadQuerySetWin32StartAddress,
    ThreadZeroTlsCell,
    ThreadPerformanceCount,
    ThreadAmILastThread,
    ThreadIdealProcessor,
    ThreadPriorityBoost,
    ThreadSetTlsArrayAddress,
    ThreadIsIoPending,
    ThreadHideFromDebugger
} THREAD_INFORMATION_CLASS, *PTHREAD_INFORMATION_CLASS;

typedef
NTSTATUS
(NTAPI *TypeZwQueryInformationThread)(
  IN HANDLE               ThreadHandle,
  IN THREAD_INFORMATION_CLASS ThreadInformationClass,
  OUT PVOID               ThreadInformation,
  IN ULONG                ThreadInformationLength,
  OUT PULONG              ReturnLength OPTIONAL );

typedef struct _NT_TIB {
    struct _EXCEPTION_REGISTRATION_RECORD *ExceptionList;
    PVOID StackBase;
    PVOID StackLimit;
    PVOID SubSystemTib;
    union {
        PVOID FiberData;
        ULONG Version;
    };
    PVOID ArbitraryUserPointer;
    struct _NT_TIB *Self;
} NT_TIB;
typedef NT_TIB *PNT_TIB;

typedef
NTSTATUS
(NTAPI *TypeZwWriteVirtualMemory)(
  IN HANDLE               ProcessHandle,
  IN PVOID                BaseAddress,
  IN PVOID                Buffer,
  IN ULONG                NumberOfBytesToWrite,
  OUT PULONG              NumberOfBytesWritten OPTIONAL );

typedef
NTSTATUS
(NTAPI *TypeZwResumeThread)(
  IN HANDLE               ThreadHandle,
  OUT PULONG              SuspendCount OPTIONAL );

typedef
NTSTATUS
(NTAPI *TypeZwClose)(
  IN HANDLE               ObjectHandle );

typedef
NTSTATUS
(NTAPI *TypeZwTerminateThread)(
  IN HANDLE               ThreadHandle,
  IN NTSTATUS             ExitStatus );

typedef
NTSTATUS
(NTAPI *TypeCsrClientConnectToServer)(PWSTR ObjectDirectory,
								  ULONG ServerId,
								  PVOID ConnectionInfo,
								  PULONG ConnectionInfoSize,
								  PBOOLEAN ServerToServerCall);
typedef
NTSTATUS
(NTAPI *TypeZwTerminateProcess)(IN HANDLE ProcessHandle OPTIONAL,
							  IN NTSTATUS ExitStatus);

}



#define NtCurrentProcess() ( (HANDLE)(LONG_PTR) -1 )         
#define NtCurrentThread() ( (HANDLE)(LONG_PTR) -2 )

void init_nativeapi();
int win32_fork();
void win32_exit(NTSTATUS);
#endif