#include "SyncQueue.h"

int timedqueuesample(int timeout)
{
  void generator(int,SyncQueue<int>*);
  void consumer(SyncQueue<int>*);
/*
  if(argc < 2) {
    printf("timedqueuesample timeout(sec) (use 1 to see timeout; more than 3 does not timeout.)\n");
    exit(0);
  }

  int timeout = atoi(argv[1]);
*/
  pards_init();

  SyncQueue<int> *a;
  a = new SyncQueue<int>(2);

  SPAWN(generator(timeout,a));
  consumer(a);

  pards_finalize();

  return 0;
}


void generator(int timeout, SyncQueue<int> *a)
{
  int i;
  SyncQueue<int> *current;
  current = a;

  struct timeval tv = {timeout,0};
  pards_status is_timedout;

  for(i = 0; i < 3; i++){
    current->write(i);
    pards_errorf(INFO,"writer:value = %d\n",i);
    while(1){
      current = current->timedcreate(&tv,&is_timedout);
      if(is_timedout == TIMEOUT) pards_errorf(INFO,"time out. trying again.\n");
      else break;
    }
  }
  current->write(i);
  pards_errorf(INFO,"writer:value = %d\n",i);
  current->writecdr(0);
}

void consumer(SyncQueue<int> *a)
{
  SyncQueue<int> *current;
  current = a;

  while(1){
    Sleep(2000);
    pards_errorf(INFO,"reader:value = %d\n",current->read());
    current = current->release();
    if(current == 0) break;
  }
}
