#include "SyncList.h"

int timedlistsample(int timeout)
{
  void generator(SyncList<int>*);
  void consumer(int,SyncList<int>*);
/*
  if(argc < 2) {
    printf("timedlistsample timeout(sec) (use 1 to see timeout; more than 3 does not timeout.)\n");
    exit(0);
  }

  int timeout = atoi(argv[1]);
*/
  pards_init();

  SyncList<int> *a;
  a = new SyncList<int>;

  SPAWN(generator(a));
  consumer(timeout, a);

  pards_finalize();
  return 0;
}


void generator(SyncList<int> *a)
{
  int i;
  SyncList<int> *current;
  current = a;

  for(i = 0; i < 3; i++){
    current->write(i);
    Sleep(2000);
    current = current->create();
    pards_errorf(INFO,"writer:value = %d\n",i);
  }
  current->write(i);
  pards_errorf(INFO,"writer:value = %d\n",i);
  current->writecdr(0);
}

void consumer(int timeout, SyncList<int> *a)
{
  SyncList<int> *current;
  current = a;

  struct timeval tv = {timeout, 0};

  while(1){
    pards_status is_timedout;
    int v = current->read();
    while(1){
      pards_errorf(INFO,"is cdr written = %d, do timedrelease\n",current->is_cdr_written());
      current = current->timedrelease(&tv,&is_timedout);
      if(is_timedout == TIMEOUT){
	pards_errorf(INFO,"time out. trying again\n");
	continue;
      } else {
	pards_errorf(INFO,"reader:value = %d\n",v);
	break;
      }
    }
    if(current == 0) break;
  }
}
