/*
 * Decompiled with CFR 0.152.
 */
package paraselene.util;

import paraselene.util.IP;

public class IPv4
extends IP {
    public IPv4(String ip) throws IP.IPFormatException {
        super(IPv4.parse(ip.trim()));
    }

    private static int[] parse(String str) throws IP.IPFormatException {
        String[] num = str.split("\\.");
        if (num.length != 4) {
            throw new IP.IPFormatException(str);
        }
        int[] ret = new int[4];
        try {
            for (int i = 0; i < num.length; ++i) {
                ret[i] = Integer.parseInt(num[i]);
                if (ret[i] >= 0 && ret[i] <= 255) continue;
                throw new IP.IPFormatException(str);
            }
        }
        catch (NumberFormatException e) {
            throw new IP.IPFormatException(str);
        }
        return ret;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf = buf.append(this.addr[0]);
        for (int i = 1; i < this.addr.length; ++i) {
            buf = buf.append(".").append(this.addr[i]);
        }
        return buf.toString();
    }

    private IPv4(IP ip) {
        super(ip);
    }

    @Override
    IP getReplica() {
        return new IPv4(this);
    }
}

