/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import paraselene.Page;
import paraselene.supervisor.HistorySet;
import paraselene.supervisor.Null;
import paraselene.supervisor.Option;
import paraselene.supervisor.PageFactory;
import paraselene.supervisor.PageID;
import paraselene.supervisor.ParaseleneException;
import paraselene.supervisor.PathData;
import paraselene.supervisor.ServerInformation;
import paraselene.test.TestSession;

public class TransactionSequencer
implements Serializable {
    private static final long serialVersionUID = 2L;
    static final String[] SELENE = new String[]{"lu", "mo", "on", "na", "art", "mis", "dia"};
    public static final String EXTENSION = "." + SELENE[3];
    public static final String[] LINK_DEF = new String[]{"PARASELENE(PAGE)", "PARASELENE(HTTP)", "PARASELENE(HTTPS)"};
    private volatile int seq_no = 0;
    private HashMap<Integer, Boolean> no_map = new HashMap();
    private static final String[] HEAD = new String[]{"seleno", "lilith"};
    private static final int HEAD_LENGTH = 6;
    static final String SESSION_DIR = "mss.";
    private static final int SESSION_DIR_LEN = "mss.".length();
    private static final int EXT_LEN = EXTENSION.length();

    TransactionSequencer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int newNo(PageID id) {
        long dt = new Date().getTime() / 1000L & 0x7FFFFFL;
        int ret = (int)(dt << 8);
        TransactionSequencer transactionSequencer = this;
        synchronized (transactionSequencer) {
            this.seq_no += (int)(Math.random() * 5.0);
            this.no_map.put(ret |= this.seq_no & 0xFF, false);
        }
        return ret;
    }

    public static String makeURI(TransactionSequencer seq, PageID from, PageID to, int from_key, int to_key, boolean flag) {
        StringBuilder buf = new StringBuilder();
        if (flag && seq != null) {
            buf = buf.append(SELENE[0]);
            buf = buf.append(".");
            buf = buf.append(HEAD[0]);
            buf = buf.append(Integer.toString(seq.newNo(to), 36));
            buf = buf.append(".");
        }
        if (from != null) {
            buf = buf.append(SELENE[1]);
            buf = buf.append(".");
            buf = buf.append(Integer.toString(from.getID(), 36));
            buf = buf.append(".");
            if (flag && from_key != 0) {
                buf = buf.append(SELENE[4]);
                buf = buf.append(".");
                buf = buf.append(Integer.toString(from_key, 36));
                buf = buf.append(".");
            }
        }
        if (flag && to_key != 0) {
            buf = buf.append(SELENE[5]);
            buf = buf.append(".");
            buf = buf.append(Integer.toString(to_key, 36));
            buf = buf.append(".");
        }
        buf = buf.append(SELENE[2]);
        buf = buf.append(".");
        buf = buf.append(Integer.toString(to.getID(), 36));
        buf = buf.append(".");
        buf = buf.append(SELENE[3]);
        return buf.toString();
    }

    static String makeRedirectURI(TransactionSequencer seq, PageID to) {
        StringBuilder buf = new StringBuilder();
        buf = buf.append(SELENE[0]);
        buf = buf.append(".");
        buf = buf.append(HEAD[1]);
        buf = buf.append(Integer.toString(seq.newNo(null), 36));
        buf = buf.append(".");
        buf = buf.append(SELENE[2]);
        buf = buf.append(".");
        buf = buf.append(Integer.toString(to.getID(), 36));
        buf = buf.append(".");
        buf = buf.append(SELENE[3]);
        return buf.toString();
    }

    private static Page getPage(String no, PageFactory fact) {
        Page ret = null;
        try {
            ret = fact.getPage(Integer.parseInt(no, 36));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ret == null) {
            return new Null();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PathData parsePath(TransactionSequencer seq, String uri, PageFactory fact, HistorySet hset) throws ParaseleneException {
        String[] path = uri.split("[\\?;]");
        if (path != null) {
            uri = path[0];
        }
        Option.trace(uri, new Object[0]);
        path = uri.split("/");
        for (int i = path.length - 1; i >= 0; --i) {
            String[] body = path[i].split("\\.");
            if (body.length == 0 || !SELENE[3].equals(body[body.length - 1])) continue;
            PathData ret = new PathData();
            int cnt = body.length - 1;
            boolean redirect_f = false;
            boolean request_id = false;
            for (int j = 0; j < cnt; j += 2) {
                if (seq != null && SELENE[0].equals(body[j])) {
                    if (body[j + 1].length() <= 6) {
                        return null;
                    }
                    String head = body[j + 1].substring(0, 6);
                    String number = body[j + 1].substring(6);
                    if (HEAD[1].equals(head)) {
                        redirect_f = true;
                    } else if (!HEAD[0].equals(head)) {
                        return null;
                    }
                    int no = Integer.parseInt(number, 36);
                    TransactionSequencer transactionSequencer = seq;
                    synchronized (transactionSequencer) {
                        Boolean flag = seq.no_map.get(no);
                        if (flag == null) {
                            return null;
                        }
                        request_id = true;
                        ret.called = flag;
                        seq.no_map.put(no, true);
                        continue;
                    }
                }
                if (SELENE[1].equals(body[j])) {
                    ret.from = TransactionSequencer.getPage(body[j + 1], fact);
                    continue;
                }
                if (SELENE[2].equals(body[j])) {
                    if (redirect_f) {
                        ret.redirect = TransactionSequencer.getPage(body[j + 1], fact);
                        continue;
                    }
                    ret.to = TransactionSequencer.getPage(body[j + 1], fact);
                    continue;
                }
                if (SELENE[4].equals(body[j])) {
                    ret.from_histry = Integer.parseInt(body[j + 1], 36);
                    continue;
                }
                if (!SELENE[5].equals(body[j])) continue;
                ret.to_histry = Integer.parseInt(body[j + 1], 36);
                if (hset == null || ret.to_histry != Integer.MAX_VALUE) continue;
                ret.to_histry = hset.toInt();
            }
            if (ret.from != null) {
                Page out = ret.to;
                if (out == null) {
                    out = ret.redirect;
                }
                if (out != null && seq != null && out.isCheckRepeatSameRequest() && !request_id) {
                    return null;
                }
            }
            return ret;
        }
        return null;
    }

    static boolean isMustSession(String uri) {
        String[] path = uri.split("\\?");
        uri = path[0];
        path = uri.split("/");
        for (int i = path.length - 1; i >= 0; --i) {
            String[] body = path[i].split("\\.");
            if (body.length == 0 || !SELENE[3].equals(body[body.length - 1])) continue;
            int cnt = body.length - 1;
            for (int j = 0; j < cnt; j += 2) {
                if (SELENE[0].equals(body[j])) {
                    return true;
                }
                if (!SELENE[1].equals(body[j])) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    static String getMSS(HttpServletRequest req) {
        for (String path : req.getRequestURI().split("/")) {
            if (path.indexOf(SESSION_DIR) != 0 || path.equals(SESSION_DIR)) continue;
            return path.substring(SESSION_DIR_LEN);
        }
        return null;
    }

    static String rewritePath(String org_path, ServerInformation info) {
        if (info.getMultiStageSessionID() == null) {
            return org_path;
        }
        try {
            if (new URI(org_path).isAbsolute()) {
                return org_path;
            }
            if (org_path.charAt(0) == '/') {
                return org_path;
            }
            for (String part : org_path.split("/")) {
                int len = (part = part.split("\\?")[0]).length();
                if (len < EXT_LEN || !EXTENSION.equals(part.substring(len - EXT_LEN))) continue;
                return org_path;
            }
            return "../" + org_path;
        }
        catch (URISyntaxException uRISyntaxException) {
            return org_path;
        }
    }

    static String makeNewMSSPath(boolean ms_flag, HttpServletRequest req) {
        if (!ms_flag) {
            return null;
        }
        HttpSession org = req.getSession(true);
        String id = TransactionSequencer.getMSS(req);
        if (id != null) {
            if (MSSHolder.getHolder(org).isSession(id)) {
                return null;
            }
            Option.trace("MSS not found[id=%s]", id);
        }
        id = MSSHolder.getHolder(org).makeSession(org);
        Option.trace("MSS residect[id=%s]", id);
        String[] path = req.getRequestURI().split("/");
        StringBuilder buf = new StringBuilder();
        int cnt = path.length - 1;
        for (int i = 0; i < cnt; ++i) {
            if (path[i].indexOf(SESSION_DIR) == 0) continue;
            buf = buf.append(path[i]).append("/");
        }
        buf = buf.append(SESSION_DIR).append(id).append("/").append(path[cnt]);
        String query = req.getQueryString();
        if (query != null) {
            buf = buf.append("?").append(query);
        }
        return buf.toString();
    }

    static HttpSession getOriginSession(boolean ms_flag, HttpServletRequest req, boolean session_flag) {
        HttpSession origin = req.getSession(session_flag);
        if (!ms_flag || origin == null) {
            return origin;
        }
        String id = TransactionSequencer.getMSS(req);
        if (id == null) {
            return null;
        }
        MSSHolder holder = MSSHolder.getHolder(origin);
        if (holder == null) {
            return null;
        }
        origin = holder.getSession(id, session_flag);
        return origin;
    }

    static void replaceSession(HttpServletRequest req) {
        HttpSession origin = req.getSession(true);
        MSSHolder holder = MSSHolder.getHolder(origin);
        holder.replace_flag = true;
        origin.invalidate();
        origin = req.getSession(true);
        MSSHolder.replaceHolder(origin, holder);
        holder.replace_flag = false;
    }

    private static class MSSHolder
    implements HttpSessionBindingListener,
    HttpSessionActivationListener {
        private static final String MSS_KEY = "paraselene.multistage.session";
        private volatile boolean replace_flag = false;
        private HashMap<String, MSS> map = new HashMap();

        private static MSSHolder getHolder(HttpSession org) {
            MSSHolder holder = (MSSHolder)org.getAttribute(MSS_KEY);
            if (holder == null) {
                holder = new MSSHolder();
                org.setAttribute(MSS_KEY, (Object)holder);
            }
            return holder;
        }

        private static void replaceHolder(HttpSession org, MSSHolder holder) {
            org.setAttribute(MSS_KEY, (Object)holder);
        }

        private MSSHolder() {
        }

        private String makeSession(HttpSession org) {
            MSS mss = new MSS(org);
            String id = mss.getId();
            this.map.put(id, mss);
            return id;
        }

        private boolean isSession(String id) {
            return this.map.get(id) != null;
        }

        private MSS getSession(String id, boolean flag) {
            MSS mss = this.map.get(id);
            if (mss == null) {
                return null;
            }
            if (flag) {
                mss.init_f = false;
                mss.reset();
            }
            if (mss.init_f) {
                return null;
            }
            return mss;
        }

        private MSS[] toArray() {
            ArrayList<MSS> list = new ArrayList<MSS>();
            for (String key : this.map.keySet()) {
                list.add(this.map.get(key));
            }
            return list.toArray(new MSS[0]);
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            if (this.replace_flag) {
                return;
            }
            for (MSS mss : this.toArray()) {
                mss.unbound(event);
            }
        }

        public void sessionWillPassivate(HttpSessionEvent se) {
            if (this.replace_flag) {
                return;
            }
            for (MSS mss : this.toArray()) {
                mss.passivate(se);
            }
        }

        public void sessionDidActivate(HttpSessionEvent se) {
            if (this.replace_flag) {
                return;
            }
            for (MSS mss : this.toArray()) {
                mss.activate(se);
            }
        }
    }

    private static class MSS
    extends TestSession {
        private volatile boolean init_f = true;
        private HttpSession origin;
        private String top_id = Integer.valueOf(new Date().hashCode()).toString();

        private MSS(HttpSession org) {
            this.origin = org;
        }

        @Override
        public long getLastAccessedTime() throws IllegalStateException {
            return this.origin.getLastAccessedTime();
        }

        @Override
        public ServletContext getServletContext() {
            return this.origin.getServletContext();
        }

        @Override
        public void setMaxInactiveInterval(int interval) {
            this.origin.setMaxInactiveInterval(interval);
        }

        @Override
        public int getMaxInactiveInterval() {
            return this.origin.getMaxInactiveInterval();
        }

        @Override
        public boolean isNew() throws IllegalStateException {
            return this.init_f;
        }

        @Override
        public void invalidate() throws IllegalStateException {
            this.init_f = true;
            super.invalidate();
        }

        @Override
        public String getId() throws IllegalStateException {
            return new BigInteger(this.top_id + super.getId()).toString(36);
        }

        private Object[] toArray() {
            ArrayList<Object> list = new ArrayList<Object>();
            Enumeration<?> e = this.getAttributeNames();
            while (e.hasMoreElements()) {
                list.add(this.getAttribute((String)e.nextElement()));
            }
            return list.toArray(new Object[0]);
        }

        private void unbound(HttpSessionBindingEvent event) {
            for (Object o : this.toArray()) {
                if (!(o instanceof HttpSessionBindingListener)) continue;
                ((HttpSessionBindingListener)o).valueUnbound(event);
            }
        }

        private void passivate(HttpSessionEvent se) {
            for (Object o : this.toArray()) {
                if (!(o instanceof HttpSessionActivationListener)) continue;
                ((HttpSessionActivationListener)o).sessionWillPassivate(se);
            }
        }

        private void activate(HttpSessionEvent se) {
            for (Object o : this.toArray()) {
                if (!(o instanceof HttpSessionActivationListener)) continue;
                ((HttpSessionActivationListener)o).sessionDidActivate(se);
            }
        }
    }
}

