/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import paraselene.Page;
import paraselene.supervisor.AjaxForward;
import paraselene.supervisor.CometCall;
import paraselene.supervisor.DialogType;
import paraselene.supervisor.Forward;
import paraselene.supervisor.History;
import paraselene.supervisor.OpenCometCall;
import paraselene.supervisor.OpenOutput;
import paraselene.supervisor.Option;
import paraselene.supervisor.OutputCall;
import paraselene.supervisor.PageFactory;
import paraselene.supervisor.PageID;
import paraselene.supervisor.RequestParameter;
import paraselene.supervisor.SandBox;
import paraselene.supervisor.SessionData;
import paraselene.tag.Tag;

public class Popup
extends Forward
implements AjaxForward {
    private static final long serialVersionUID = 2L;
    Page active_page = null;
    Page view_page = null;
    private DialogType type;

    @Override
    boolean is_refresh() {
        return this.view_page != null;
    }

    Popup(PageID id, DialogType dialog_type) {
        super(id);
        this.type = dialog_type;
        if (SandBox.isCurrentDaemon()) {
            return;
        }
        this.initType(SandBox.getCurrentRequestParameter().getHistory());
    }

    public Popup(PageID id, Type dialog_type) {
        this(id, (DialogType)dialog_type);
    }

    void initType(History hist) {
        if (Popup.isModelessAlert(this.type, hist, false)) {
            this.overwriteType(Type.MODAL);
        }
    }

    Popup(Page page, DialogType dialog_type) {
        this(page.getParentPage().getID(), dialog_type);
        page = page.getParentPage();
        if (page.getPopupType() != null) {
            this.active_page = page;
        } else {
            this.view_page = page;
        }
    }

    public Popup(Page page, Type dialog_type) {
        this(page, (DialogType)dialog_type);
    }

    static boolean isModeless(DialogType mine) {
        if (mine == null) {
            return false;
        }
        return !mine.isMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isModelessAlert(DialogType mine, History hist, boolean unlock_f) {
        if (hist == null) {
            return false;
        }
        if (mine == null) {
            return false;
        }
        if (mine.isMode()) {
            return false;
        }
        try {
            Page[] page = hist.getBrowsingPage();
            for (int i = 0; i < page.length; ++i) {
                DialogType ptype = page[i].getPopupType();
                if (ptype == null || !ptype.isMode()) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (unlock_f) {
                hist.unlock();
            }
        }
        return false;
    }

    public Popup(Page page) {
        this(page, Type.MODELESS);
    }

    @Override
    Page getPage(PageFactory pf, Page from) {
        if (this.active_page != null) {
            Option.trace("Popup#getPage -> %s", this.active_page.getUniqueKey());
            return this.active_page;
        }
        if (this.out_page == null) {
            Option.trace("Popup#getPage -> null", new Object[0]);
            return null;
        }
        if (this.view_page != null) {
            Option.trace("Popup#getPage -> %s", this.view_page.getUniqueKey());
            return this.view_page;
        }
        Page p = pf.getPage(this.out_page.getID());
        Option.trace("Popup#getPage -> %s", p.getUniqueKey());
        return p;
    }

    void overwriteType(DialogType t) {
        if (this.type == null) {
            return;
        }
        if (!t.isMode()) {
            return;
        }
        this.type = t;
    }

    DialogType getType() {
        return this.type;
    }

    @Override
    public boolean equals(Object o) {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("Popup ");
        if (this.active_page != null) {
            buf = buf.append("active:");
            buf = buf.append(this.active_page.getID().toString());
            buf = buf.append("/").append(this.active_page.getUniqueKey());
        } else {
            buf = buf.append("open:");
            if (this.view_page == null) {
                buf = buf.append(this.getPageID().toString());
            } else {
                buf = buf.append(this.view_page.getID().toString());
                buf = buf.append("/").append(this.view_page.getUniqueKey());
            }
            buf = buf.append("/").append(this.type.toString());
        }
        return buf.toString();
    }

    Tag getHint() {
        return null;
    }

    @Override
    OutputCall makeOutput(PageFactory pf, int nk, Page lp, RequestParameter r, SessionData sd) {
        Option.trace("new OpenOutput <- %s", this);
        return new OpenOutput(pf, nk, lp, this, this.getType(), this.getHint(), r, sd);
    }

    @Override
    CometCall makeCometCall(PageFactory pf, History h) {
        Option.trace("new OpenCometCall <- %s", this);
        return new OpenCometCall(pf, h, this, this.getType());
    }

    public static enum Type implements DialogType
    {
        MODELESS(false, true),
        MODAL(true, true),
        LITE_MODAL(true, false);

        private boolean modal_f;
        private boolean move_f;

        private Type(boolean md_f, boolean mv_f) {
            this.modal_f = md_f;
            this.move_f = mv_f;
        }

        @Override
        public boolean isTitle() {
            return this.move_f;
        }

        @Override
        public boolean isMode() {
            return this.modal_f;
        }

        @Override
        public boolean isAutoClose() {
            return false;
        }

        @Override
        public DialogType.Position getPosition() {
            return DialogType.Position.CENTER;
        }

        public static boolean isMode(Page page) {
            DialogType ptype = page.getPopupType();
            if (ptype == null) {
                return false;
            }
            return ptype.isMode();
        }

        public static boolean isAutoClose(Page page) {
            DialogType ptype = page.getPopupType();
            if (ptype == null) {
                return false;
            }
            return ptype.isAutoClose();
        }
    }
}

