/*
 * Decompiled with CFR 0.152.
 */
package paraselene.mockup;

import java.util.ArrayList;
import paraselene.mockup.FunctionInfo;
import paraselene.mockup.JavaDefine;
import paraselene.mockup.Make;
import paraselene.mockup.PrePage;
import paraselene.mockup.TagSource;
import paraselene.tag.Attribute;
import paraselene.tag.Tag;
import paraselene.tag.table.Column;
import paraselene.tag.table.Line;
import paraselene.tag.table.Table;

class TableSource
extends TagSource {
    private Table table = null;
    private String table_name = null;
    private String enum_name = null;
    private static final String URL_TOP = "http://paraselene.sourceforge.jp/api2/paraselene/tag/table/Table.html#";

    TableSource(String html) {
        super(html, "table", false);
    }

    private void build(ArrayList<TableEnum> list) {
        this.table = new Table();
        Tag[] line = this.getTagArray();
        for (int i = 0; i < line.length; ++i) {
            String name = line[i].getName();
            if (!"tr".equals(name)) continue;
            Line copy = new Line();
            Tag[] clm = line[i].getTagArray();
            for (int j = 0; j < clm.length; ++j) {
                String name2 = clm[j].getName();
                Column.Type type = null;
                if ("th".equals(name2)) {
                    type = Column.Type.HEADER;
                } else if ("td".equals(name2)) {
                    type = Column.Type.DATA;
                }
                if (type == null) continue;
                Column copy2 = new Column(type);
                Attribute[] attr = clm[j].getAllAttribute();
                for (int k = 0; k < attr.length; ++k) {
                    copy2.setAttribute(attr[k].getReplica());
                }
                copy.addColumn(copy2);
            }
            this.table.addLine(copy);
        }
        try {
            int xsize = this.table.getXsize();
            int ysize = this.table.getYsize();
            for (int y = 0; y < ysize; ++y) {
                for (int x = 0; x < xsize; ++x) {
                    TableEnum te;
                    Column clm;
                    String id;
                    if (this.table.isJoinedColumn(x, y) || (id = (clm = this.table.getColumn(x, y)).getAttributeToString("id")) == null || (id = id.trim()).isEmpty() || id.indexOf("paraselene") >= 0) continue;
                    if (JavaDefine.isDefine(id, true)) {
                        System.err.println("id " + id + " \u306f\u4f7f\u7528\u3067\u304d\u306a\u3044\u6587\u5b57\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002");
                        System.exit(1);
                    }
                    if (list.contains(te = new TableEnum(id, x))) {
                        System.err.println("\u540c\u4e00id " + id + " \u304c\u5b58\u5728\u3057\u307e\u3059\u3002");
                        System.exit(1);
                    }
                    list.add(te);
                }
            }
        }
        catch (Table.TableException e) {
            System.err.println(this.toString());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private String setName(String name) {
        this.table_name = name;
        if (this.table_name == null) {
            return null;
        }
        this.table_name = PrePage.name2CamelCase(this.table_name);
        if (this.table_name.isEmpty()) {
            this.table_name = null;
            return null;
        }
        return this.table_name;
    }

    String getEnum(boolean one) {
        String name = this.getAttributeToString("name");
        if (this.setName(name) == null) {
            return "";
        }
        ArrayList<TableEnum> list = new ArrayList<TableEnum>();
        this.build(list);
        int cnt = list.size();
        if (cnt == 0) {
            return "";
        }
        this.enum_name = this.table_name + "X";
        StringBuilder buf = PrePage.getCom(name, " \u30c6\u30fc\u30d6\u30eb\u5217\u30a2\u30af\u30bb\u30c3\u30b5", this);
        buf = buf.append(" enum ");
        buf = buf.append(this.enum_name);
        buf = buf.append("{\n");
        for (int i = 0; i < cnt; ++i) {
            TableEnum te = list.get(i);
            buf = buf.append(te.id);
            buf = buf.append("(");
            buf = buf.append(Integer.toString(te.no));
            buf = buf.append(")");
            buf = i == cnt - 1 ? buf.append(";\n") : buf.append(",\n");
        }
        buf = buf.append("private int paraselene$no;\nprivate ");
        buf = buf.append(this.enum_name);
        buf = buf.append("(int n){ paraselene$no = n; }\n");
        buf = buf.append((CharSequence)PrePage.getCom(name, "\u30a4\u30f3\u30c7\u30c3\u30af\u30b9", null));
        buf = buf.append("int get(){ return paraselene$no; }\n");
        buf = buf.append("}\n");
        return buf.append((CharSequence)this.getAccesser(name, one)).toString();
    }

    private String makeLink(String title) {
        String func = title.split("\\(")[0];
        StringBuilder buf = new StringBuilder("\u7528");
        buf = buf.append(func);
        buf = buf.append(".\u8a73\u3057\u304f\u306f <a href='");
        buf = buf.append(URL_TOP);
        buf = buf.append(title);
        buf = buf.append("' target='_blank'>");
        buf = buf.append(func);
        buf = buf.append("</a> \u3092\u53c2\u7167\u3057\u3066\u4e0b\u3055\u3044.<br>\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u3092\u30e9\u30c3\u30d7\u3057\u307e\u3059");
        return buf.toString();
    }

    private StringBuilder makeGet1(String name, String ret) {
        StringBuilder buf = new StringBuilder("Table table=(Table)getTag(");
        buf = buf.append(Make.escape(name));
        buf = buf.append(");\n");
        buf = buf.append("if (table==null) return ");
        buf = buf.append(ret);
        buf = buf.append(";\n");
        return buf;
    }

    private StringBuilder makeGetAll(String name, String ret) {
        StringBuilder buf = new StringBuilder("Tag[] tag=getAllTag(");
        buf = buf.append(Make.escape(name));
        buf = buf.append(");\n");
        buf = buf.append("if (tag==null) return ");
        buf = buf.append(ret);
        buf = buf.append(";\n");
        buf = buf.append(" if (no<0 || no>=tag.length) return ");
        buf = buf.append(ret);
        buf = buf.append(";\n");
        buf = buf.append("Table table=(Table)tag[no];\n");
        return buf;
    }

    private StringBuilder isJoinedColumn(String name, boolean one) {
        String func = "boolean isJoinedColumn4" + this.table_name + "(";
        StringBuilder buf = new StringBuilder();
        StringBuilder com = PrePage.getCom(name, this.makeLink("isJoinedColumn(int, int)"), null);
        if (one) {
            buf = buf.append((CharSequence)com);
            buf = buf.append(func);
            buf = buf.append(this.enum_name);
            buf = buf.append(" x,int y)throws Table.TableException{\n");
            buf = buf.append((CharSequence)this.makeGet1(name, "false"));
            buf = buf.append("return table.isJoinedColumn(x.get(),y);\n}\n");
        }
        buf = buf.append((CharSequence)com);
        buf = buf.append(func);
        buf = buf.append("int no,");
        buf = buf.append(this.enum_name);
        buf = buf.append(" x,int y)throws Table.TableException{\n");
        buf = buf.append((CharSequence)this.makeGetAll(name, "false"));
        buf = buf.append("return table.isJoinedColumn(x.get(),y);\n}\n");
        return buf;
    }

    private StringBuilder getColumn(String name, boolean one) {
        String func = "Column getColumn4" + this.table_name + "(";
        StringBuilder buf = new StringBuilder();
        StringBuilder com = PrePage.getCom(name, this.makeLink("getColumn(int, int)"), null);
        if (one) {
            buf = buf.append((CharSequence)com);
            buf = buf.append(func);
            buf = buf.append(this.enum_name);
            buf = buf.append(" x,int y)throws Table.TableException{\n");
            buf = buf.append((CharSequence)this.makeGet1(name, "null"));
            buf = buf.append("return table.getColumn(x.get(),y);\n}\n");
        }
        buf = buf.append((CharSequence)com);
        buf = buf.append(func);
        buf = buf.append("int no,");
        buf = buf.append(this.enum_name);
        buf = buf.append(" x,int y)throws Table.TableException{\n");
        buf = buf.append((CharSequence)this.makeGetAll(name, "null"));
        buf = buf.append("return table.getColumn(x.get(),y);\n}\n");
        return buf;
    }

    private StringBuilder joinColumn(String name, boolean one) {
        String func = "void joinColumn4" + this.table_name + "(";
        StringBuilder buf = new StringBuilder();
        StringBuilder com = PrePage.getCom(name, this.makeLink("joinColumn(int, int, int, int)"), null);
        if (one) {
            buf = buf.append((CharSequence)com);
            buf = buf.append(func);
            buf = buf.append(this.enum_name);
            buf = buf.append(" x,int y,int xsize,int ysize)throws Table.TableException{\n");
            buf = buf.append((CharSequence)this.makeGet1(name, ""));
            buf = buf.append("table.joinColumn(x.get(),y,xsize,ysize);\n}\n");
        }
        buf = buf.append((CharSequence)com);
        buf = buf.append(func);
        buf = buf.append("int no,");
        buf = buf.append(this.enum_name);
        buf = buf.append(" x,int y,int xsize,int ysize)throws Table.TableException{\n");
        buf = buf.append((CharSequence)this.makeGetAll(name, ""));
        buf = buf.append("table.joinColumn(x.get(),y,xsize,ysize);\n}\n");
        return buf;
    }

    private StringBuilder getAccesser(String name, boolean one) {
        StringBuilder buf = new StringBuilder();
        buf = buf.append((CharSequence)this.isJoinedColumn(name, one));
        buf = buf.append((CharSequence)this.getColumn(name, one));
        buf = buf.append((CharSequence)this.joinColumn(name, one));
        return buf;
    }

    String getOneAccesser(FunctionInfo info, String seek, boolean one) {
        String name = this.getAttributeToString("name");
        if (this.setName(name) == null) {
            return "";
        }
        if (this.getFirstInnerHTMLPart(this.getAssignedPage().getAllTag(seek)) == null) {
            return "";
        }
        StringBuilder func = new StringBuilder(info.class_name);
        func = func.append(" ");
        func = func.append(info.func_name);
        func = func.append("4");
        func = func.append(this.table_name);
        func = func.append("(");
        StringBuilder buf = new StringBuilder();
        StringBuilder com = PrePage.getCom(name, "\u7528" + info.func_name, null);
        if (one) {
            buf = buf.append((CharSequence)com);
            buf = buf.append((CharSequence)func);
            buf = buf.append("int y)throws Table.TableException{\n");
            buf = buf.append((CharSequence)this.makeGet1(name, "null"));
            buf = buf.append("return (");
            buf = buf.append(info.class_name);
            buf = buf.append(")table.getFirstInnerHTMLPart(y,getAllTag(");
            buf = buf.append(Make.escape(seek));
            buf = buf.append("));\n}\n");
        }
        buf = buf.append((CharSequence)com);
        buf = buf.append((CharSequence)func);
        buf = buf.append("int no,int y)throws Table.TableException{\n");
        buf = buf.append((CharSequence)this.makeGetAll(name, "null"));
        buf = buf.append("return (");
        buf = buf.append(info.class_name);
        buf = buf.append(")table.getFirstInnerHTMLPart(y,getAllTag(");
        buf = buf.append(Make.escape(seek));
        buf = buf.append("));\n}\n");
        return buf.toString();
    }

    private class TableEnum {
        String id;
        int no;

        TableEnum(String id, int no) {
            this.id = id;
            this.no = no;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TableEnum)) {
                return false;
            }
            TableEnum te = (TableEnum)o;
            return te.id.equals(this.id);
        }
    }
}

