/*
 * Decompiled with CFR 0.152.
 */
package paraselene.dyna;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import paraselene.dyna.CreateParam;
import paraselene.dyna.DynamicPage;
import paraselene.dyna.DynamicPageReloader;
import paraselene.dyna.Loader;

class URLLoader
extends Loader {
    private HashMap<URL, Long> lasttime = new HashMap();
    private HashMap<URL, Long> timestamp = new HashMap();

    URLLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTime(URL url) throws Exception {
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)url.openConnection();
            con.setInstanceFollowRedirects(true);
            con.setRequestMethod("HEAD");
            con.connect();
            long ret = con.getLastModified();
            if (ret == 0L) {
                long l = new Date().getTime();
                return l;
            }
            long l = ret;
            return l;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    @Override
    void load(CreateParam cp, LinkedList<DynamicPage> list) {
        long now = new Date().getTime();
        long fix = now - (long)DynamicPageReloader.url_interval;
        URL key = cp.url;
        Long old = this.lasttime.get(key);
        try {
            if (old == null) {
                Long tm = this.getTime(key);
                this.lasttime.put(key, now);
                this.timestamp.put(key, tm);
                this.loopset(cp, list);
                list.wait(10000L);
                return;
            }
            Long tm = this.timestamp.get(key);
            if (old > fix) {
                tm = this.getTime(key);
                this.lasttime.put(key, now);
                this.timestamp.put(key, tm);
            }
            this.loopset(cp, list, tm);
            if (old > fix) {
                list.wait(10000L);
            }
            return;
        }
        catch (Exception e) {
            cp.setError(e);
            this.lasttime.put(key, now);
            this.loopset(cp, list);
            return;
        }
    }
}

