/*
 * Decompiled with CFR 0.152.
 */
package paraselene.ajax.data;

import java.io.Serializable;
import java.util.ArrayList;
import paraselene.HTMLPart;
import paraselene.Page;
import paraselene.ajax.data.JsonWriter;
import paraselene.supervisor.SandBox;
import paraselene.tag.Tag;
import paraselene.ui.PageBypassedDiv;
import paraselene.ui.PageHooker;

public class TagData
implements Serializable {
    private static final long serialVersionUID = 2L;
    public String id = "";
    public String body = "";
    public String[] cmd = null;
    public boolean over_f = false;

    TagData() {
    }

    TagData(Tag tag) {
        this(tag, true);
    }

    private void init(Tag tag) {
        int i;
        Page page = tag.getAssignedPage();
        if (SandBox.isCurrentDaemon()) {
            PageHooker[] org = page.getPageHooker();
            PageHooker[] hook = tag.getInnerHTMLPart(org);
            for (i = 0; i < hook.length; ++i) {
                hook[i].commitDaemon();
            }
            for (i = 0; i < org.length; ++i) {
                if (!(org[i] instanceof PageBypassedDiv)) continue;
                org[i].commitDaemon();
            }
        }
        int cnt = tag.getHTMLPartCount();
        JsonWriter w = new JsonWriter();
        for (i = 0; i < cnt; ++i) {
            tag.getHTMLPart(i).write(w, HTMLPart.StringMode.BODY);
        }
        this.body = w.toString();
        page = page.getParentPage();
        this.cmd = new String[]{page.getOnLoadScript()};
        page.resetOnLoadScript();
        tag.resetModify();
    }

    TagData(Tag tag, boolean flag) {
        this.id = tag.getAttributeToString("id");
        if (tag instanceof PageBypassedDiv) {
            tag.resetModify();
            PageBypassedDiv div = (PageBypassedDiv)tag;
            Page page = div.getViewPage();
            if (page == null) {
                return;
            }
            tag = page.getBodyTag();
            if (tag == null) {
                return;
            }
        }
        if (flag) {
            this.init(tag);
        }
    }

    public static TagData[] getTag(Page org, Page out) {
        ArrayList<TagData> list = new ArrayList<TagData>();
        if (org == out) {
            Tag[] tag = out.getModifiedTag();
            for (int i = 0; i < tag.length; ++i) {
                list.add(new TagData(tag[i]));
            }
            int cnt = list.size();
            if (cnt > 1) {
                ((TagData)list.get((int)(cnt - 1))).cmd = ((TagData)list.get((int)0)).cmd;
                ((TagData)list.get((int)0)).cmd = null;
            }
        } else {
            TagData td = new TagData(out.getBodyTag());
            td.id = org.getRootID();
            list.add(td);
        }
        return list.toArray(new TagData[0]);
    }
}

