/*
 * Decompiled with CFR 0.152.
 */
package paraselene.ui;

import java.io.PrintWriter;
import java.util.ArrayList;
import paraselene.HTMLPart;
import paraselene.Page;
import paraselene.supervisor.Forward;
import paraselene.supervisor.History;
import paraselene.supervisor.PageServerInformation;
import paraselene.supervisor.RequestParameter;
import paraselene.tag.Tag;
import paraselene.ui.PageHooker;

public class PageBypassedDiv
extends Tag
implements PageHooker {
    private static final long serialVersionUID = 2L;
    private Page link_page;
    private Page view_page;

    public PageBypassedDiv() {
        super("div", false);
        this.makeID();
    }

    private static void setPageServerInformation(Page p, PageServerInformation psi) {
        if (p == null) {
            return;
        }
        PageBypassedDiv[] pbd = p.getPageBypassedDiv();
        for (int i = 0; i < pbd.length; ++i) {
            PageBypassedDiv.setPageServerInformation(pbd[i].getBypassPage(), psi);
        }
        p.setPageServerInformation(psi);
    }

    public void setBypassPage(History history, Page page) {
        if (this.link_page == page) {
            return;
        }
        this.setModifyMyselef();
        PageBypassedDiv.setPageServerInformation(this.link_page, null);
        history.removeSatellitePage(this.link_page);
        this.view_page = page;
        this.link_page = page;
        if (page != null) {
            Page ap = this.getAssignedPage();
            PageServerInformation psi = ap.getPageServerInformation();
            PageBypassedDiv.setPageServerInformation(page, psi);
            page.setParentPage(ap);
            history.addSatellitePage(page);
        }
    }

    @Override
    public Forward beforeInput(Page page, RequestParameter req, Forward fw) throws Exception {
        return fw;
    }

    @Override
    public void afterOutput(Page from, Page to, RequestParameter req) throws Exception {
        this.commitDaemon();
    }

    @Override
    public void commitDaemon() {
        if (this.view_page == null) {
            return;
        }
        this.getAssignedPage().addOnLoadScript(this.view_page.getOnLoadScript());
        this.view_page.resetOnLoadScript();
    }

    public Page getBypassPage() {
        return this.link_page;
    }

    public Page getViewPage() {
        return this.view_page;
    }

    @Override
    public void write(PrintWriter w, HTMLPart.StringMode mode) {
        Tag body;
        if (!this.isVisible()) {
            return;
        }
        this.resetModify();
        w.print(this.getFirstTag());
        if (this.view_page != null && (body = this.view_page.getBodyTag()) != null) {
            int cnt = body.getHTMLPartCount();
            if (mode != HTMLPart.StringMode.TEXTAREA) {
                mode = HTMLPart.StringMode.BODY;
            }
            for (int i = 0; i < cnt; ++i) {
                body.getHTMLPart(i).write(w, mode);
            }
        }
        w.print(this.getLastTag());
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        if (this.view_page == null) {
            return false;
        }
        Tag body = this.view_page.getBodyTag();
        if (body == null) {
            return false;
        }
        if (!body.isModified()) {
            return false;
        }
        body.resetModify();
        this.setModifyMyselef();
        return true;
    }

    @Override
    protected void getModifiedTag(ArrayList<Tag> list) {
        if (this.view_page == null) {
            return;
        }
        Tag body = this.view_page.getBodyTag();
        if (body != null) {
            if (this.isModified()) {
                list.add(this);
                return;
            }
            Tag[] tag = body.getModifiedTag();
            for (int i = 0; i < tag.length; ++i) {
                list.add(tag[i]);
            }
        }
    }

    public void setView(Page view2) {
        this.view_page = view2;
        if (this.view_page == null) {
            this.view_page = this.link_page;
        }
        if (this.view_page != this.link_page) {
            System.out.println("setView diff");
        }
    }
}

