/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag.form;

import java.util.ArrayList;
import java.util.HashMap;
import paraselene.HTMLPart;
import paraselene.Page;
import paraselene.supervisor.Forward;
import paraselene.supervisor.RequestItem;
import paraselene.supervisor.RequestParameter;
import paraselene.tag.Attribute;
import paraselene.tag.Tag;
import paraselene.tag.form.Button;
import paraselene.tag.form.CheckBox;
import paraselene.tag.form.Control;
import paraselene.tag.form.FormSeq;
import paraselene.tag.form.Input;
import paraselene.tag.form.RadioGroup;
import paraselene.tag.form.Select;
import paraselene.tag.form.UploadFile;
import paraselene.ui.PageHooker;

public class Form
extends Tag
implements PageHooker {
    private static final long serialVersionUID = 2L;
    public static final String FORM_ID = "paraselene$form$id";
    public static final String FORM_AJAX = "paraselene_form_ajax";
    public static final String FORM_DUMMY = "paraselene_dummy";
    public static final String PAGE_UKEY = "paraselene_page_ukey";
    public static final String MULTI_PART = "multipart/form-data";
    private static HashMap<String, String> skip_name = new HashMap();
    private static FormSeq form_seq = new FormSeq();
    private String seq = "-1";
    private HashMap<String, HashMap<String, Control>> control = new HashMap();
    private boolean fixed_f = false;
    private Input form_ukey = Input.createHidden("paraselene$form$id", "-1");
    private Input page_ukey = Input.createHidden("paraselene_page_ukey", "-1");

    public static boolean isFixedName(String name) {
        return skip_name.get(name) != null;
    }

    public boolean isContained(Control cont) {
        String name = cont.getNameAttribute();
        if (name == null) {
            return false;
        }
        HashMap<String, Control> map = this.control.get(Page.getIndexName(name));
        if (map == null) {
            return false;
        }
        return map.get(name) == cont;
    }

    public Form() {
        super("form", false);
        HTMLPart[] id = new Input[]{this.form_ukey, Input.createHidden(FORM_AJAX, "-1"), Input.createHidden(FORM_DUMMY, "-1"), this.page_ukey};
        this.addHTMLPart(id);
        this.setAttribute("method", "POST");
        this.setID();
        this.fixed_f = true;
    }

    @Override
    public void addHTMLPart(int idx, HTMLPart d) {
        Input ip;
        String name;
        if (this.fixed_f && d instanceof Input && Form.isFixedName(name = (ip = (Input)d).getNameAttribute())) {
            return;
        }
        super.addHTMLPart(idx, d);
    }

    @Override
    public Forward beforeInput(Page page, RequestParameter req, Forward fw) throws Exception {
        return fw;
    }

    private void setID() {
        this.seq = form_seq.getSeq();
        this.form_ukey.setValueString(this.seq);
    }

    @Override
    public void afterOutput(Page from, Page to, RequestParameter req) throws Exception {
        this.commitDaemon();
        Page my_page = this.getAssignedPage();
        if (my_page.isAjax() && "-1".equals(this.page_ukey.getValueString())) {
            this.page_ukey.setValueString(my_page.getUniqueKey());
        } else if (!"-1".equals(this.page_ukey.getValueString())) {
            this.page_ukey.setValueString("-1");
        }
    }

    @Override
    public void commitDaemon() {
        StringBuilder buf = new StringBuilder("function(ev){");
        buf = buf.append("if(paraselene.form_kill)return;");
        buf = buf.append("if(!paraselene.agency_form(paraselene.get_id('");
        buf = buf.append(this.makeID());
        buf = buf.append("'),'");
        buf = buf.append(this.getAssignedPage().getUniqueKey());
        buf = buf.append("'))paraselene.kill_event(ev);}");
        this.setAnonymousEventHandler("submit", buf.toString());
    }

    @Override
    protected Tag newReplica() {
        return new Form();
    }

    public void checkTag4rm(Tag tag) {
        Tag[] in_tag = tag.getTagArray();
        for (int i = 0; i < in_tag.length; ++i) {
            this.checkTag4rm(in_tag[i]);
        }
        if (!(tag instanceof Control)) {
            return;
        }
        Control ctl = (Control)tag;
        String name = ctl.getNameAttribute();
        if (name == null) {
            return;
        }
        String idx = Page.getIndexName(name);
        HashMap<String, Control> map = this.control.get(idx);
        if (map == null) {
            return;
        }
        map.remove(name);
        if (map.size() == 0) {
            this.control.remove(idx);
        }
    }

    public String getID() {
        return this.seq;
    }

    public Control[] getAllControl() {
        ArrayList<Control> list = new ArrayList<Control>();
        for (String all_k : this.control.keySet()) {
            HashMap<String, Control> map = this.control.get(all_k);
            for (String map_k : map.keySet()) {
                list.add(map.get(map_k));
            }
        }
        return list.toArray(new Control[0]);
    }

    public Control[] getAllControl(String name) {
        ArrayList<Control> list = new ArrayList<Control>();
        HashMap<String, Control> map = this.control.get(Page.getIndexName(name));
        if (map != null) {
            for (String map_k : map.keySet()) {
                list.add(map.get(map_k));
            }
        }
        return list.toArray(new Control[0]);
    }

    public Control getControl(String name) {
        Control[] ctl = this.getAllControl(name);
        if (ctl.length != 1) {
            return null;
        }
        return ctl[0];
    }

    public void checkTag(Tag tag) {
        Tag[] in_tag = tag.getTagArray();
        for (int i = 0; i < in_tag.length; ++i) {
            this.checkTag(in_tag[i]);
        }
        if (!(tag instanceof Control)) {
            return;
        }
        Control ctl = (Control)tag;
        String name = ctl.getNameAttribute();
        if (name == null) {
            return;
        }
        String idx = Page.getIndexName(name);
        HashMap<String, Control> map = this.control.get(idx);
        if (map == null) {
            map = new HashMap();
            this.control.put(idx, map);
        }
        map.put(name, ctl);
        if (!(ctl instanceof Input)) {
            return;
        }
        Input inp = (Input)ctl;
        Attribute attr = inp.getAttribute("type");
        if (attr == null) {
            return;
        }
        String val = attr.getString();
        if (val == null) {
            return;
        }
        if ("file".equals(val)) {
            try {
                this.setAttribute(new Attribute("method", "POST"), new Attribute("enctype", MULTI_PART));
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
    }

    public ArrayList<Control> reflect(RequestParameter req) {
        String old;
        CheckBox cbox;
        Control[] cont = this.getAllControl();
        ArrayList<Control> set = new ArrayList<Control>();
        HashMap<String, CheckBox> after = new HashMap<String, CheckBox>();
        for (int i = 0; i < cont.length; ++i) {
            int j;
            int item_cnt;
            RequestItem item;
            String name = cont[i].getNameAttribute();
            if (name == null || skip_name.get(name) != null) continue;
            cbox = null;
            if (cont[i] instanceof CheckBox && (cbox = (CheckBox)cont[i]).isRadio()) {
                after.put(Page.getIndexName(name), cbox);
                continue;
            }
            Button button = null;
            if (cont[i] instanceof Button) {
                button = (Button)cont[i];
                button.setClicked(false);
            }
            if ((item = req.getItem(name)) == null) {
                if (cbox != null) {
                    if (cbox.isDisabled() || !cbox.isChecked()) continue;
                    set.add(cbox);
                    cbox.setChecked(false);
                    continue;
                }
                if (button != null || cont[i].isDisabled()) continue;
                old = cont[i].getValueString();
                if (old != null && !old.isEmpty()) {
                    set.add(cbox);
                }
                cont[i].setValueString(null);
                continue;
            }
            if (button != null) {
                button.setClicked(true);
                set.add(button);
                continue;
            }
            if (cbox != null) {
                if (cbox.isChecked()) continue;
                set.add(cbox);
                cbox.setChecked(true);
                continue;
            }
            if (cont[i] instanceof UploadFile) {
                UploadFile uf = (UploadFile)cont[i];
                set.add(uf);
                uf.setRequest(item);
                continue;
            }
            if (cont[i] instanceof Select) {
                Select sel = (Select)cont[i];
                if (sel.isSameSet(item.getAllValue())) continue;
                set.add(sel);
                sel.setValueString(null);
                item_cnt = item.getCount();
                for (j = 0; j < item_cnt; ++j) {
                    cont[i].setValueString(item.getValue(j));
                }
                continue;
            }
            old = cont[i].getValueString();
            if (old == null) {
                old = "";
            }
            item_cnt = item.getCount();
            for (j = 0; j < item_cnt; ++j) {
                String val = item.getValue(j);
                if (val == null) {
                    val = "";
                }
                if (val.equals(old)) continue;
                set.add(cont[i]);
                cont[i].setValueString(val);
            }
        }
        for (String k : after.keySet()) {
            cbox = this.getChecked(k);
            RequestItem item = req.getItem(k);
            if (item == null) {
                if (cbox == null) continue;
                set.add(cbox);
                CheckBox.setRadio(this, k, null);
                continue;
            }
            int item_cnt = item.getCount();
            old = CheckBox.getRadio(this, k);
            for (int j = 0; j < item_cnt; ++j) {
                String val = item.getValue(j);
                if (val.equals(old)) continue;
                CheckBox.setRadio(this, k, item.getValue(j));
            }
            CheckBox now = this.getChecked(k);
            if (now == cbox) continue;
            set.add(now);
        }
        int cnt = set.size();
        HashMap<RadioGroup, RadioGroup> radio = new HashMap<RadioGroup, RadioGroup>();
        for (int i = cnt - 1; i >= 0; --i) {
            CheckBox cb;
            RadioGroup gr;
            Control c = (Control)set.get(i);
            if (!(c instanceof CheckBox) || (gr = (cb = (CheckBox)c).getRadioGroup()) == null) continue;
            radio.put(gr, gr);
            set.remove(i);
        }
        for (RadioGroup gr : radio.keySet()) {
            set.add(gr);
        }
        return set;
    }

    private CheckBox getChecked(String name) {
        Control[] tag = this.getAllControl(name);
        for (int i = 0; i < tag.length; ++i) {
            CheckBox cbox;
            if (!(tag[i] instanceof CheckBox) || !(cbox = (CheckBox)tag[i]).isRadio() || !cbox.isChecked()) continue;
            return cbox;
        }
        return null;
    }

    static {
        skip_name.put(FORM_ID, FORM_ID);
        skip_name.put(FORM_AJAX, FORM_AJAX);
        skip_name.put(FORM_DUMMY, FORM_DUMMY);
        skip_name.put(PAGE_UKEY, PAGE_UKEY);
    }
}

