/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import paraselene.supervisor.History;
import paraselene.supervisor.HistorySet;
import paraselene.supervisor.Option;
import paraselene.supervisor.RequestItem;
import paraselene.supervisor.SandBox;
import paraselene.supervisor.SessionData;
import paraselene.supervisor.Supervisor;

public class RequestParameter
implements Serializable {
    private static final long serialVersionUID = 2L;
    private HashMap<String, RequestItem> item_map = new HashMap();
    private Method method = Method.GET;
    private URI uri = null;
    private URI sub_uri = null;
    private String context_path = null;
    private HttpSession session = null;
    private Cookie[] in_cookie = null;
    private String remote_addr = null;
    private HashMap<String, String[]> header = new HashMap();
    private Supervisor supervisor = null;
    static final String UA_HEAD = "User-Agent";
    private static final String AJAX_CALLED = "paraselene$ajax$called";

    public static Mobile judgeMobile(String ua) {
        if (ua == null) {
            return Mobile.NO_MOBILE;
        }
        if (ua.indexOf("DoCoMo") != -1) {
            return Mobile.DOCOMO;
        }
        if (ua.indexOf("KDDI") != -1) {
            return Mobile.AU;
        }
        if (ua.indexOf("emobile") != -1) {
            return Mobile.EMOBILE;
        }
        if (ua.indexOf("SoftBank") != -1 || ua.indexOf("Vodafone") != -1 || ua.indexOf("J-PHONE") != -1) {
            return Mobile.J_PHONE;
        }
        if (ua.indexOf("UP.Browser") != -1) {
            return Mobile.TU_KA;
        }
        return Mobile.NO_MOBILE;
    }

    public static SearchEngine judgeSearchEngine(String ua) {
        if (ua == null) {
            return SearchEngine.NO_SEARCHENGINE;
        }
        SearchEngine[] dim = SearchEngine.values();
        ua = ua.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < dim.length; ++i) {
            if (!dim[i].isHit(ua)) continue;
            return dim[i];
        }
        return SearchEngine.NO_SEARCHENGINE;
    }

    public void markAjaxCalled() {
        if (this.session == null) {
            return;
        }
        this.session.setAttribute(AJAX_CALLED, (Object)new Boolean(true));
    }

    public boolean wasUsedAjax() {
        if (this.session == null) {
            return false;
        }
        return this.session.getAttribute(AJAX_CALLED) != null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RequestParameter)) {
            return false;
        }
        RequestParameter r = (RequestParameter)o;
        if (!this.uri.equals(r.uri)) {
            return false;
        }
        HashMap<String, RequestItem> ok = new HashMap<String, RequestItem>();
        for (String k : this.item_map.keySet()) {
            RequestItem ot_item;
            RequestItem my_item = this.item_map.get(k);
            if (!my_item.equals(ot_item = r.item_map.get(k))) {
                return false;
            }
            ok.put(k, my_item);
        }
        for (String k : r.item_map.keySet()) {
            if (ok.get(k) != null) continue;
            return false;
        }
        HashMap<String, String[]> ok2 = new HashMap<String, String[]>();
        for (String k : this.header.keySet()) {
            String[] my_head = this.header.get(k);
            String[] ot_head = r.header.get(k);
            if (ot_head == null) {
                return false;
            }
            if (my_head.length != ot_head.length) {
                return false;
            }
            for (int i = 0; i < my_head.length; ++i) {
                if (my_head[i].equals(ot_head[i])) continue;
                return false;
            }
            ok2.put(k, my_head);
        }
        for (String k : r.header.keySet()) {
            if (ok2.get(k) != null) continue;
            return false;
        }
        return true;
    }

    public Mobile judgeMobile() {
        String[] ua = this.getHeader(UA_HEAD);
        if (ua == null) {
            return Mobile.NO_MOBILE;
        }
        if (ua.length < 1) {
            return Mobile.NO_MOBILE;
        }
        return RequestParameter.judgeMobile(ua[0]);
    }

    public SearchEngine judgeSearchEngine() {
        String[] ua = this.getHeader(UA_HEAD);
        if (ua == null) {
            return SearchEngine.NO_SEARCHENGINE;
        }
        if (ua.length < 1) {
            return SearchEngine.NO_SEARCHENGINE;
        }
        return RequestParameter.judgeSearchEngine(ua[0]);
    }

    public RequestParameter() {
        try {
            this.uri = new URI("#");
        }
        catch (Exception e) {
            Option.debug(e);
        }
    }

    protected void setMethod(Method m) {
        this.method = m;
    }

    protected void setSession(HttpSession s) {
        this.session = s;
    }

    protected void setCookie(Cookie[] c) {
        this.in_cookie = c;
    }

    protected void setRemoteAddr(String ip) {
        this.remote_addr = ip;
    }

    protected void setURI(URI u) {
        this.uri = u;
    }

    protected void setRelativeURI(URI u) {
        this.sub_uri = u;
    }

    public String getContextPath() {
        return this.context_path;
    }

    protected void setContextPath(String str) {
        this.context_path = str;
    }

    protected void setSupervisor(Supervisor sv) {
        this.supervisor = sv;
    }

    public void setHeader(String name, String[] val) {
        this.header.put(name.toLowerCase(Locale.ENGLISH), val);
    }

    void setParam(Method m, HttpServletRequest request, Supervisor sv) {
        this.setSupervisor(sv);
        this.setMethod(m);
        this.setSession(request.getSession(false));
        this.setCookie(request.getCookies());
        this.setRemoteAddr(request.getRemoteAddr());
        try {
            int start;
            StringBuffer buf = request.getRequestURL();
            String query = request.getQueryString();
            if (query != null) {
                buf = buf.append("?");
                buf = buf.append(query);
            }
            this.setURI(new URI(buf.toString()));
            String[] path = this.getURI().getPath().split("/");
            this.setContextPath(request.getContextPath());
            String[] cont = this.getContextPath().split("/");
            String last = cont[cont.length - 1];
            for (start = 0; start < path.length && !last.equals(path[start]); ++start) {
            }
            StringBuilder b = new StringBuilder(path[++start]);
            ++start;
            while (start < path.length) {
                b = b.append("/");
                b = b.append(path[start]);
                ++start;
            }
            this.setRelativeURI(new URI(b.toString()));
        }
        catch (Exception e) {
            Option.debug(e);
        }
        Enumeration em = request.getHeaderNames();
        while (em.hasMoreElements()) {
            String key = (String)em.nextElement();
            ArrayList<String> data = new ArrayList<String>();
            Enumeration e2 = request.getHeaders(key);
            while (e2.hasMoreElements()) {
                data.add((String)e2.nextElement());
            }
            this.setHeader(key, data.toArray(new String[0]));
        }
    }

    public Supervisor getSupervisor() {
        return this.supervisor;
    }

    public String[] getHeaderNames() {
        return this.header.keySet().toArray(new String[0]);
    }

    public String[] getHeader(String name) {
        return this.header.get(name.toLowerCase(Locale.ENGLISH));
    }

    public HeaderQuality[] getHeaderWithQuality(String name) {
        String[] org = this.getHeader(name);
        if (org == null) {
            return null;
        }
        ArrayList<HeaderQuality> head = new ArrayList<HeaderQuality>();
        for (int i = 0; i < org.length; ++i) {
            String[] data = org[i].split(",");
            for (int j = 0; j < data.length; ++j) {
                try {
                    head.add(new HeaderQuality(data[j]));
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return head.toArray(new HeaderQuality[0]);
    }

    public String getRemoteAddr() {
        return this.remote_addr;
    }

    public URI getURI() {
        return this.uri;
    }

    public URI getRelativeURI() {
        return this.sub_uri;
    }

    public Cookie[] getCookie() {
        return this.in_cookie;
    }

    public Cookie getCookie(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.in_cookie.length; ++i) {
            if (!this.in_cookie[i].getName().equals(name)) continue;
            return this.in_cookie[i];
        }
        return null;
    }

    private void setRequestItem(String k, String v, File fb, String mime, boolean f) {
        RequestItem item = this.item_map.get(k);
        if (item == null) {
            item = new RequestItem(k);
            this.item_map.put(k, item);
        }
        item.value.add(v);
        item.file.add(fb);
        item.mime.add(mime);
        item.file_flg.add(f);
    }

    public void addItem(String k, String v, File f, String type) {
        this.setRequestItem(k, v, f, type, true);
    }

    public void addItem(String k, String v) {
        this.setRequestItem(k, v, null, null, false);
    }

    public void remove(String k) {
        this.item_map.remove(k);
    }

    public Method getMethod() {
        return this.method;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public HttpSession makeNewSession() {
        if (this.supervisor != null) {
            this.session = this.supervisor.makeNewSession(this.session);
        }
        return this.session;
    }

    public int getHistoryKey(String name) {
        HistorySet set = this.getHistorySet();
        if (set == null) {
            return -1;
        }
        return set.getKey(name);
    }

    public History getHistory(int key) {
        HistorySet set = this.getHistorySet();
        if (set == null) {
            return null;
        }
        return set.get(key);
    }

    public HistorySet getHistorySet() {
        HttpSession session = this.getSession();
        SessionData data = null;
        if (session != null) {
            data = (SessionData)session.getAttribute("paraselene$data");
        }
        if (data == null) {
            data = Supervisor.getSessionData(this.getSupervisor());
        }
        if (data == null) {
            return null;
        }
        return data.hist;
    }

    public History getHistory() {
        return this.getHistory(SandBox.getCurrentPage().getHistoryKey());
    }

    public RequestItem getItem(String key) {
        if (key == null) {
            return null;
        }
        return this.item_map.get(key);
    }

    public String[] getAllKey() {
        int cnt = this.getItemCount();
        String[] ret = new String[cnt];
        int i = 0;
        Iterator<String> i$ = this.item_map.keySet().iterator();
        while (i$.hasNext()) {
            String k;
            ret[i] = k = i$.next();
            ++i;
        }
        return ret;
    }

    public int getItemCount() {
        return this.item_map.size();
    }

    public boolean isExistRequestItem() {
        return this.item_map.size() > 0;
    }

    String makeCacheKey() {
        if (this.getMethod() != Method.GET) {
            return null;
        }
        String[] key = this.getAllKey();
        int code = 0;
        for (int i = 0; i < key.length; ++i) {
            code += key.hashCode();
            RequestItem item = this.getItem(key[i]);
            String[] val = item.getAllValue();
            for (int j = 0; j < val.length; ++j) {
                code += val[j].hashCode();
            }
        }
        return Integer.toString(code ^= this.getRelativeURI().hashCode(), 36);
    }

    public class HeaderQuality {
        String val;
        Float q = null;

        HeaderQuality(String org) throws NumberFormatException {
            String[] k;
            String[] data = org.split(";");
            this.val = data[0].trim();
            if (data.length > 1 && (k = data[1].split("="))[0].trim().equals("q") && k.length > 1) {
                this.q = new Float(data[1]);
            }
        }

        public String getValue() {
            return this.val;
        }

        public Float getQuality() {
            return this.q;
        }
    }

    public static enum SearchEngine {
        GOOGLE_ADSENSE("Mediapartners-Google"),
        GOOGLE("Googlebot"),
        YAHOO("Yahoo!", "Slurp"),
        YAHOO_JAPAN("Y!J"),
        MSN("msnbot"),
        BAIDU("Baiduspider"),
        NAVER("Yeti"),
        YANDEX("Yandex"),
        CUIL("Twiceler"),
        ALEXA("ia_archive"),
        NO_SEARCHENGINE(new String[0]);

        private String[] str = null;

        private SearchEngine(String ... s) {
            this.str = new String[s.length];
            for (int i = 0; i < this.str.length; ++i) {
                this.str[i] = s[i].toLowerCase(Locale.ENGLISH);
            }
        }

        boolean isHit(String ua) {
            if (this.str == null) {
                return true;
            }
            for (int i = 0; i < this.str.length; ++i) {
                if (ua.indexOf(this.str[i]) != -1) continue;
                return false;
            }
            return true;
        }
    }

    public static enum Mobile {
        DOCOMO,
        AU,
        TU_KA,
        J_PHONE,
        EMOBILE,
        NO_MOBILE;

        private static final long serialVersionUID = 1L;
    }

    public static enum Method {
        GET,
        POST;

        private static final long serialVersionUID = 2L;
    }
}

