/*
 * Decompiled with CFR 0.152.
 */
package paraselene.mockup;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import paraselene.mockup.Param;

class Loader
extends ClassLoader {
    Loader() {
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        ClassNotFoundException e = null;
        int cnt = Param.CLASS_PATH.getDataCount();
        for (int i = 0; i < cnt; ++i) {
            try {
                return this.loadClass(name, Param.CLASS_PATH.getData(i));
            }
            catch (ClassNotFoundException ce) {
                e = ce;
                continue;
            }
        }
        if (e != null) {
            throw e;
        }
        return Class.forName(name);
    }

    private Class<?> load(String name, InputStream input, int size) {
        byte[] b = new byte[size];
        try {
            BufferedInputStream in = new BufferedInputStream(input);
            in.read(b, 0, size);
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return null;
        }
        try {
            return this.defineClass(name, b, 0, size);
        }
        catch (ClassFormatError cfe) {
            System.out.println(cfe.toString());
            return null;
        }
    }

    private boolean isJar(String f) {
        File file = new File(f);
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        return ".jar".equals(f.substring(f.length() - 4));
    }

    private Class<?> readJar(String name, String f) {
        try {
            String[] path = name.split("\\.");
            StringBuilder buf = new StringBuilder(path[0]);
            for (int i = 1; i < path.length; ++i) {
                buf = buf.append("/");
                buf = buf.append(path[i]);
            }
            JarFile file = new JarFile(f);
            JarEntry ent = file.getJarEntry(buf.toString() + ".class");
            return this.load(name, file.getInputStream(ent), (int)ent.getSize());
        }
        catch (Exception e) {
            return null;
        }
    }

    private int calcNest(String root, String[] tgt) {
        int tgt_max = tgt.length - 1;
        if (tgt_max < 0) {
            return 0;
        }
        String[] path = root.split("[/\\\\]");
        int start = 0;
        while (true) {
            if (start >= path.length) {
                return 0;
            }
            if (path[start].equals(tgt[0])) break;
            ++start;
        }
        int no = 1;
        while (no < tgt_max) {
            if (start + no >= path.length) {
                return no;
            }
            if (!path[start + no].equals(tgt[no])) {
                return no;
            }
            ++no;
        }
        return no;
    }

    private Class<?> loadClass(String name, String root) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException cne) {
            Class<?> ret;
            ClassNotFoundException exception = cne;
            if (this.isJar(root) && (ret = this.readJar(name, root)) != null) {
                return ret;
            }
            String[] path = name.split("\\.");
            path[path.length - 1] = path[path.length - 1] + ".class";
            File f = new File(root);
            if (!f.isDirectory()) {
                throw exception;
            }
            Class<?> ret2 = this.seek(name, f, path, this.calcNest(root, path));
            if (ret2 == null) {
                throw exception;
            }
            return ret2;
        }
    }

    private Class<?> seek(String name, File start, String[] all, int no) {
        boolean dir_f;
        File[] list = start.listFiles();
        if (list == null) {
            return null;
        }
        boolean bl = dir_f = all.length - 1 != no;
        if (no == 0 && dir_f) {
            for (int i = 0; i < list.length; ++i) {
                Class<?> ret;
                if (this.isJar(list[i].getPath()) && (ret = this.readJar(name, list[i].getPath())) != null) {
                    return ret;
                }
                if (!list[i].isDirectory() || !(list[i].getName().equals(all[no]) ? (ret = this.seek(name, list[i], all, 1)) != null : (ret = this.seek(name, list[i], all, 0)) != null)) continue;
                return ret;
            }
        } else {
            for (int i = 0; i < list.length; ++i) {
                if (list[i].isDirectory() != dir_f || !list[i].getName().equals(all[no])) continue;
                if (!dir_f) {
                    try {
                        return this.load(name, new FileInputStream(list[i]), (int)list[i].length());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return this.seek(name, list[i], all, no + 1);
            }
        }
        return null;
    }
}

