/*
 * Decompiled with CFR 0.152.
 */
package paraselene;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import paraselene.HTMLPart;
import paraselene.PlainText;
import paraselene.WebChar;
import paraselene.css.CSSValuable;
import paraselene.tag.AttributeValuable;
import paraselene.tag.table.Column;

public class Text
extends PlainText
implements AttributeValuable,
CSSValuable {
    private static final long serialVersionUID = 2L;

    protected Text() {
    }

    public Text(String txt) {
        this(txt, HTMLPart.StringMode.PLAIN);
    }

    public Text(long num, String format) {
        this(new Long(num), format);
    }

    public Text(double num, String format) {
        this(new Double(num), format);
    }

    public Text(Number num, String format) {
        this(new DecimalFormat(format).format(num));
    }

    public Text(Date date, String format) {
        this(new SimpleDateFormat(format).format(date));
    }

    public Text(String txt, HTMLPart.StringMode mode) {
        this.setText(txt, mode);
    }

    public void setText(String txt, HTMLPart.StringMode mode) {
        if (txt == null || mode == HTMLPart.StringMode.PLAIN) {
            super.setText(txt);
            return;
        }
        char[] line = txt.toCharArray();
        StringBuilder buf = new StringBuilder();
        StringBuilder esc = null;
        int spc_cnt = 0;
        for (int i = 0; i < line.length; ++i) {
            if (line[i] == '\n' || line[i] == '\r') {
                if (i > 0 && (line[i - 1] == '\n' || line[i - 1] == '\r') && line[i] != line[i - 1]) continue;
                buf = buf.append("\n");
                continue;
            }
            if (line[i] == ' ' || line[i] == '\t') {
                if (mode == HTMLPart.StringMode.TEXTAREA) {
                    buf = buf.append(line[i]);
                    continue;
                }
                ++spc_cnt;
                continue;
            }
            if (spc_cnt > 0) {
                buf = buf.append(' ');
                spc_cnt = 0;
            }
            if (esc != null) {
                esc = esc.append(line[i]);
                if (line[i] != ';') continue;
                String amp = esc.toString();
                buf = "&lt;".equalsIgnoreCase(amp) ? buf.append('<') : ("&gt;".equalsIgnoreCase(amp) ? buf.append('>') : ("&amp;".equalsIgnoreCase(amp) ? buf.append('&') : ("&quot;".equalsIgnoreCase(amp) ? buf.append('\"') : ("&nbsp;".equalsIgnoreCase(amp) ? buf.append(' ') : buf.append((CharSequence)esc)))));
                esc = null;
                continue;
            }
            if (line[i] == '&') {
                esc = new StringBuilder("&");
                continue;
            }
            spc_cnt = 0;
            buf = buf.append(line[i]);
        }
        if (esc != null) {
            buf = buf.append((CharSequence)esc);
        }
        super.setText(txt);
    }

    @Override
    public String toString(HTMLPart.StringMode mode) {
        String str = super.toString(mode);
        if (str == null) {
            return null;
        }
        if (mode == HTMLPart.StringMode.PLAIN) {
            return str;
        }
        StringBuilder buf = new StringBuilder();
        char[] line = str.toCharArray();
        int spc_cnt = 0;
        boolean clm_f = this.getAssignedTag() instanceof Column;
        for (int i = 0; i < line.length; ++i) {
            if (line[i] == ' ') {
                String add = " ";
                switch (mode) {
                    case BODY: {
                        add = clm_f ? (spc_cnt % 2 == 0 ? "&nbsp;" : " ") : (spc_cnt % 2 == 1 ? "&nbsp;" : " ");
                    }
                }
                ++spc_cnt;
                buf = buf.append(add);
                continue;
            }
            spc_cnt = 0;
            if (line[i] == '\"') {
                buf = buf.append("&quot;");
                continue;
            }
            if (mode != HTMLPart.StringMode.ATTRIBUTE) {
                WebChar wc = WebChar.getWebChar(line[i]);
                if (wc != null) {
                    buf = buf.append(wc.getRef());
                    continue;
                }
                if (mode != HTMLPart.StringMode.TEXTAREA) {
                    if (line[i] == '\n' || line[i] == '\r') {
                        if (i > 0 && (line[i - 1] == '\n' || line[i - 1] == '\r') && line[i] != line[i - 1]) continue;
                        String br = "<br>";
                        if (this.getAssignedTag().getAssignedPage().isXML()) {
                            br = "<br />";
                        }
                        buf = buf.append(br);
                        continue;
                    }
                } else if (line[i] == '\n' || line[i] == '\r') {
                    if (i > 0 && (line[i - 1] == '\n' || line[i - 1] == '\r') && line[i] != line[i - 1]) continue;
                    buf = buf.append("\r\n");
                    continue;
                }
            }
            buf = buf.append(line[i]);
        }
        return buf.toString();
    }

    @Override
    public HTMLPart getReplica() {
        return new Text(super.toString(HTMLPart.StringMode.PLAIN));
    }

    public Text append(String add) {
        if (add == null) {
            return this;
        }
        StringBuilder buf = new StringBuilder(super.toString(HTMLPart.StringMode.PLAIN));
        buf = buf.append(add);
        super.setText(buf.toString());
        return this;
    }

    public Text append(PlainText add) {
        if (add == null) {
            return this;
        }
        return this.append(add.toString(HTMLPart.StringMode.PLAIN));
    }

    public Text append(WebChar add) {
        if (add == null) {
            return this;
        }
        return this.append(add.toString());
    }
}

