/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import paraselene.Downloadable;
import paraselene.HTTPDate;
import paraselene.Page;
import paraselene.supervisor.DataHolder;
import paraselene.supervisor.Forward;
import paraselene.supervisor.Null;
import paraselene.supervisor.NullPage;
import paraselene.supervisor.Option;
import paraselene.supervisor.PageFactory;
import paraselene.supervisor.PageID;
import paraselene.supervisor.PathData;
import paraselene.supervisor.RequestParameter;
import paraselene.supervisor.SandBox;
import paraselene.supervisor.SearchEngineAgent;
import paraselene.supervisor.SessionData;
import paraselene.supervisor.TransactionSequencer;
import paraselene.tag.attr.URIAttribute;

public abstract class Supervisor
extends HttpServlet {
    static final String SESSION_DATA = "paraselene$data";
    public static final String[] LINK_DEF = new String[]{"PARASELENE(PAGE)", "PARASELENE(HTTP)", "PARASELENE(HTTPS)"};
    private static final int[] LINK_LEN = new int[]{LINK_DEF[0].length(), LINK_DEF[1].length(), LINK_DEF[2].length()};
    private static final String[] LINK_PROT = new String[]{"", "http://", "https://"};
    private static HashMap<Thread, DataHolder> data_map_th = new HashMap();
    private static HashMap<Supervisor, DataHolder> data_map_sv = new HashMap();
    private static final String XHTML = "application/xhtml+xml";

    private static String resolvePage(DataHolder holder, String p) {
        try {
            URI u = new URI(p);
            PageID to = null;
            Page page = holder.sv.getPageFactory().getPage(Integer.parseInt(u.getPath().substring(LINK_LEN[0])));
            if (page != null) {
                to = page.getID();
                to.getPageFactory().returnPage(page);
            }
            if (to != null) {
                String fragment;
                StringBuffer path = new StringBuffer(TransactionSequencer.makeURI(page.isCheckRepeatSameRequest() ? holder.data.seq : null, holder.myself, to));
                String query = u.getQuery();
                if (query != null) {
                    path = path.append("?");
                    path = path.append(query);
                }
                if ((fragment = u.getFragment()) != null) {
                    path = path.append("#");
                    path = path.append(fragment);
                }
                return path.toString();
            }
            return "PageID_Not_Found(" + p + ")";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    private static String resolveHost(DataHolder holder, String path, int def_no) {
        try {
            int port = Integer.parseInt(path.substring(LINK_LEN[def_no]));
            StringBuffer buf = new StringBuffer(LINK_PROT[def_no]);
            buf = buf.append(holder.req.getServerName());
            if (port > 0 && port < 65535) {
                buf = buf.append(":");
                buf = buf.append(port);
            }
            buf = buf.append(holder.req.getContextPath());
            return buf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makeWithSessionURI(String uri, String enc) throws UnsupportedEncodingException {
        DataHolder holder = null;
        HashMap<Thread, DataHolder> hashMap = data_map_th;
        synchronized (hashMap) {
            holder = data_map_th.get(Thread.currentThread());
        }
        if (holder == null) {
            return URIAttribute.encode(uri, enc);
        }
        if (holder.search_engine) {
            return URIAttribute.encode(uri, enc);
        }
        String[] part = uri.split("/");
        boolean flag = false;
        String head = null;
        block7: for (int i = 0; i < part.length; ++i) {
            int def_no;
            for (def_no = 0; def_no < LINK_DEF.length; ++def_no) {
                if (part[i].length() < LINK_LEN[def_no] || !LINK_DEF[def_no].equals(part[i].substring(0, LINK_LEN[def_no]))) continue;
                flag = true;
                break;
            }
            switch (def_no) {
                case 0: {
                    part[i] = Supervisor.resolvePage(holder, part[i]);
                    continue block7;
                }
                case 1: 
                case 2: {
                    part[i] = Supervisor.resolveHost(holder, part[i], def_no);
                    part[i] = "";
                }
            }
        }
        if (flag) {
            StringBuffer buf = new StringBuffer(part[0]);
            for (int i = 1; i < part.length; ++i) {
                if (buf.length() > 0) {
                    buf = buf.append("/");
                }
                buf = buf.append(part[i]);
            }
            uri = buf.toString();
        }
        uri = holder.response.encodeURL(URIAttribute.encode(uri, enc));
        if (head != null) {
            StringBuilder buf = new StringBuilder(head);
            buf = buf.append("/");
            buf = buf.append(uri);
            uri = buf.toString();
        }
        return uri;
    }

    public abstract PageFactory getPageFactory();

    public abstract void onError(Throwable var1);

    private Forward onErrorDebug(Throwable e, HttpServletRequest req, HttpServletResponse res) {
        if (e instanceof Page.PageException) {
            Page.PageException pe = (Page.PageException)e;
            e = pe.get();
        }
        Forward fw = new Forward(500);
        e.printStackTrace();
        this.onError(e);
        try {
            if (!Option.isReleaseMode()) {
                Option.debug(e);
            }
            fw.Action(this, res);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            this.onError(e2);
        }
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        return fw;
    }

    public abstract Forward onIllegalRequest(IllegalRequest var1, RequestParameter var2, Page var3, Page var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAction(HttpServletRequest request, HttpServletResponse res) {
        HttpSession session = null;
        SessionData data = null;
        DataHolder holder = null;
        RequestParameter req = null;
        HashMap<Thread, DataHolder> hashMap = data_map_th;
        synchronized (hashMap) {
            holder = data_map_th.get(Thread.currentThread());
            if (holder == null) {
                holder = data_map_sv.get((Object)this);
            }
            if (holder != null) {
                data = holder.data;
            }
        }
        try {
            Page[] out_ret;
            if (data == null) {
                System.out.println("SessionData null");
                res.sendError(500);
                return;
            }
            boolean session_f = false;
            holder.history_use = false;
            req = holder.request;
            session = req.getSession();
            String uri = req.getURI().toString();
            PageFactory fact = this.getPageFactory();
            PathData path_data = new PathData();
            Forward fw = null;
            Page last_page = null;
            Page next_page = null;
            path_data.to = fact.getPage(uri);
            if (path_data.to == null) {
                path_data = TransactionSequencer.parsePath(data.seq, uri, fact);
                if (TransactionSequencer.isMustSession(uri)) {
                    if (holder.search_engine) {
                        new Forward(403).Action(this, res);
                        session.invalidate();
                        return;
                    }
                    if (holder.session_null && path_data != null && (fw = this.onIllegalRequest(IllegalRequest.SESSION_ERROR, req, path_data.from, path_data.to)) != null) {
                        session_f = fw.session_clear_f;
                        last_page = fact.getNullPage();
                        next_page = fw.getPage(null);
                        if (next_page == null) {
                            fw.Action(this, res);
                            if (session_f && session != null) {
                                session.invalidate();
                            }
                            return;
                        }
                    }
                }
            }
            if (path_data == null) {
                fw = new Forward(403);
                fw.Action(this, res);
                if (session != null) {
                    session.invalidate();
                }
                return;
            }
            if (path_data.redirect != null) {
                if (!holder.data.write(this, path_data.redirect, holder)) {
                    fw = new Forward(403);
                    fw.Action(this, res);
                    if (session != null) {
                        session.invalidate();
                    }
                }
                return;
            }
            last_page = path_data.from;
            next_page = path_data.to;
            if (last_page != null) {
                if (last_page instanceof Null) {
                    System.out.println("last page is null");
                    fw = new Forward(403);
                    fw.Action(this, res);
                    if (session != null) {
                        session.invalidate();
                    }
                    return;
                }
                if (last_page.isAllowHistoryAdd()) {
                    Page sub = data.hist.getPage(last_page.getID());
                    if (sub != null) {
                        fact.returnPage(last_page);
                        last_page = sub;
                    } else {
                        fw = this.onIllegalRequest(IllegalRequest.NOT_FOUND_HISTORY, req, last_page, next_page);
                        if (fw != null) {
                            session_f = fw.session_clear_f;
                            last_page = fact.getNullPage();
                            next_page = fw.getPage(null);
                            if (next_page == null) {
                                fw.Action(this, res);
                                if (session_f && session != null) {
                                    session.invalidate();
                                }
                                return;
                            }
                        }
                    }
                }
            } else {
                last_page = fact.getNullPage();
            }
            if (next_page != null) {
                if (next_page instanceof Null) {
                    System.out.println("next page is null");
                    fw = new Forward(403);
                    fw.Action(this, res);
                    if (session != null) {
                        session.invalidate();
                    }
                    return;
                }
            } else {
                fw = new Forward(403);
                fw.Action(this, res);
                if (session != null) {
                    session.invalidate();
                }
                return;
            }
            if (path_data.called && (fw = this.onIllegalRequest(IllegalRequest.REPEAT_SAME_REQUEST, req, last_page, next_page)) != null) {
                session_f = fw.session_clear_f;
                last_page = fact.getNullPage();
                next_page = fw.getPage(null);
                if (next_page == null) {
                    fw.Action(this, res);
                    if (session_f && session != null) {
                        session.invalidate();
                    }
                    return;
                }
            }
            if (fw == null) {
                if (next_page != null) {
                    fw = new Forward(next_page.getID(), true, false);
                    fact.returnPage(next_page);
                }
                last_page.reflect(req);
                fw = SandBox.input(last_page, req, fw);
                last_page.setInitialized(false);
                holder.history_use = fw.history_f;
                session_f = fw.session_clear_f;
                next_page = fw.getPage(last_page);
                if (next_page == null) {
                    fw.Action(this, res);
                    if (session_f && session != null) {
                        session.invalidate();
                    }
                    return;
                }
            }
            if ((out_ret = this.output_call(last_page, next_page)) == null) {
                System.out.println("output_call false");
                fw = new Forward(500);
                fw.Action(this, res);
                return;
            }
            this.write(out_ret, session_f, fw, holder);
        }
        catch (Throwable e) {
            this.onErrorDebug(e, request, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpSession makeNewSession(HttpSession old) {
        DataHolder holder = null;
        HashMap<Thread, DataHolder> hashMap = data_map_th;
        synchronized (hashMap) {
            holder = data_map_th.get(Thread.currentThread());
            if (holder == null) {
                holder = data_map_sv.get((Object)this);
            }
        }
        if (holder == null) {
            return old;
        }
        if (old != null) {
            old.invalidate();
        }
        HttpSession session = holder.req.getSession(true);
        session.setAttribute(SESSION_DATA, (Object)holder.data);
        return session;
    }

    void write(Page[] out_ret, boolean session_f, Forward fw, DataHolder holder) throws Exception {
        SessionData data = holder.data;
        HttpServletResponse res = holder.response;
        Page next_page = out_ret[0];
        RequestParameter param = holder.request;
        HttpSession session = param.getSession();
        try {
            session.setAttribute(SESSION_DATA, (Object)data);
        }
        catch (Exception e) {
            session = null;
        }
        if (session_f) {
            if (session != null) {
                session.invalidate();
            }
            session = null;
        } else if (session == null) {
            session = holder.req.getSession(true);
            session.setAttribute(SESSION_DATA, (Object)data);
        }
        holder.myself = next_page.getID();
        if (param.getMethod() == RequestParameter.Method.POST) {
            data.redirect(out_ret, fw, holder).Action(this, res);
        } else {
            String mime = next_page.getContentType();
            if (mime == null) {
                StringBuffer buf = null;
                if (next_page.isXML()) {
                    RequestParameter.HeaderQuality[] head = param.getHeaderWithQuality("Accept");
                    if (head != null) {
                        for (int i = 0; i < head.length; ++i) {
                            Float f = head[i].getQuality();
                            if (f != null && (double)f.floatValue() <= 0.0 || !XHTML.equalsIgnoreCase(head[i].getValue())) continue;
                            buf = new StringBuffer(XHTML);
                            break;
                        }
                    }
                    if (buf == null) {
                        RequestParameter.Mobile mob = param.judgMobile();
                        switch (mob) {
                            case AU: 
                            case DOCOMO: 
                            case J_PHONE: {
                                buf = new StringBuffer(XHTML);
                            }
                        }
                    }
                }
                if (buf == null) {
                    buf = new StringBuffer("text/html");
                }
                buf = buf.append("; charset=");
                mime = buf.append(next_page.getCharset()).toString();
            }
            res.setContentType(mime);
            HTTPDate date = next_page.getLastModified();
            String[] mod = param.getHeader("If-Modified-Since");
            if (mod != null && date != null) {
                try {
                    if (date.compareTo(new HTTPDate(mod[0])) <= 0) {
                        res.sendError(304);
                        data.hist.add(next_page);
                        return;
                    }
                }
                catch (ParseException pe) {
                    // empty catch block
                }
            }
            if (date != null) {
                res.addHeader("Last-Modified", date.toString());
                res.addHeader("Cache-Control", "public");
            } else {
                res.addHeader("Cache-Control", "no-cache, no-store");
            }
            if (fw != null) {
                int ck_cnt = fw.out_cookie.size();
                for (int i = 0; i < ck_cnt; ++i) {
                    res.addCookie(fw.out_cookie.get(i));
                }
            }
            if (this.gzip(param, holder.req, res, out_ret[1])) {
                data.hist.add(next_page);
                return;
            }
            if (out_ret[1] instanceof Downloadable) {
                Downloadable dl = (Downloadable)((Object)out_ret[1]);
                BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream());
                BufferedInputStream in = new BufferedInputStream(dl.getInputStream());
                try {
                    int size;
                    byte[] buf = new byte[4096];
                    while ((size = in.read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, size);
                        if (size < buf.length) break;
                        holder.req.getSession(false);
                    }
                    in.close();
                    ((OutputStream)out).flush();
                }
                catch (Exception e) {
                    if (in != null) {
                        in.close();
                    }
                    throw e;
                }
            } else {
                PrintWriter w = res.getWriter();
                out_ret[1].write(w);
                w.flush();
            }
        }
        data.hist.add(next_page);
    }

    private boolean gzip(RequestParameter param, HttpServletRequest req, HttpServletResponse res, Page page) throws Exception {
        if (!page.isGZIP()) {
            return false;
        }
        String[] pcol = req.getProtocol().split("\\/");
        if (pcol[pcol.length - 1].equals("1.0")) {
            return false;
        }
        RequestParameter.HeaderQuality[] encode = param.getHeaderWithQuality("Accept-Encoding");
        boolean gzip_f = false;
        if (encode != null) {
            for (int i = 0; i < encode.length; ++i) {
                float q;
                if (!"gzip".equalsIgnoreCase(encode[i].getValue())) continue;
                Float f = encode[i].getQuality();
                float f2 = q = f == null ? 1.0f : f.floatValue();
                if (!(q > 0.0f)) continue;
                gzip_f = true;
                break;
            }
        }
        if (!gzip_f) {
            return false;
        }
        res.addHeader("Content-Encoding", "gzip");
        GZIPOutputStream gz_out = new GZIPOutputStream((OutputStream)res.getOutputStream());
        if (page instanceof Downloadable) {
            Downloadable dl = (Downloadable)((Object)page);
            BufferedInputStream in = new BufferedInputStream(dl.getInputStream());
            try {
                int size;
                byte[] buf = new byte[4096];
                while ((size = in.read(buf)) > 0) {
                    gz_out.write(buf, 0, size);
                    if (size < buf.length) break;
                    req.getSession(false);
                }
                in.close();
            }
            catch (Exception e) {
                if (in != null) {
                    in.close();
                }
                throw e;
            }
        } else {
            PrintWriter w = new PrintWriter(new OutputStreamWriter((OutputStream)gz_out, page.getCharset()));
            page.write(w);
            w.flush();
        }
        gz_out.finish();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page[] output_call(Page last_page, Page next_page) throws Throwable {
        Page view2;
        PageID last_id = null;
        if (last_page instanceof NullPage) {
            last_page = null;
        }
        if (last_page != null) {
            last_id = last_page.getID();
        }
        DataHolder holder = null;
        SessionData data = null;
        HashMap<Thread, DataHolder> hashMap = data_map_th;
        synchronized (hashMap) {
            holder = data_map_th.get(Thread.currentThread());
            if (holder == null) {
                holder = data_map_sv.get((Object)this);
            }
            if (holder != null) {
                data = holder.data;
            }
        }
        if (data == null) {
            return null;
        }
        if (holder.history_use) {
            Page sub;
            if (next_page.getID() == last_id) {
                this.getPageFactory().returnPage(next_page);
                next_page = last_page;
            } else if (next_page.isAllowHistoryAdd() && (sub = data.hist.getPage(next_page.getID())) != null) {
                this.getPageFactory().returnPage(next_page);
                next_page = sub;
            }
        }
        if ((view2 = SandBox.output(next_page, last_page, holder.request)) == null) {
            view2 = next_page;
        }
        next_page.setInitialized(false);
        return new Page[]{next_page, view2};
    }

    private RequestParameter normalReq(HttpServletRequest req) {
        RequestParameter ret = new RequestParameter();
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String[] val = req.getParameterValues(key);
            for (int i = 0; i < val.length; ++i) {
                ret.addItem(key, val[i]);
            }
        }
        return ret;
    }

    private RequestParameter fileReq(HttpServletRequest req, PathData p) throws Exception {
        RequestParameter ret = new RequestParameter();
        DiskFileItemFactory fact = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fact);
        int max = p.from.getUploadMaxBytes();
        if (max < 0) {
            max = -1;
        }
        upload.setSizeMax((long)max);
        upload.setHeaderEncoding(p.from.getCharset());
        List items = upload.parseRequest(req);
        for (Object o : items) {
            FileItem item = (FileItem)o;
            if (item.isFormField()) {
                ret.addItem(item.getFieldName(), item.getString(req.getCharacterEncoding()));
                continue;
            }
            File file = File.createTempFile("dog", null);
            file.deleteOnExit();
            item.write(file);
            ret.addItem(item.getFieldName(), item.getName(), file, item.getContentType());
        }
        return ret;
    }

    public abstract int getRequestMaxCount();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Forward preset(RequestParameter.Method method, HttpServletRequest request, HttpServletResponse res) throws UnsupportedEncodingException {
        if (!SandBox.isSafeFreeMemory()) {
            return new Forward(503);
        }
        DataHolder holder = new DataHolder(this);
        HttpSession session = request.getSession(false);
        SessionData data = null;
        if (session == null) {
            data = new SessionData(request);
            holder.session_null = true;
        } else {
            data = (SessionData)session.getAttribute(SESSION_DATA);
            holder.session_null = false;
            if (data == null) {
                data = new SessionData(request);
                session.setAttribute(SESSION_DATA, (Object)data);
                holder.session_null = true;
            } else if (!data.isSame(request)) {
                session.invalidate();
                session = null;
                data = new SessionData(request);
                holder.session_null = true;
            }
        }
        holder.req = request;
        holder.response = res;
        holder.data = data;
        PathData p = TransactionSequencer.parsePath(null, request.getRequestURI(), this.getPageFactory());
        if (p != null && p.from != null) {
            request.setCharacterEncoding(p.from.getCharset());
        }
        RequestParameter req = null;
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            req = this.normalReq(request);
        } else {
            try {
                req = this.fileReq(request, p);
            }
            catch (Exception e) {
                return this.onErrorDebug(e, request, res);
            }
        }
        req.setParam(method, request, this);
        String[] ua = req.getHeader("User-Agent");
        if (ua != null) {
            holder.search_engine = SearchEngineAgent.isSearchEngineAgent(ua[0]);
        }
        holder.request = req;
        int cnt = this.getRequestMaxCount();
        HashMap<Thread, DataHolder> hashMap = data_map_th;
        synchronized (hashMap) {
            if (cnt > 0 && cnt < data_map_th.size()) {
                return new Forward(503);
            }
            data_map_th.put(Thread.currentThread(), holder);
            data_map_sv.put(this, holder);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doGet(HttpServletRequest req, HttpServletResponse res) {
        try {
            Forward fw = this.preset(RequestParameter.Method.GET, req, res);
            if (fw != null) {
                fw.Action(this, res);
                return;
            }
            this.doAction(req, res);
            HashMap<Thread, DataHolder> hashMap = data_map_th;
            synchronized (hashMap) {
                data_map_th.remove(Thread.currentThread());
                data_map_sv.remove((Object)this);
            }
        }
        catch (Exception e) {
            this.onErrorDebug(e, req, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doPost(HttpServletRequest req, HttpServletResponse res) {
        try {
            Forward fw = this.preset(RequestParameter.Method.POST, req, res);
            if (fw != null) {
                fw.Action(this, res);
                return;
            }
            this.doAction(req, res);
            HashMap<Thread, DataHolder> hashMap = data_map_th;
            synchronized (hashMap) {
                data_map_th.remove(Thread.currentThread());
                data_map_sv.remove((Object)this);
            }
        }
        catch (Exception e) {
            this.onErrorDebug(e, req, res);
        }
    }

    static {
        SandBox.doStart();
    }

    public static enum IllegalRequest {
        REPEAT_SAME_REQUEST,
        NOT_FOUND_HISTORY,
        SESSION_ERROR;

        private static final long serialVersionUID = 1L;
    }
}

