/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import paraselene.Page;
import paraselene.supervisor.DataHolder;
import paraselene.supervisor.Forward;
import paraselene.supervisor.History;
import paraselene.supervisor.PageID;
import paraselene.supervisor.RedirectData;
import paraselene.supervisor.Supervisor;
import paraselene.supervisor.TransactionSequencer;
import paraselene.tag.attr.URIAttribute;

class SessionData
implements Serializable {
    private static final long serialVersionUID = 1L;
    TransactionSequencer seq = new TransactionSequencer();
    History hist = new History();
    private HashMap<PageID, RedirectData> pending = new HashMap();
    private int client;

    private int getClient(HttpServletRequest req) {
        String[] data = new String[]{req.getHeader("User-Agent"), req.getHeader("HTTP-Client-IP"), req.getHeader("X-Forwarded-For"), req.getHeader("Remote-Addr")};
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == null) {
                data[i] = "non";
            }
            buf = buf.append("*");
            buf = buf.append(data[i]);
        }
        return buf.toString().hashCode();
    }

    SessionData(HttpServletRequest req) {
        this.client = this.getClient(req);
    }

    boolean isSame(HttpServletRequest req) {
        if (this.client == this.getClient(req)) {
            return true;
        }
        this.client = 0;
        System.out.println("unmatched client");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean write(Supervisor sv, Page out, DataHolder holder) throws Exception {
        PageID id = out.getID();
        RedirectData data = null;
        HashMap<PageID, RedirectData> hashMap = this.pending;
        synchronized (hashMap) {
            data = this.pending.get(id);
        }
        id.getPageFactory().returnPage(out);
        if (data == null) {
            return false;
        }
        if (holder.request.getURI().toString().indexOf(data.uri) < 0) {
            return false;
        }
        sv.write(data.out_page, false, data.fw, holder);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Forward redirect(Page[] out_ret, Forward fw, DataHolder holder) throws Exception {
        RedirectData rd = new RedirectData();
        rd.fw = fw;
        rd.out_page = out_ret;
        URI uri = holder.request.getURI();
        rd.uri = TransactionSequencer.makeRedirectURI(this.seq, out_ret[0].getID());
        String path = URIAttribute.makeAbsolutePath(URIAttribute.Scheme.getScheme(uri), uri.getPort(), rd.uri);
        HashMap<PageID, RedirectData> hashMap = this.pending;
        synchronized (hashMap) {
            this.pending.put(out_ret[0].getID(), rd);
        }
        return new Forward(new URI(path), false);
    }
}

