/*
 * Decompiled with CFR 0.152.
 */
package paraselene;

import paraselene.HTMLPart;
import paraselene.Text;
import paraselene.WebColor;

public class Color
extends Text {
    private static final long serialVersionUID = 1L;
    private int red = -1;
    private int green = -1;
    private int blue = -1;

    @Override
    public HTMLPart getReplica() {
        return new Color(this.red, this.green, this.blue);
    }

    public Color(String s) {
        this.setColor(s);
    }

    public void setColor(String s) {
        int ch_len;
        if (s == null) {
            super.setText(s);
            return;
        }
        if ((s = s.trim()).isEmpty()) {
            super.setText(s);
            return;
        }
        if (s.charAt(0) != '#') {
            this.setColor(WebColor.valueOf(s.toUpperCase()));
            return;
        }
        char[] org = s.toCharArray();
        char[] ch = new char[7];
        int org_len = org.length - 1;
        for (ch_len = ch.length - 1; org_len >= 1 && ch_len >= 1; --org_len, --ch_len) {
            ch[ch_len] = org[org_len];
        }
        while (ch_len >= 1) {
            ch[ch_len] = 48;
            --ch_len;
        }
        this.setColor(Integer.parseInt(new String(ch, 1, 2), 16), Integer.parseInt(new String(ch, 3, 2), 16), Integer.parseInt(new String(ch, 5, 2), 16));
    }

    public Color(WebColor wc) {
        this.setColor(wc);
    }

    public void setColor(WebColor wc) {
        this.setColor(wc.red, wc.green, wc.blue);
    }

    public Color(int r, int g, int b) {
        this.setColor(r, g, b);
    }

    public void setColor(int r, int g, int b) {
        if (r < 0 || g < 0 || b < 0) {
            this.blue = -1;
            this.green = -1;
            this.red = -1;
            super.setText("transparent");
        } else {
            this.red = r & 0xFF;
            this.green = g & 0xFF;
            this.blue = b & 0xFF;
            super.setText(String.format("#%06X", this.red << 16 | this.green << 8 | this.blue));
        }
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }
}

