package modelTree;
//tree4 using node 

//ƂƂ̓V~[Vł@\񂾂A낤
 

import sequence.*;
import parameters.parameters;
import node.*;
 
public class ModelTree{ // fNXB

    public mutagen[] mutArr(int loci, String muttype, double rho){
        mutagen[] mut = new mutagen[loci];
        for(int n=0;n<loci;n++) mut[n] = new mutPoisson();
        if( muttype.equals("K2") )  for(int n=0;n<loci;n++) mut[n] = new mutKimura2(rho);
        if ( muttype.equals("BO") ) {
            for(int n=0;n<loci/2;n++) mut[n] = new mutKimura2(rho);
            for(int n=loci/2;n<loci;n++) mut[n] = new mutPoisson();
        }
        return mut;
    }
	public static seq_node newTree(parameters params){
		//set mutation pettern (DNA or amino acids)
		mutagen mut =  new mutPoisson();
		if( params.muttype.equals("K2" )) mut = new mutKimura2(params.rho);
		//set tree shape and mutation rates
		double u = 0.0;
		// alpha2 is the gamma parameter among genes
		if(params.alpha2==Double.POSITIVE_INFINITY){ 
			u = params.u;// no difference
		}else{
			u = (new gamrand(params.alpha2)).value()*params.u;// 2009/5/26
		}
		if( params.treetype.equals("V") ) return ModelTree.V(mut, u, params.len);
		if( params.treetype.equals("A") ) return ModelTree.A(mut, u, params.len);
		if( params.treetype.equals("B") ) return ModelTree.B(mut, u, params.len);
		if( params.treetype.equals("H") ) return ModelTree.H(mut, u, params.len);
		return null;
	}
	public static seq_node copytree(mutagen mut0, double mu, int len0, node org_tree){
		return seq_node.create_seq_node(mut0, org_tree, len0);
	}

    public static seq_node V(mutagen mut0, double mu, int len0){
    	// two-OTU tree;
        seq_node OTU0, OTU1;
        OTU1  = new seq_node(mut0, 1, 0.5, len0);
        OTU0  = new seq_node(mut0, 0, 0.5, len0);
        seq_node root  = new seq_node(0.0, OTU1, OTU0);
        root.set_rate(mu);
        return root;
    }

    public static seq_node A(mutagen mut0, double mu, int len0){
         seq_node OTU0, OTU1, OTU2, OTU3;
         seq_node OTU4, OTU5, OTU6, OTU7;
         seq_node node0, node1, node2, node3;
         seq_node node4, node5, node6, node7;
         OTU7  = new seq_node(mut0, 7, 0.125, len0);
         OTU6  = new seq_node(mut0, 6, 0.125, len0);
         node6 = new seq_node(0.125, OTU6, OTU7);
         OTU5  = new seq_node(mut0, 5, 0.25, len0);
         node5 = new seq_node(0.125, OTU5, node6);
         OTU4  = new seq_node(mut0, 4, 0.375, len0);
         node4 = new seq_node(0.125, OTU4, node5);
         OTU3  = new seq_node(mut0, 3, 0.5, len0);
         node3 = new seq_node(0.125, OTU3, node4);
         OTU2  = new seq_node(mut0, 2, 0.625, len0);
         node2 = new seq_node(0.125, OTU2, node3);
         OTU1  = new seq_node(mut0, 1, 0.75, len0);
         node1 = new seq_node(0.125, OTU1, node2);
         OTU0  = new seq_node(mut0, 0, 0.875, len0);
         seq_node root  = new seq_node(0.0, OTU0, node1);
         root.set_rate(mu);
         return root;
    }
    
    public static seq_node B(mutagen mut0, double mu, int len0){
        seq_node OTU0, OTU1, OTU2, OTU3;
        seq_node OTU4, OTU5, OTU6, OTU7;
        seq_node node0, node1, node2, node3;
        seq_node node4, node5, node6, node7;
        OTU7  = new seq_node(mut0, 7, 0.125, len0);
        OTU6  = new seq_node(mut0, 6, 0.125, len0);
        node7  = new seq_node(0.125, OTU6, OTU7);

        OTU5  = new seq_node(mut0, 5, 0.125, len0);
        OTU4  = new seq_node(mut0, 4, 0.125, len0);
        node5  = new seq_node(0.125, OTU4, OTU5);

        OTU3  = new seq_node(mut0, 3, 0.125, len0);
        OTU2  = new seq_node(mut0, 2, 0.125, len0);
        node3  = new seq_node(0.125, OTU2, OTU3);

        OTU1  = new seq_node(mut0, 1, 0.125, len0);
        OTU0  = new seq_node(mut0, 0, 0.125, len0);
        node1  = new seq_node(0.125, OTU0, OTU1);

        node6  = new seq_node(0.125, node5, node7);
        node2  = new seq_node(0.125, node1, node3);
        seq_node root  = new seq_node(0.0, node2, node6);
        root.set_rate(mu);
        return root;
    }
    
    public static seq_node H(mutagen mut0, double mu, int len0){
        seq_node OTU0, OTU1, OTU2, OTU3, node1, node2;;
        OTU0  = new seq_node(mut0,0, 1.0, len0);
        OTU1  = new seq_node(mut0,1, 0.1, len0);
        node1 = new seq_node(0.05, OTU0, OTU1);
        OTU2  = new seq_node(mut0, 2, 1.0, len0);
        OTU3  = new seq_node(mut0, 3, 0.1, len0);
        node2 = new seq_node(0.05, OTU2, OTU3);
        seq_node root  = new seq_node(0.0, node1, node2);
        root.set_rate(mu);
        return root;
    }
}
 
