package distance;
import java.lang.*;

class fact{
    static double[] ln_f;

    public static void set(int len){
        if(ln_f==null){  //to avoid "NullPointerException"
            ln_f = new double[1];
            ln_f[0] = 0;
        }
        int max=ln_f.length;
        if( (len+2)<max) {
//             System.err.println(len);
             return;
        }
//        System.err.println(len);
        double[] tmp = new double[len+2];
        for(int i=0;i<max;i++) tmp[i] = ln_f[i];
        for(int i=max;i<=len+1;i++) tmp[i] = tmp[i-1]+Math.log(i);
        ln_f = tmp;
    }

    public static int len(){
        if(ln_f==null) return 0;
        return(ln_f.length);
    }

    public static double value(int n){  // returns n!
        return Math.exp( ln_f(n) );
    }

    public static double lnvalue(int n){  // returns n!
        return  ln_f(n);
    }

    public static double P(int n, int i){  // returns n! / (n-i)!
        return Math.exp( ln_f[n] -  ln_f(n-i) );
    }

    public static double lnP(int n, int i){  // returns n! / (n-i)!
        return ( ln_f(n) - ln_f(n-i) );
    }

    public static double C(int n, int i){  // returns n! /i!/(n-i)!
        return Math.exp( ln_f(n) -  ln_f(i) -  ln_f(n-i) );
    }

    public static double lnC(int n, int i){  // returns n! /i!/(n-i)!
        return (ln_f(n) -  ln_f(i) -  ln_f(n-i) );
    }

    public static double ln_f(int n){
        if(n>len()-2) set(n);
        return ln_f[n];
    }

} 




