/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.dao
 *  t@CFPostgresReportDAO.java
 *  F|[gIuWFNg̉iǗNXłB
 *
 *  쐬: 2004/01/07
 */
package openolap.viewer.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

import openolap.viewer.Axis;
import openolap.viewer.Cube;
import openolap.viewer.Edge;
import openolap.viewer.Measure;
import openolap.viewer.Report;
import openolap.viewer.User;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.common.Constants;
import openolap.viewer.common.Messages;
import openolap.viewer.common.StringUtil;
import openolap.viewer.controller.RequestHelper;


/**
 *  NXFPostgresReportDAO
 *  F|[gIuWFNg̉iǗNXłB
 */
public class PostgresReportDAO implements ReportDAO {

	// ********** CX^Xϐ **********

	/** ConnectionIuWFNg */
	Connection conn = null;

	/** DAOFactoryIuWFNg */
	DAOFactory daoFactory = DAOFactory.getDAOFactory();

	/** MOIuWFNg */
	private Logger log = Logger.getLogger(PostgresReportDAO.class.getName());

	// ********** RXgN^ **********

	/**
	 * |[gIuWFNg̉iǗIuWFNg𐶐܂B
	 */
	PostgresReportDAO(Connection conn) {
		this.conn = conn;
	}

	// ********** \bh **********

	/**
	 * L[uV[PXԍƂɁA|[gIuWFNg𐶐B
	 * @param cubeSeq L[uV[PXԍ
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 * @return |[gIuWFNg
	 * @exception SQLException ɗO
	 */
	public Report getInitialReport(String cubeSeq, String userID, CommonSettings commonSettings) throws SQLException {

		String reportId = getInitialReportID(conn);
		String reportName = Report.getInitialReportName();
		String referenceReportID = Report.basicReportReferenceReportID;	// Ql|[gID
		Report report = getReport(reportId, reportName, userID, referenceReportID, Report.basicReportOwnerFLG, cubeSeq, commonSettings);
		
		report.setNewReport(true);// VK|[gƂĐݒ
		
		return report;
	}

	/**
	 * |[gIuWFNg𐶐B
	 * @param reportId |[gID
	 * @param reportName |[g
	 * @param cubeSeq L[uV[PXԍ
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 * @return |[gIuWFNg
	 * @exception SQLException ɗO
	 */
	public Report getReport(String reportId, String reportName, String userID, String referenceReportID, String reportOwnerFLG, String cubeSeq, CommonSettings commonSettings) throws SQLException {
		DimensionDAO dimDAO = daoFactory.getDimensionDAO(conn);
		ArrayList dimList = dimDAO.selectDimensions(cubeSeq);					// Dimension

		MeasureDAO measureDAO = daoFactory.getMeasureDAO(conn);
		Measure measure = measureDAO.findMeasureWithMember(cubeSeq, commonSettings);	// Measure

		ArrayList edgeList = Report.initializeEdge(dimList, measure);			// Edge List

		CubeDAO cubeDAO = daoFactory.getCubeDAO(conn);
		Cube cube = cubeDAO.getCubeByID(cubeSeq);

		ReportDAO reportDAO = daoFactory.getReportDAO(conn);
		Report report = new Report(reportId,									// reportID
									reportName,									// reportName
									userID,										// userID
									referenceReportID,							// referenceReportID
									reportOwnerFLG,								// reportOwnerFLG
									cube,										// cube
									edgeList,									// edgeList
									new ArrayList(),							// colorList
									Report.investigateTimeDimension(edgeList));	// hasTimeDim

		return report;
	}


	/**
	 * |[gIDƂɊ̃|[gIuWFNg߂B
	 * @param reportId |[gID
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 * @return |[gIuWFNg
	 * @exception SQLException ɗO
	 */
	public Report getExistingReport(String reportId, RequestHelper helper, CommonSettings commonSettings) throws SQLException {

		// Ԃ̃|[gݒ擾
		ReportInfo reportInfo = this.getReportInfo(reportId);
		// L[u݂ȂꍇAnull߂
		if(!this.isCubeExist((String) reportInfo.getCubeSeq())) {
			return null;
		}

		User user = (User)helper.getRequest().getSession().getAttribute("user");
		String userID = reportInfo.getUserID();							// [UID
		String referenceReportID = reportInfo.getReferenceReportID();	// Ql|[gID
		String reportOwnerFLG = reportInfo.getReportOwnerFLG();			// u1vF{|[g
		Report report = getReport(reportId, (String) reportInfo.getReportName(), userID, referenceReportID, reportOwnerFLG, (String) reportInfo.getCubeSeq(), commonSettings);

		// ReportIuWFNgɊi[tH_IDۑ
		report.setParentID(((String) reportInfo.getParentID()));
		report.setHighLightXML(((String) reportInfo.getHighLightXML()));
//System.out.println("getHighLightXML:" + (String) reportInfo.getHighLightXML());
		if (reportInfo.getDisplayScreenType() != null) { // 擾ʂNULLłȂ(null̏ꍇ́AReportIuWFNgŎOݒ肳ĂftHglgp)
			report.setDisplayScreenType(reportInfo.getDisplayScreenType());
		}
		if (reportInfo.getCurrentChart() != null) { // 擾ʂNULLłȂ
			report.setCurrentChart(reportInfo.getCurrentChart());
		}
		if (reportInfo.getColortype() != null) {// 擾ʂNULLłȂ
			report.setColorType((String) reportInfo.getColortype()); // colorTypeReportIuWFNgɊi[
		}


		// L[u\ύXĂꍇÃ|[g폜AVȃ|[gۑ(null̏ꍇ́AReportIuWFNgŎOݒ肳ĂftHglgp)
		if ( isCubeChanged(reportId, (String) reportInfo.getCubeSeq()) ) {
			if(log.isInfoEnabled()) {
				log.info("L[u\ύXĂ邽߁A|[g܂B\nreportID:" + reportId + ",cubeSeq:" + reportInfo.getCubeSeq());
			}

			// |[gNA
			DAOFactory daoFactory = DAOFactory.getDAOFactory();
			daoFactory.getAxisDAO(conn).deleteAxes(report,conn);// 
			daoFactory.getAxisMemberDAO(conn).deleteAxisMember(report,conn);// o
			daoFactory.getColorDAO(conn).deleteColor(report, conn); // F

			// |[gۑ
			this.saveReport(report, conn);

			// L[u\ύXbZ[Wۑ
			String message = Messages.getString("PostgresReportDAO.reportInitMSG");
			helper.getRequest().setAttribute("message", message);


		} else { // L[u\ɕύX̏ꍇAEFXV

			// XV
			AxisDAO axisDAO = daoFactory.getAxisDAO(conn);
			axisDAO.applyAxis(report, commonSettings, conn);
		
			// FXV
			ColorDAO colorDAO = daoFactory.getColorDAO(conn);
			colorDAO.applyColor(report, conn);
			
		}

		return report;
	}

	/**
	 * gp̃|[gID擾߂B
	 * @param conn ConnectionIuWFNg
	 * @return gp̃|[gID
	 * @exception SQLException ɗO
	 */
	public String getInitialReportID(Connection conn) throws SQLException {

		Statement stmt = null;
		ResultSet rs = null;

		String new_rep_id = null;
		String SQL = "";
		SQL += "SELECT ";
		SQL += "    nextval('report_id') as new_rep_id";

		try {
			stmt = conn.createStatement();
			if(log.isInfoEnabled()) {
				log.info("SQL(select axis members)F\n" + SQL);
			}
			rs = stmt.executeQuery(SQL);
			while(rs.next()){
				new_rep_id = Integer.toString(rs.getInt("new_rep_id"));
			}

		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}

		return new_rep_id;

	}

	/**
	 * NCAg瑗Mꂽ|[ǵ̖AetH_f̃|[gIuWFNgɔfB
	 *   p[^j
	 *     reportNameF|[g
	 *     folderIDF|[gi[tH_ID
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 */
	public void registReport(RequestHelper helper, CommonSettings commonSettings) {
		HttpServletRequest request = helper.getRequest();
		String reportName = (String)request.getParameter("reportName");
		String folderID = (String)request.getParameter("folderID");
	//	String highLightXML = (String)helper.getRequest().getSession().getAttribute("highLightXML");
//System.out.println("highLightXML:"+(String)helper.getRequest().getSession().getAttribute("highLightXML"));

		Report report = (Report)helper.getRequest().getSession().getAttribute("report");

		if ((reportName == null) || (folderID == null) ) {
			throw new IllegalStateException();
		}

		if (( request.getAttribute("mode") != null ) && 
		    ( request.getAttribute("mode").equals("saveNewReport"))) {
			report.setReportName(reportName);
			report.setParentID(folderID);
		}

	//	report.setHighLightXML(highLightXML);

//System.out.println(report.getHighLightXML());


	}

	/**
	 * NCAg瑗MꂽftHgo[A̔zuf̃|[gIuWFNgɔfB
	 *   p[^j
	 *     defaultMembersFS̃ftHgo[
	 *     colItemsFGbWɔzuꂽID
	 *     rowItemsFsGbWɔzuꂽID
	 *     pageItemsFy[WGbWɔzuꂽID
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 */
	public void registAxisPosition(RequestHelper helper, CommonSettings commonSettings) {

		HttpServletRequest request = helper.getRequest();
		String defaultMembers = (String)request.getParameter("defaultMembers");
		Report report = (Report)helper.getRequest().getSession().getAttribute("report");


		// NCAg玲̔zu擾(J}؂̎ID)
		ArrayList colAxesIDListFromClient = StringUtil.splitString((String)request.getParameter("colItems"), ",");
		ArrayList rowAxesIDListFromClient = StringUtil.splitString((String)request.getParameter("rowItems"), ",");
		ArrayList pageAxesIDListFromClient = StringUtil.splitString((String)request.getParameter("pageItems"), ",");

		registAxisPosition(colAxesIDListFromClient, rowAxesIDListFromClient, pageAxesIDListFromClient, report);

	}

	/**
	 * |[g̎̃GbWzuXVB
	 * @param colItemList ɔzuꂽIDXg
	 * @param rowItemList sɔzuꂽIDXg
	 * @param pageItemList y[WɔzuꂽIDXg
	 * @param report |[g킷IuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 */
	public void registAxisPosition(ArrayList colItemList, ArrayList rowItemList, ArrayList pageItemList, Report report) {

		// ̎HashMapɑޔ
		HashMap axisMap = new HashMap();
		Iterator it = report.getEdgeList().iterator();
		while (it.hasNext()) {
			Edge edge = (Edge) it.next();
			Iterator it2 = edge.getAxisList().iterator();
			while (it2.hasNext()) {
				Axis axis = (Axis) it2.next();
				axisMap.put(axis.getId(),axis);
			}
		}

		// Col̔zuXV
		ArrayList colAxesListFromModel = report.getEdgeByType(Constants.Col).getAxisList();
		replaceAxisList(colItemList, colAxesListFromModel, axisMap);

		// Row̔zuXV
		ArrayList rowAxesListFromModel = report.getEdgeByType(Constants.Row).getAxisList();
		replaceAxisList(rowItemList, rowAxesListFromModel, axisMap);

		// Page̔zuXV
		ArrayList pageAxesListFromModel = report.getEdgeByType(Constants.Page).getAxisList();
		replaceAxisList(pageItemList, pageAxesListFromModel, axisMap);
		
	}

	/**
	 * VKl|[gf[^\[X֕ۑB
	 * @param report |[g킷IuWFNg
	 * @param newReportName VK|[g
	 * @param userID [UID
	 * @param conn ConnectionIuWFNg
	 * @exception SQLException ɗO
	 */
	public void saveNewPersonalReport(Report report, String newReportName, String userID, Connection conn)  throws SQLException {

	  String SQL = "";
      Statement stmt = conn.createStatement();

	  try {

		  //|[gID̓V[PXVK擾
		  String newReportID = this.getInitialReportID(conn);

		  SQL =  "";
		  SQL += "INSERT INTO oo_v_report ";
		  SQL += "       (report_id, par_id, report_name, user_id, reference_report_id, report_owner_flg, cube_seq, update_date, kind_flg, highlight_xml, displayscreentype, currentchart, colortype)";
		  SQL += "values (   "+ newReportID + ", ";						// |[gID
		  SQL +=                "null, ";								// [gtH_ɍ쐬
		  SQL +=          "'" + newReportName + "', ";					// VK|[g
		  SQL +=          "'" + userID + "', ";							// [UIDiReportuserID͂̃|[g쐬[UIDł邽߁AgpȂj
		  SQL +=                report.getReportID() + ", ";			
		  SQL +=          "'" + Report.personalReportOwnerFLG + "', ";	// uQvFl|[g
		  SQL +=                report.getCube().getCubeSeq() + ", ";	
		  SQL +=                "now(), ";
		  SQL +=                "'R',";
		  SQL +=          "'" + report.getHighLightXML() + "', ";
		  SQL +=          "'" + report.getDisplayScreenType() + "', ";
		  SQL +=          "'" + report.getCurrentChart() + "', ";
		  SQL +=          "'" + report.getColorType() + "' ";
		  SQL +=          ")";

		  if(log.isInfoEnabled()) {
			  log.info("SQL(insert new personal report)F\n" + SQL);
		  }
		  int count = stmt.executeUpdate(SQL);
		  if (count != 1) {
			  throw new IllegalStateException();
		  }
	
		  // ̕ۑ
		  DAOFactory daoFactory = DAOFactory.getDAOFactory();
		  AxisDAO axisDAO = daoFactory.getAxisDAO(conn);
		  axisDAO.saveAxis(report, newReportID, conn);
	
		  // F̕ۑ
		  ColorDAO colorDAO = daoFactory.getColorDAO(conn);
		  colorDAO.saveColor(report, newReportID, conn);

	  } catch (IllegalStateException e) {
		  throw e;
	  } catch (SQLException e) {
		  throw e;
	  } finally {
		  if (stmt != null) {
			  stmt.close();
		  }
	  }
  }

	/**
	 * |[gf[^\[X֕ۑB
	 * @param report |[g킷IuWFNg
	 * @param conn ConnectionIuWFNg
	 * @exception SQLException ɗO
	 */
	public void saveReport(Report report, Connection conn) throws SQLException {

		String SQL = "";

		// {|[gAl|[g̍XV
		SQL =  "";
		SQL += "UPDATE oo_v_report set";
		SQL += "    report_name='" + report.getReportName() + "', ";
//		SQL += "    user_id='" + report.getUserID() + "', ";
//		SQL += "    reference_report_id=" + report.getReferenceReportID() + ", ";
//		SQL += "    report_owner_flg='" + report.getReportOwnerFLG() + "', ";
		SQL += "    update_date=now(), ";
		SQL += "    par_id=" + report.getParentID() + ",";
		SQL += "    highlight_xml='" + report.getHighLightXML() + "', ";
		SQL += "    displayscreentype='" + report.getDisplayScreenType() + "', ";
		SQL += "    currentchart='" + report.getCurrentChart() + "', ";
		SQL += "    colortype='" + report.getColorType() + "' ";
		SQL += "WHERE ";
		SQL += "    report_id=" + report.getReportID();

		if(log.isInfoEnabled()) {
			log.info("SQL(update basic/personal report)F\n" + SQL);
		}
		Statement stmt = conn.createStatement();
		int updateCount = stmt.executeUpdate(SQL);

		try {
			// update0̏ꍇA{|[g̃R[h쐬
			if (updateCount == 0) {
				SQL =  "";
				SQL += "INSERT INTO oo_v_report ";
				SQL += "       (report_id, par_id, report_name, user_id, reference_report_id, report_owner_flg, cube_seq, update_date, kind_flg, highlight_xml, displayscreentype, currentchart, colortype) ";
				SQL += "values ( "  + report.getReportID() + ", ";
				SQL +=                report.getParentID() + ", ";
				SQL +=          "'" + report.getReportName() + "', ";
				SQL +=          "'" + Report.basicReportUserID + "', ";		// {|[ǵAuser_id
				SQL +=                report.getReferenceReportID() + ", ";
				SQL +=          "'" + report.getReportOwnerFLG() + "', ";
				SQL +=                report.getCube().getCubeSeq() + ", ";
				SQL +=                "now(), ";
				SQL +=                "'R',";
				SQL +=          "'" + report.getHighLightXML() + "', ";
				SQL +=          "'" + report.getDisplayScreenType() + "', ";
				SQL +=          "'" + report.getCurrentChart() + "', ";
				SQL +=          "'" + report.getColorType() + "' ";
				SQL +=          ")";

				if(log.isInfoEnabled()) {
					log.info("SQL(insert new basic report)F\n" + SQL);
				}
				int count = stmt.executeUpdate(SQL);
				if (count != 1) {
					throw new IllegalStateException();
				}

				// {|[gVK쐬AZLeBo^
				if(report.isNewReport()) {
					SQL =  "";
					SQL += "INSERT INTO oo_v_group_report (group_id, report_id, right_flg, export_flg) ";
					SQL += "select group_id," + report.getReportID() + ",'1','1' from oo_v_group";

					if(log.isInfoEnabled()) {
						log.info("SQL(insert security information for new basic report)F\n" + SQL);
					}
					count = stmt.executeUpdate(SQL);
					if (count < 1) {
						throw new IllegalStateException();
					}
				}
			}		
	
			// ̕ۑ
			DAOFactory daoFactory = DAOFactory.getDAOFactory();
			AxisDAO axisDAO = daoFactory.getAxisDAO(conn);
			axisDAO.saveAxis(report, null, conn);
	
			// F̕ۑ
			ColorDAO colorDAO = daoFactory.getColorDAO(conn);
			colorDAO.saveColor(report, null, conn);

		} catch (IllegalStateException e) {
			throw e;
		} catch (SQLException e) {
			throw e;
		} finally {
			if (stmt != null) {
				stmt.close();
			}
		}
	}


	/**
	 * |[gf[^\[X폜B
	 * @param report |[g킷IuWFNg
	 * @param conn ConnectionIuWFNg
	 * @exception SQLException ɗO
	 */
	public void deleteReport(Report report, Connection conn) throws SQLException {

		// |[gIuWFNĝ폜
		String SQL = "";
		SQL =  "";
		SQL += "delete from oo_v_report ";
		SQL += "where ";
		SQL += "    report_id=" + report.getReportID();

		Statement stmt = null;
		try {
			stmt = conn.createStatement();
			if(log.isInfoEnabled()) {
				log.info("SQL(delete report)F\n" + SQL);
			}
			stmt.executeUpdate(SQL);
		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if(stmt != null) {
					stmt.close();
				}
			} catch (SQLException e) {
				throw e;
			}
		}

		// ̍폜
		DAOFactory daoFactory = DAOFactory.getDAOFactory();
		AxisDAO axisDAO = daoFactory.getAxisDAO(conn);
		axisDAO.deleteAxes(report, conn);

		// F̍폜
		ColorDAO colorDAO = daoFactory.getColorDAO(conn);
		colorDAO.deleteColor(report, conn);

	}


	// ********** NX **********

	/**
	 *  NXFPostgresAxisDAO
	 *  F|[g󂯓n߂̓NXłB
	 */
	class ReportInfo {

		String reportName = null;
		String cubeSeq = null;
		String parentID = null;
		String userID = null;				// [UID
		String referenceReportID = null;	// Qƌ|[gID
		String reportOwnerFLG = null;		// |[g̎
		String highLightXML = null;
		String displayScreenType = null;	// ʕX^C
		String currentChart = null;		// \̃Ot
		String colortype = null;

		public void setReportName(String reportName){
			this.reportName = reportName;
		}
		public void setCubeSeq(String cubeSeq){
			this.cubeSeq = cubeSeq;
		}
		public void setParentID(String parentID){
			this.parentID = parentID;
		}
		public void setUserID(String userID){
			this.userID = userID;
		}
		public void setReferenceReportID(String referenceReportID){
			this.referenceReportID = referenceReportID;
		}
		public void setReportOwnerFLG(String reportOwnerFLG){
			this.reportOwnerFLG = reportOwnerFLG;
		}
		public void setHighLightXML(String highLightXML){
			this.highLightXML = highLightXML;
		}
		public void setDisplayScreenType(String displayScreenType) {
			this.displayScreenType = displayScreenType;
		}
		public void setCurrentChart(String currentChart) {
			this.currentChart = currentChart;
		}
		public void setColortype(String colortype) {
			this.colortype = colortype;
			
		}

		public String getReportName() {
			return this.reportName;
		}
		public String getCubeSeq() {
			return this.cubeSeq;
		}
		public String getParentID() {
			return this.parentID;
		}
		public String getUserID() {
			return this.userID;
		}
		public String getReferenceReportID() {
			return this.referenceReportID;
		}
		public String getReportOwnerFLG() {
			return this.reportOwnerFLG;
		}
		public String getHighLightXML() {
			return this.highLightXML;
		}
		public String getDisplayScreenType() {
			return this.displayScreenType;
		}
		public String getCurrentChart() {
			return this.currentChart;
		}
		public String getColortype() {
			return this.colortype;
		}

	}

	// ********** private\bh **********

	/**
	 * |[gi[ReportInfoNX߂B
	 * @param reportId |[gID
	 * @exception SQLException ɗO
	 */
	private ReportInfo getReportInfo(String reportId) throws SQLException {

		String reportName = null;
		String cubeSeq = null;
		String parentID = null;
		String userID = null;
		String referenceReportID = null;
		String reportOwnerFLG = null;
		String highLightXML = null;
		String displayscreentype = null;
		String currentchart = null;
		String colortype = null;

		String SQL = "";
		SQL += "select ";
		SQL += "    report_name,";				// |[g
		SQL += "    cube_seq, ";				// CubeSeq
		SQL += "    par_id, ";					// |[gi[̃tH_
		SQL += "    user_id, ";					// [UID
		SQL += "    reference_report_id, ";		// Qƌ|[gID
		SQL += "    report_owner_flg, ";		// |[g̎
		SQL += "    highlight_xml, ";			
		SQL += "    displayscreentype, ";		// ʕX^C
		SQL += "    currentchart, ";			// \̃Ot
		SQL += "    colortype ";			// \̃Ot
		SQL += "from ";
		SQL += "    oo_v_report ";
		SQL += "where ";
		SQL += "    report_id=" + reportId;

		Statement stmt = null;
		ResultSet rs = null;
		ReportInfo reportInfo = null;
		try {
			stmt = conn.createStatement();
			if(log.isInfoEnabled()) {
				log.info("SQL(select report)F\n" + SQL);
			}
			rs = stmt.executeQuery(SQL);
	
			while ( rs.next() ) {
				reportName = rs.getString("report_name");
				cubeSeq = rs.getString("cube_seq");
				parentID = rs.getString("par_id");
				userID = rs.getString("user_id");
				referenceReportID = rs.getString("reference_report_id");
				reportOwnerFLG = rs.getString("report_owner_flg");			
				highLightXML = rs.getString("highlight_xml");
				displayscreentype = rs.getString("displayscreentype");
				currentchart = rs.getString("currentchart");
				colortype = rs.getString("colortype");
			}

			reportInfo = new ReportInfo();
			reportInfo.setReportName(reportName);
			reportInfo.setCubeSeq(cubeSeq);
			reportInfo.setParentID(parentID);
			reportInfo.setUserID(userID);
			reportInfo.setReferenceReportID(referenceReportID);
			reportInfo.setReportOwnerFLG(reportOwnerFLG);
			reportInfo.setHighLightXML(highLightXML);
			reportInfo.setDisplayScreenType(displayscreentype);
			reportInfo.setCurrentChart(currentchart);
			reportInfo.setColortype(colortype);

		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}

		return reportInfo;

	}


	/**
	 * |[g\L[u݂邩i폜ĂȂj`FbNB
	 * ݂ꍇtrueA݂Ȃꍇfalse߂B
	 * @param cubeSeq L[uV[PXԍ
	 * @return |[g\L[u݂邩
	 * @exception SQLException ɗO
	 */
	private boolean isCubeExist(String cubeSeq) throws SQLException {
		
		String SQL = "";
		SQL += "select  ";
		SQL += "	cube_seq ";
		SQL += "from ";
		SQL += "    oo_info_cube ";
		SQL += "where cube_seq=" + cubeSeq ;

		Statement stmt = null;
		ResultSet rs = null;
		try {
			stmt = conn.createStatement();
			if(log.isInfoEnabled()) {
				log.info("SQL(select isCubeExist)F\n" + SQL);
			}
			rs = stmt.executeQuery(SQL);

			int i = 0;
			while(rs.next()){
				i++;
				if ( i>=1 ) {	// L[u\ύXĂ
					return true;
				}
			}

		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}

		return false;	// |[g\L[u폜ꂽ
	}


	/**
	 * |[gɕۑꂽԂL[u\ύXꂽǂ`FbNB
	 * \ύXꂽꍇtrueAύXĂȂꍇfalse߂B
	 * @param reportId |[gID
	 * @param cubeSeq L[uV[PXԍ
	 * @return \ύXꂽ
	 * @exception SQLException ɗO
	 */
	private boolean isCubeChanged(String reportId, String cubeSeq) throws SQLException {
		
		String SQL = "";
		SQL += "select  ";
		SQL += "    distinct r.cube_seq,d.dimension_seq ";
		SQL += "from  ";
		SQL += "    oo_v_report r,oo_v_axis d ";
		SQL += "where  ";
		SQL += "    r.report_id=d.report_id and  ";
		SQL += "    r.report_id=" + reportId + " and  ";
		SQL += "    d.dimension_seq!=0 ";	// W[ł͂Ȃ
		SQL += "except ";
		SQL += "select ";
		SQL += "    cube_seq,dimension_seq  ";
		SQL += "from  ";
		SQL += "    oo_info_dim ";
		SQL += "where  ";
		SQL += "    cube_seq=" + cubeSeq;

		String SQL2 = "";
		SQL2 += "select ";
		SQL2 += "    cube_seq,dimension_seq  ";
		SQL2 += "from  ";
		SQL2 += "    oo_info_dim ";
		SQL2 += "where  ";
		SQL2 += "    cube_seq=" + cubeSeq + " ";
		SQL2 += "except ";
		SQL2 += "select  ";
		SQL2 += "    distinct r.cube_seq,d.dimension_seq ";
		SQL2 += "from  ";
		SQL2 += "    oo_v_report r,oo_v_axis d ";
		SQL2 += "where  ";
		SQL2 += "    r.report_id=d.report_id and  ";
		SQL2 += "    r.report_id=" + reportId + " and  ";
		SQL2 += "    d.dimension_seq!=0 ";	// W[ł͂Ȃ
		
		Statement stmt = null;
		ResultSet rs = null;
		
		try {
			// SQL1s
			stmt = conn.createStatement();
			if(log.isInfoEnabled()) {
				log.info("SQL(select isCubeChanged 1)F\n" + SQL);
			}
			rs = stmt.executeQuery(SQL);
			int i = 0;
			while(rs.next()){
				i++;
				if ( i>0 ) {	// L[u\ύXĂ
					return true;
				}
			}

			// SQL2s
			stmt = conn.createStatement();
			if(log.isInfoEnabled()) {
				log.info("SQL(select isCubeChanged 2)F\n" + SQL2);
			}
			rs = stmt.executeQuery(SQL2);
			i = 0;
			while(rs.next()){
				i++;
				if ( i>0 ) {	// L[u\ύXĂ
					return true;
				}
			}

		} catch (SQLException e) {
			throw e;
		} finally {
			try {
				if (rs != null){
					rs.close();
				}
			} catch (SQLException e) {
				throw e;
			} finally {
				try {
					if (stmt != null){
						stmt.close();
					}
				} catch (SQLException e) {
					throw e;
				}
			}
		}

		return false;	// L[u\ύXĂȂ
	}

	/**
	 * ̃f玲폜A^ꂽGbWĒǉB
	 * @param edgeAxesIDListFromClient AsA̓y[WGbWɔzuꂽID̃Xg
	 * @param edgeAxesListFromModel |[gɔzuꂽAsA̓y[WGbW̎IuWFNgXg
	 * @param axisMap IDƎIuWFNg킷MapIuWFNg
	 */
	private void replaceAxisList(ArrayList edgeAxesIDListFromClient, ArrayList edgeAxesListFromModel, HashMap axisMap) {

		edgeAxesListFromModel.clear();							// GbWNA

		Iterator it = edgeAxesIDListFromClient.iterator();		// GbWɒǉ
		while(it.hasNext()){
			edgeAxesListFromModel.add(axisMap.get(it.next()));
		}

	}

}
