/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFSaveClientReportStatusCommand.java
 *  F|[gf[^x[XɕۑNXłB
 *
 *  쐬: 2004/01/14
 */
package openolap.viewer.controller;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;

import javax.servlet.ServletException;

import openolap.viewer.Report;
import openolap.viewer.User;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.dao.AxisDAO;
import openolap.viewer.dao.ColorDAO;
import openolap.viewer.dao.DAOFactory;
import openolap.viewer.dao.ReportDAO;

/**
 *  NXFSaveClientReportStatusCommand<br>
 *  F|[gf[^x[XɕۑNXłB
 */
public class SaveClientReportStatusCommand implements Command {

	// ********** CX^Xϐ **********

	/** RequestHelperIuWFNg */
	private RequestHelper requestHelper = null;

	/**
	 * NCAg擾LƂɃT[o[̃fXVA|[g̕ۑsB<br>
	 *    |Fݒ
	 *    |õh
	 *    ||[gi|[gAetH_[IDj
	 * |[gۑ͑SĂ̏ꍇcommitȂAsꍇrollbackB
	 * L[u쐬̃|[gł΁ADBւ̕ۑIɐVK|[g킷tOisNewReportfalseɕύXB
	 * |[g̕ۑӖAbZ[Walertŕ\y[W߂B
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 * @return dispatchJSP/HTML̃pX
	 * @exception ServletException ɗO
	 * @exception IOException ɗO
	 * @exception Exception ɗO
	 */
	public String execute(RequestHelper helper, CommonSettings commonSettings)
		throws ServletException, IOException, Exception {

		String reportName = (String)helper.getRequest().getParameter("reportName");
		String folderID = (String)helper.getRequest().getParameter("folderID");

		// |[gۑꏊwtŕۑ
		if ( (!reportName.equals("")) && (!folderID.equals("")) ) {
			helper.getRequest().setAttribute("mode", "saveNewReport");
		}

		Connection conn = null;
		DAOFactory daoFactory = DAOFactory.getDAOFactory();
		conn = daoFactory.getConnection((String)helper.getRequest().getSession().getAttribute("connectionPoolName"),
										(String)helper.getRequest().getSession().getAttribute("searchPathName"));

		// =========================================
		// ServerŕێĂ郌|[gfXV
		// =========================================

		// FݒXV
		ColorDAO colorDAO = daoFactory.getColorDAO(null);
		colorDAO.registColor(helper, commonSettings);

		// õh
		AxisDAO axisDAO = daoFactory.getAxisDAO(null);
		axisDAO.registSelectedMemberAndDrillStat(helper, commonSettings);

		// |[gi|[gAetH_[IDjXV
		ReportDAO reportDAO = daoFactory.getReportDAO(null);
		reportDAO.registReport(helper, commonSettings);

		// =========================================
		// |[gݒi
		// =========================================
		Report report = (Report) helper.getRequest().getSession().getAttribute("report");
		User user = (User) helper.getRequest().getSession().getAttribute("user");
		try {
			conn.setAutoCommit(false);

			if (user.isAdmin()){
				report.saveReport(conn);
			} else {
				if (user.isPersonalReportSavable()) {

					// Ǘ҃[UłȂAl|[gۑ\ȃ[U[łA
					// Ã݂|[g{|[głꍇA
					// {|[gƂɐVKl|[g쐬B
					if (report.getReportOwnerFLG().equals(Report.basicReportOwnerFLG)) { 
						String newPersonalReportname = report.getReportName() + Report.personalReportNameSuffix;
						report.saveNewPersonalReport(newPersonalReportname, user.getUserID(), conn);

						// VKl|[g쐬̏ꍇA쐬ō̃c[XV邽߁AtO𗧂ĂĂ
						helper.getRequest().setAttribute("isCreatingNewPersonalReport", Boolean.TRUE);

					} else { // ݂̃|[gl|[głꍇǍl|[gXVB
						report.saveReport(conn);
					}
					
					
				}
				
			}

			conn.commit();
		} catch (SQLException e) {
			try {
				if (conn != null){
					conn.rollback();
				}
				throw e;
			} catch (SQLException e1) {
				throw e1;
			}
		} catch (Exception e) {
			try {
				if (conn != null){
					conn.rollback();
				}
				throw e;
			} catch (SQLException e1) {
				throw e1;
			}
		} finally {
			try {
				if (conn != null) {
					conn.close();
				}

			} catch (SQLException e1) {
				throw e1;
			}
		}

		// =========================================
		// I
		// =========================================
		if(report.isNewReport()) {
			report.setNewReport(false);
		}

		return "/spread/saveFinalize.jsp";
	}

}
