/*  OpenOlap viewer
 *  pbP[WFopenolap.viewer.controller
 *  t@CFExportReportCommand.java
 *  F|[g̃GNX|[gsNXłB
 *
 *  쐬: 2004/01/31
 */
package openolap.viewer.controller;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import openolap.viewer.User;
import openolap.viewer.common.CommonSettings;
import openolap.viewer.export.ExportReport;
import openolap.viewer.export.ExportReportFactory;
import openolap.viewer.manager.CellDataManager;

/**
 *  NXFExportReportCommand<br>
 *  F|[g̃GNX|[gsNXłB
 */
public class ExportReportCommand implements Command {

	// ********** \bh **********

	/**
	 * GNX|[gsB<br>
	 * GNX|[g^Cv͂̃ZbVɃZbgĂ郆[UIuWFNg̃GNX|[gt@C^CvŎw肳Ă`ɏ]B
	 * @param helper RequestHelperIuWFNg
	 * @param commonSettings AvP[V̋ʐݒIuWFNg
	 * @return dispatchJSP/HTML̃pX
	 * @exception ServletException ɗO
	 * @exception IOException ɗO
	 * @exception NamingException ɗO
	 */
	public String execute(RequestHelper helper, CommonSettings commonSettings)
		throws ServletException, FileNotFoundException, UnsupportedEncodingException, SQLException, NamingException, IOException, ParserConfigurationException, SAXException, TransformerException {

		// fBVoAZf[^擾SessionɈꎞۑ
		// iZf[^擾|[g̒l擾Ƌʉ邽߁j
		CellDataManager.saveRequestParamsToSession(helper);

		User user = (User) helper.getRequest().getSession().getAttribute("user");

		// GNX|[gs
		ExportReportFactory exportReportFactory = new ExportReportFactory();
		ExportReport exportReport = exportReportFactory.getExportReport(user);
		String page = exportReport.exportReport(helper);

		return page;
	}

}
