/*
 * Decompiled with CFR 0.152.
 */
package net.black_cow.opennip.ui.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.black_cow.opennip.opennipcore.NipManager;
import net.black_cow.opennip.opennipcore.NipPlayer;
import net.black_cow.opennip.opennipcore.NipStone;
import net.black_cow.opennip.opennipcore.NipStrategy;
import net.black_cow.opennip.strategy.MouseClickStrategy;
import net.black_cow.opennip.strategy.OneStepMaximizeStrategy;
import net.black_cow.opennip.strategy.RandomStrategy;
import net.black_cow.opennip.ui.swing.BoardLabel;
import net.black_cow.opennip.ui.swing.ConcreteNipObserver;
import net.black_cow.opennip.ui.swing.MessageDialog;
import net.black_cow.opennip.ui.swing.MessageModalDialog;
import net.black_cow.opennip.ui.swing.MouseClickInfo;
import net.black_cow.opennip.ui.swing.UIConstant;

public class OpenNipUI {
    private MouseClickInfo info = new MouseClickInfo();
    private static NipManager manager;
    private JFrame frame = new JFrame("OpenNip");
    private JPanel boardPanel = new JPanel();
    private BoardLabel board;
    private JPanel informationPanel = new JPanel();
    private JLabel information = new JLabel();
    private JPanel messagePanel = new JPanel();
    private JLabel message = new JLabel();
    private int whiteScore;
    private int blackScore;
    private MessageDialog dialog = new MessageDialog(this.frame);

    public static void main(String[] args) {
        OpenNipUI ui = new OpenNipUI();
        ui.initGUI();
        NipPlayer first = new NipPlayer();
        NipPlayer second = new NipPlayer();
        ui.showDialog("OpenNip", 1500L, UIConstant.TITLE_MESSAGE_FONT, UIConstant.TITLE_MESSAGE_COLOR);
        do {
            first.setStrategy(ui.askStrategy("<html>\u5148\u624b\uff08\u9ed2\uff09\u306e\u30d7\u30ec\u30a4\u30e4\u30fc\u3092<br>\u9078\u3093\u3067\u304f\u3060\u3055\u3044\u3002</html>"));
            second.setStrategy(ui.askStrategy("<html>\u5f8c\u624b\uff08\u767d\uff09\u306e\u30d7\u30ec\u30a4\u30e4\u30fc\u3092<br>\u9078\u3093\u3067\u304f\u3060\u3055\u3044\u3002</html>"));
            manager = new NipManager(first, second);
            manager.addObservers(new ConcreteNipObserver(ui));
            manager.play();
        } while (ui.askReplay());
    }

    public OpenNipUI() {
        this.board = new BoardLabel(new ImageIcon(this.getClass().getClassLoader().getResource("Board.gif")), this.info);
    }

    void setMessage(String message) {
        this.message.setText(message);
    }

    void refreshInformation() {
        this.information.setText("Black " + this.blackScore + " " + "-" + " " + this.whiteScore + " " + "White");
    }

    void refresh() {
        this.board.refresh(manager);
        this.whiteScore = manager.getStoneCount(NipStone.Color.WHITE);
        this.blackScore = manager.getStoneCount(NipStone.Color.BLACK);
        this.refreshInformation();
    }

    void drawBoard(int row, int column, NipStone.Color color) {
        this.board.paint(row, column, color);
    }

    void incrementScore(NipStone.Color color) {
        if (color.equals((Object)NipStone.Color.BLACK)) {
            ++this.blackScore;
        } else {
            ++this.whiteScore;
        }
    }

    void decrementScore(NipStone.Color color) {
        if (color.equals((Object)NipStone.Color.BLACK)) {
            --this.blackScore;
        } else {
            --this.whiteScore;
        }
    }

    private void initGUI() {
        this.setBoardPanel();
        this.setInformationPanel();
        this.setMessagePanel();
        this.setFrameFactors();
    }

    private void setBoardPanel() {
        this.boardPanel.setBackground(UIConstant.BOARD_PANEL_COLOR);
        this.boardPanel.add(this.board);
        this.boardPanel.setPreferredSize(UIConstant.BOARD_PANEL_SIZE);
    }

    private void setInformationPanel() {
        this.information.setText("White 0 - 0 Black");
        this.informationPanel.setBackground(UIConstant.INFORMATION_PANEL_COLOR);
        this.information.setFont(UIConstant.INFORMATION_FONT);
        this.information.setHorizontalAlignment(0);
        this.information.setVerticalAlignment(0);
        this.information.setPreferredSize(UIConstant.INFORMATION_PANEL_SIZE);
        this.informationPanel.setLayout(new GridLayout(1, 1));
        this.informationPanel.setPreferredSize(UIConstant.INFORMATION_PANEL_SIZE);
        this.informationPanel.add(this.information);
    }

    private void setMessagePanel() {
        this.messagePanel.setBackground(UIConstant.MESSAGE_PANEL_COLOR);
        this.message.setFont(UIConstant.MESSAGE_FONT);
        this.message.setHorizontalAlignment(0);
        this.message.setVerticalAlignment(0);
        this.message.setPreferredSize(UIConstant.MESSAGE_PANEL_SIZE);
        this.messagePanel.setLayout(new GridLayout(1, 1));
        this.messagePanel.add(this.message);
        this.messagePanel.setPreferredSize(UIConstant.MESSAGE_PANEL_SIZE);
    }

    private void setFrameFactors() {
        this.frame.setResizable(false);
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setLayout(new BoxLayout(this.frame.getContentPane(), 1));
        this.frame.getContentPane().add(this.boardPanel);
        this.frame.getContentPane().add(this.informationPanel);
        this.frame.getContentPane().add(this.messagePanel);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    void showDialog(String message, long lifeTime, Font font, Color textColor) {
        this.dialog.setText(message, font, textColor);
        this.dialog.setVisible(true);
        try {
            Thread.sleep(lifeTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.dialog.setVisible(false);
    }

    private NipStrategy askStrategy(String message) {
        JButton man = new JButton("\u4eba");
        man.setPreferredSize(UIConstant.BUTTON_SIZE);
        JButton weak = new JButton("CPU\uff08\u5f31\uff09");
        weak.setPreferredSize(UIConstant.BUTTON_SIZE);
        JButton strong = new JButton("CPU\uff08\u5f37\uff09");
        strong.setPreferredSize(UIConstant.BUTTON_SIZE);
        MessageModalDialog dialog = new MessageModalDialog(this.frame, man, weak, strong);
        dialog.setText(message, UIConstant.DESCRIPTION_FONT, null);
        dialog.setVisible(true);
        Object reply = dialog.getReply();
        if (reply == man) {
            return new MouseClickStrategy(this.info);
        }
        if (reply == weak) {
            return new RandomStrategy(200L);
        }
        return new OneStepMaximizeStrategy(200L);
    }

    private boolean askReplay() {
        JButton yes = new JButton("\u306f\u3044");
        yes.setPreferredSize(UIConstant.BUTTON_SIZE);
        JButton no = new JButton("\u3044\u3044\u3048");
        no.setPreferredSize(UIConstant.BUTTON_SIZE);
        MessageModalDialog dialog = new MessageModalDialog(this.frame, yes, no);
        dialog.setText("\u3082\u3046\u4e00\u5ea6\u904a\u3073\u307e\u3059\u304b\uff1f", UIConstant.DESCRIPTION_FONT, null);
        dialog.setVisible(true);
        return dialog.getReply() == yes;
    }
}

