/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.SystemManager;
import org.opengion.hayabusa.resource.ResourceManager;

public final class ResourceFactory {
    private static final String SYSTEM_ID = HybsSystem.sys("SYSTEM_ID");
    private static final ResourceManager JA_MANAGER = new ResourceManager(SYSTEM_ID, "ja", true);
    private static final ConcurrentMap<String, ResourceManager> POOL = new ConcurrentHashMap<String, ResourceManager>();

    private ResourceFactory() {
    }

    public static ResourceManager newInstance(String string) {
        return string == null || "ja".equalsIgnoreCase(string) ? JA_MANAGER : ResourceFactory.newInstance(SYSTEM_ID, string, true);
    }

    public static ResourceManager newInstance(String string, String string2, boolean bl) {
        String string4;
        String string5 = string == null ? SYSTEM_ID : string;
        String string6 = string4 = string2 == null ? "ja" : string2;
        if (SYSTEM_ID.equalsIgnoreCase(string5) && "ja".equalsIgnoreCase(string4)) {
            return JA_MANAGER;
        }
        String string7 = string5 + string4;
        return POOL.computeIfAbsent(string7, string3 -> new ResourceManager(string5, string4, bl));
    }

    public static void clear() {
        JA_MANAGER.clear();
        POOL.values().forEach(resourceManager -> resourceManager.clear());
        POOL.clear();
    }

    public static void guiClear() {
        JA_MANAGER.guiClear();
        POOL.values().forEach(resourceManager -> resourceManager.guiClear());
    }

    static {
        Cleanable cleanable = new Cleanable(){

            public void clear() {
                ResourceFactory.clear();
            }
        };
        SystemManager.addCleanable(cleanable);
    }
}

