/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.io.TableWriter;

public abstract class AbstractTableWriter
implements TableWriter {
    private static final String VERSION = "7.0.1.0 (2018/10/15)";
    protected static final String CR = HybsConst.CR;
    protected static final int BUFFER_MIDDLE = 200;
    public static final int STRING = 0;
    public static final int NVAR = 1;
    public static final int NUMBER = 2;
    protected int numberOfColumns = -1;
    protected DBTableModel table;
    protected DBColumn[] dbColumn;
    protected int[] clmNo;
    protected int[] dbType;
    protected boolean[] isKeyLbl;
    private String separator = "\t";
    private String headerSequence = HybsSystem.sys("WRITER_HEADER_SEQUENCE");
    private boolean append;
    private String lang;
    private String columns;
    private String omitNames;
    private String encode;
    private boolean useNumber = true;
    private boolean useRenderer;
    private boolean useDebug;

    protected AbstractTableWriter() {
    }

    @Override
    public abstract void writeDBTable();

    @Override
    public abstract void writeDBTable(PrintWriter var1);

    protected boolean createDBColumn() {
        if (this.numberOfColumns >= 0) {
            return true;
        }
        boolean bl = false;
        if (this.lang != null && this.table != null) {
            int n;
            int n2;
            int n3;
            if (this.columns == null) {
                this.numberOfColumns = this.table.getColumnCount();
                this.clmNo = new int[this.numberOfColumns];
                for (n3 = 0; n3 < this.numberOfColumns; ++n3) {
                    this.clmNo[n3] = n3;
                }
            } else {
                String[] stringArray = StringUtil.csv2Array((String)this.columns);
                this.numberOfColumns = stringArray.length;
                this.clmNo = new int[this.numberOfColumns];
                for (n2 = 0; n2 < this.numberOfColumns; ++n2) {
                    this.clmNo[n2] = n = this.table.getColumnNo(stringArray[n2], false);
                }
            }
            if (this.omitNames != null) {
                String[] stringArray = StringUtil.csv2Array((String)this.omitNames);
                block2: for (n2 = 0; n2 < stringArray.length; ++n2) {
                    n = this.table.getColumnNo(stringArray[n2], false);
                    if (n < 0) continue;
                    for (int i = 0; i < this.numberOfColumns; ++i) {
                        if (this.clmNo[i] != n) continue;
                        this.clmNo[i] = -1;
                        continue block2;
                    }
                }
            }
            this.dbColumn = this.table.getDBColumns();
            bl = this.numberOfColumns > 0;
            this.dbType = new int[this.numberOfColumns];
            this.isKeyLbl = new boolean[this.numberOfColumns];
            for (n3 = 0; n3 < this.numberOfColumns; ++n3) {
                n2 = this.clmNo[n3];
                if (n2 < 0) continue;
                String string = this.dbColumn[n2].getDbType();
                this.dbType[n3] = "NVAR".equals(string) ? 1 : ("S9".equals(string) || "R".equals(string) ? 2 : 0);
                this.isKeyLbl[n3] = this.dbColumn[n2].isWriteKeyLabel();
            }
        }
        return bl;
    }

    protected void writeHeader(PrintWriter printWriter) {
    }

    protected void writeLabel2(DBTableModel dBTableModel, PrintWriter printWriter) {
        if (this.useNumber) {
            printWriter.print(this.separator);
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n;
            if (i != 0) {
                printWriter.print(this.separator);
            }
            if ((n = this.clmNo[i]) < 0) continue;
            String string = StringUtil.tagCut((String)this.dbColumn[n].getLabel());
            printWriter.print(this.quotation(string));
            if (!this.isKeyLbl[i]) continue;
            printWriter.print(this.separator);
        }
        printWriter.println();
    }

    protected void writeLabel(DBTableModel dBTableModel, PrintWriter printWriter) {
        if (this.useNumber) {
            printWriter.print("#Label");
            printWriter.print(this.separator);
        } else {
            printWriter.print("#");
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n;
            if (i != 0) {
                printWriter.print(this.separator);
            }
            if ((n = this.clmNo[i]) < 0) continue;
            String string = StringUtil.tagCut((String)this.dbColumn[n].getLabel());
            printWriter.print(string);
            if (!this.isKeyLbl[i]) continue;
            printWriter.print(this.separator);
        }
        printWriter.println();
    }

    protected void writeName(DBTableModel dBTableModel, PrintWriter printWriter) {
        if (this.useNumber) {
            printWriter.print("#Name");
            printWriter.print(this.separator);
        } else {
            printWriter.print("#");
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n;
            if (i != 0) {
                printWriter.print(this.separator);
            }
            if ((n = this.clmNo[i]) < 0) continue;
            printWriter.print(dBTableModel.getColumnName(n));
            if (!this.isKeyLbl[i]) continue;
            printWriter.print(this.separator);
        }
        printWriter.println();
    }

    protected void writeSize(DBTableModel dBTableModel, PrintWriter printWriter) {
        if (this.useNumber) {
            printWriter.print("#Size");
            printWriter.print(this.separator);
        } else {
            printWriter.print("#");
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n;
            if (i != 0) {
                printWriter.print(this.separator);
            }
            if ((n = this.clmNo[i]) < 0) continue;
            printWriter.print(this.dbColumn[n].getTotalSize());
            if (!this.isKeyLbl[i]) continue;
            printWriter.print(this.separator);
        }
        printWriter.println();
    }

    protected void writeClass(DBTableModel dBTableModel, PrintWriter printWriter) {
        if (this.useNumber) {
            printWriter.print("#Class");
            printWriter.print(this.separator);
        } else {
            printWriter.print("#");
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n;
            if (i != 0) {
                printWriter.print(this.separator);
            }
            if ((n = this.clmNo[i]) < 0) continue;
            printWriter.print(this.dbColumn[n].getClassName());
            if (!this.isKeyLbl[i]) continue;
            printWriter.print(this.separator);
        }
        printWriter.println();
    }

    protected void writeSeparator(DBTableModel dBTableModel, PrintWriter printWriter) {
        if (this.useNumber) {
            printWriter.print("#----");
            printWriter.print(this.separator);
        } else {
            printWriter.print("#");
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (i != 0) {
                printWriter.print(this.separator);
            }
            printWriter.print("----");
            if (!this.isKeyLbl[i]) continue;
            printWriter.print(this.separator);
        }
        printWriter.println();
    }

    protected abstract void writeData(DBTableModel var1, PrintWriter var2);

    @Override
    public void setDBTableModel(DBTableModel dBTableModel, String string) {
        this.table = dBTableModel;
        this.lang = string;
    }

    @Override
    public DBTableModel getDBTableModel() {
        return this.table;
    }

    @Override
    public void setHeaderSequence(String string) {
        if (string != null) {
            this.headerSequence = string;
        }
    }

    @Override
    public String getHeaderSequence() {
        return this.headerSequence;
    }

    @Override
    public void setSeparator(String string) {
        if (string != null) {
            this.separator = string;
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    @Override
    public void setAppend(boolean bl) {
        this.append = bl;
    }

    @Override
    public boolean isAppend() {
        return this.append;
    }

    @Override
    public void setSheetName(String string) {
        String string2 = "sheetName \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]";
        System.err.println(string2);
    }

    @Override
    public void setRefSheetName(String string) {
        String string2 = "refSheetName \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]";
        System.err.println(string2);
    }

    @Override
    public boolean isExcel() {
        return false;
    }

    @Override
    public void setFilename(String string, String string2) {
        throw new UnsupportedOperationException("filename \u306f\u3001\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
    }

    @Override
    public void setRefFilename(String string) {
        String string2 = "refFilename \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]";
        System.err.println(string2);
    }

    @Override
    public void setSheetOverwrite(boolean bl) {
        System.err.println("sheetOverwrite \u306f\u3001\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
    }

    @Override
    public void setRecalcSheetName(String string) {
        System.err.println("recalcSheetName \u306f\u3001\u30e1\u30bd\u30c3\u30c9\u306f\u3001EXCEL\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
    }

    @Override
    public void setFontName(String string) {
        String string2 = "fontName \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]";
        System.err.println(string2);
    }

    @Override
    public void setFontPoint(short s) {
        String string = "fontPoint \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + s + "]";
        System.err.println(string);
    }

    @Override
    public void setEncode(String string) {
        this.encode = string;
    }

    protected String getEncode() {
        return this.encode;
    }

    @Override
    public void setUseNumber(boolean bl) {
        this.useNumber = bl;
    }

    protected boolean isUseNumber() {
        return this.useNumber;
    }

    @Override
    public void setParam(List<HybsEntry> list) {
        throw new UnsupportedOperationException("param \u306f\u3001XML\u8ffd\u52a0\u6a5f\u80fd\u3067\u3059\u306e\u3067\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
    }

    @Override
    public void setColumns(String string) {
        this.columns = string;
    }

    @Override
    public void setOmitNames(String string) {
        this.omitNames = string;
    }

    @Override
    public void setSkipRowCount(int n) {
        if (n != 0) {
            String string = "skipRowCount \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + n + "]";
            System.err.println(string);
        }
    }

    @Override
    public void setUseCellStyle(boolean bl) {
        String string = "useCellStyle \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + bl + "]";
        System.err.println(string);
    }

    @Override
    public void setUseAutoCellSize(boolean bl) {
        String string = "useAutoCellSize \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + bl + "]";
        System.err.println(string);
    }

    @Override
    public void setUseActiveWorkbook(boolean bl) {
        String string = "useActiveWorkbook \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + bl + "]";
        System.err.println(string);
    }

    @Override
    public void setPageBreakColumn(String string) {
        String string2 = "pageBreakColumn \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]";
        System.err.println(string2);
    }

    @Override
    public void setFileBreakColumn(String string) {
        String string2 = "fileBreakColumn \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]";
        System.err.println(string2);
    }

    @Override
    public void setHyperLinkColumn(String string) {
        String string2 = "hyperLinkColumn \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]";
        System.err.println(string2);
    }

    @Override
    public void setAddTitleSheet(String string) {
        String string2 = "addTitleSheet \u306f\u3001EXCEL\u5c02\u7528\u6a5f\u80fd\u306a\u306e\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]";
        System.err.println(string2);
    }

    @Override
    public void setUseRenderer(boolean bl) {
        this.useRenderer = bl;
    }

    protected boolean isUseRenderer() {
        return this.useRenderer;
    }

    protected String quotation(String string) {
        return "\"" + StringUtil.replace((String)string, (String)"\"", (String)"\"\"") + "\"";
    }

    protected String quotation2(String string) {
        Object object = StringUtil.replace((String)string, (String)"\"", (String)"\"\"");
        if (object != null && ((String)object).indexOf(CR) >= 0) {
            object = "\"" + (String)object + "\"";
        }
        return object;
    }

    protected void checkParam(String string, Map<String, String> map) {
        if (string == null || map == null) {
            return;
        }
        String string4 = string.toUpperCase(Locale.JAPAN);
        if (!map.containsKey(string4)) {
            String string5 = "<br>" + CR;
            StringBuilder stringBuilder = new StringBuilder(200).append(string5).append("\u6307\u5b9a\u306e\u30ad\u30fc\u306f\u3001\u3053\u306e tableWriter \u3067\u306f\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002").append(string5).append("  class=[").append(this.getClass().getName()).append(']').append(string5).append("  key  =[").append(string).append(']').append(string5).append("  ======== usage keys ======== ").append(string5);
            map.forEach((string2, string3) -> stringBuilder.append(' ').append((String)string2).append(':').append((String)string3).append(string5));
            stringBuilder.append("  ============================ ").append(string5);
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    @Override
    public void setDebug(boolean bl) {
        this.useDebug = bl;
    }

    protected boolean isDebug() {
        return this.useDebug;
    }
}

