/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.CharacterCodingException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.ChainProcess;
import org.opengion.fukurou.process.FileLineModel;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgCharacterException;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.CommentLineParser;
import org.opengion.fukurou.util.FileInfo;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;

public class Process_Grep
extends AbstractProcess
implements ChainProcess {
    private static final String[] INSERT_LIST = new String[]{"HEAD", "CHANGE", "BEFORE", "AFTER", "TAIL"};
    private Pattern pattern;
    private String keyword;
    private boolean ignoreCase;
    private boolean notEquals;
    private String inEncode;
    private String outEncode;
    private String change;
    private String insert = "CHANGE";
    private int insOffset;
    private boolean useBackup;
    private boolean useBulkRead;
    private boolean delete;
    private boolean useAllFind;
    private boolean useOmitCmnt;
    private boolean errAbend = true;
    private boolean display;
    private boolean debug;
    private int inCount;
    private int findCount;
    private int cngCount;
    private int skipRowCount;
    private static final Map<String, String> MUST_PROPARTY = new LinkedHashMap<String, String>();
    private static final Map<String, String> USABLE_PROPARTY;

    public Process_Grep() {
        super("org.opengion.fukurou.process.Process_Grep", MUST_PROPARTY, USABLE_PROPARTY);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        Argument argument = this.getArgument();
        this.keyword = argument.getProparty("keyword");
        this.ignoreCase = argument.getProparty("ignoreCase", this.ignoreCase);
        this.notEquals = argument.getProparty("notEquals", this.notEquals);
        this.inEncode = argument.getProparty("inEncode", System.getProperty("file.encoding"));
        this.outEncode = argument.getProparty("outEncode", System.getProperty("file.encoding"));
        this.useBackup = argument.getProparty("useBackup", this.useBackup);
        this.useBulkRead = argument.getProparty("useBulkRead", this.useBulkRead);
        this.delete = argument.getProparty("delete", this.delete);
        this.insert = argument.getProparty("insert", this.insert);
        this.change = argument.getFileProparty("change", "changeFile", this.outEncode, false);
        this.skipRowCount = argument.getProparty("skipRowCount", 0);
        this.useAllFind = argument.getProparty("useAllFind", this.useAllFind);
        this.useOmitCmnt = argument.getProparty("useOmitCmnt", this.useOmitCmnt);
        this.errAbend = argument.getProparty("errAbend", this.errAbend);
        this.display = argument.getProparty("display", this.display);
        this.debug = argument.getProparty("debug", this.debug);
        if (this.change != null) {
            int n = this.insert.indexOf(32);
            if (n > 0) {
                this.insOffset = Integer.parseInt(this.insert.substring(n + 1));
                this.insert = this.insert.substring(0, n);
            }
            boolean bl = false;
            for (int i = 0; i < INSERT_LIST.length; ++i) {
                if (!this.insert.equalsIgnoreCase(INSERT_LIST[i])) continue;
                bl = true;
                break;
            }
            if (!bl) {
                String string = "insert \u306f\u3001" + Arrays.toString(INSERT_LIST) + " \u304b\u3089\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + CR + "-insert=[" + this.insert + "]";
                throw new OgRuntimeException(string);
            }
            this.change = StringUtil.replace(this.change, "\\n", CR);
            this.change = StringUtil.replace(this.change, "\\t", "\t");
        }
        if (this.delete) {
            this.change = "";
        }
        this.pattern = this.ignoreCase ? Pattern.compile(this.keyword, 2) : Pattern.compile(this.keyword);
    }

    @Override
    public void end(boolean bl) {
    }

    @Override
    public LineModel action(LineModel lineModel) {
        ++this.inCount;
        if (!(lineModel instanceof FileLineModel)) {
            String string = "\u30c7\u30fc\u30bf\u304c FileLineModel \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" + CR;
            throw new OgRuntimeException(string);
        }
        FileLineModel fileLineModel = (FileLineModel)lineModel;
        File file = fileLineModel.getFile();
        if (!file.isFile()) {
            if (this.display) {
                this.println(lineModel.dataLine());
            }
            return lineModel;
        }
        boolean bl = false;
        try {
            String string = null;
            int n = -1;
            if (this.useBulkRead) {
                string = this.findKeywordAsBulk(file);
            } else {
                n = this.findKeyword(file);
            }
            boolean bl2 = bl = string != null || n >= 0;
            if (this.change != null && bl) {
                File file2 = new File(file.getPath() + "_backup");
                if (file2.exists() && !file2.delete()) {
                    String string2 = "\u904e\u53bb\u306eBKUP\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + file2 + "]" + CR + "data=[" + lineModel.dataLine() + "]" + CR;
                    throw new OgRuntimeException(string2);
                }
                File file3 = new File(file.getPath());
                if (!file3.renameTo(file2)) {
                    String string3 = "\u6240\u5b9a\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u30ea\u30cd\u30fc\u30e0\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + file3 + "]" + CR + "data=[" + lineModel.dataLine() + "]" + CR;
                    throw new OgRuntimeException(string3);
                }
                if (this.useBulkRead) {
                    this.changeKeywordAsBulk(string, file);
                } else {
                    this.changeKeyword(file2, file, n);
                }
                if (!this.useBackup && !file2.delete()) {
                    String string4 = "\u6240\u5b9a\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + file2 + "]" + CR + "data=[" + lineModel.dataLine() + "]" + CR;
                    throw new OgRuntimeException(string4);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            String string = "\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002[" + lineModel.getRowNo() + "]\u4ef6\u76ee" + CR + "data=[" + lineModel.dataLine() + "]" + CR;
            this.throwException(string, runtimeException, this.errAbend);
        }
        if (this.notEquals ^ bl && this.display) {
            this.println(lineModel.dataLine());
        }
        return this.notEquals ^ bl ? lineModel : null;
    }

    private int findKeyword(File file) {
        int n = -1;
        BufferedReader bufferedReader = FileUtil.getBufferedReader(file, this.inEncode);
        CommentLineParser commentLineParser = this.useOmitCmnt ? new CommentLineParser(FileInfo.getSUFIX(file)) : null;
        try {
            String string;
            int n2 = 0;
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                Matcher matcher;
                ++n2;
                if (this.useOmitCmnt && (string = commentLineParser.line(string)) == null || !(matcher = this.pattern.matcher(string)).find()) continue;
                if (this.debug) {
                    string2 = "DEBUG:\t" + file.getPath() + "(" + n2 + "): " + string;
                    this.println(string2);
                }
                if (this.useAllFind) {
                    string2 = file.getAbsolutePath() + "(" + n2 + "):" + string;
                    this.println(string2);
                    continue;
                }
                n = n2;
                break;
            }
        }
        catch (CharacterCodingException characterCodingException) {
            String string = "\u6587\u5b57\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u30fb\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + "  \u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u6307\u5b9a\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u3068\u7570\u306a\u308a\u307e\u3059\u3002" + CR + " [" + file.getPath() + "] , Encode=[" + this.inEncode + "]";
            throw new OgCharacterException(string, characterCodingException);
        }
        catch (IOException iOException) {
            String string = "\u30ad\u30fc\u30ef\u30fc\u30c9\u30d5\u30a1\u30a4\u30eb\u8aad\u53d6\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + " [" + file.getPath() + "] , Encode=[" + this.inEncode + "]";
            throw new OgRuntimeException(string, iOException);
        }
        finally {
            Closer.ioClose(bufferedReader);
        }
        return n;
    }

    private String findKeywordAsBulk(File file) {
        boolean bl = false;
        String string = FileUtil.getValue(file.getPath(), this.inEncode);
        Matcher matcher = this.pattern.matcher(string);
        if (matcher.find()) {
            if (this.debug) {
                this.println("DEBUG:\t" + file.getPath());
            }
            bl = true;
        }
        return bl ? string : null;
    }

    private void changeKeyword(File file, File file2, int n) {
        BufferedReader bufferedReader = FileUtil.getBufferedReader(file, this.inEncode);
        PrintWriter printWriter = FileUtil.getPrintWriter(file2, this.outEncode);
        String string = null;
        try {
            if ("HEAD".equals(this.insert)) {
                printWriter.println(this.change);
            }
            int n2 = 0;
            while ((string = bufferedReader.readLine()) != null) {
                if (++n2 <= this.skipRowCount) continue;
                if (n2 >= n) {
                    Matcher matcher = this.pattern.matcher(string);
                    String string2 = null;
                    if ("CHANGE".equals(this.insert)) {
                        string2 = this.strChange(matcher);
                    } else if ("BEFORE".equals(this.insert)) {
                        string2 = this.strBefore(string, matcher);
                    } else if ("AFTER".equals(this.insert)) {
                        string2 = this.strAfter(string, matcher);
                    }
                    if (string2 != null) {
                        string = string2;
                        ++this.cngCount;
                    }
                }
                printWriter.println(string);
            }
            if ("TAIL".equals(this.insert)) {
                printWriter.println(this.change);
            }
        }
        catch (CharacterCodingException characterCodingException) {
            String string3 = "\u6587\u5b57\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u30fb\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + "  \u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u6307\u5b9a\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u3068\u7570\u306a\u308a\u307e\u3059\u3002" + CR + " [" + file + "] , Encode=[" + this.inEncode + "]";
            throw new OgCharacterException(string3, characterCodingException);
        }
        catch (IOException iOException) {
            String string4 = "\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002[" + string + "]" + CR + " [" + file + "] , Encode=[" + this.inEncode + "]";
            throw new OgRuntimeException(string4, iOException);
        }
        finally {
            Closer.ioClose(bufferedReader);
            Closer.ioClose(printWriter);
        }
    }

    private void changeKeywordAsBulk(String string, File file) {
        PrintWriter printWriter = FileUtil.getPrintWriter(file, this.outEncode);
        String string2 = string;
        try {
            if ("HEAD".equals(this.insert)) {
                printWriter.println(this.change);
            }
            Matcher matcher = this.pattern.matcher(string2);
            String string3 = null;
            if ("CHANGE".equals(this.insert)) {
                string3 = this.strChange(matcher);
            } else if ("BEFORE".equals(this.insert)) {
                string3 = this.strBefore(string2, matcher);
            } else if ("AFTER".equals(this.insert)) {
                string3 = this.strAfter(string2, matcher);
            }
            if (string3 != null) {
                string2 = string3;
                ++this.cngCount;
            }
            printWriter.print(string2);
            if ("TAIL".equals(this.insert)) {
                printWriter.println(this.change);
            }
        }
        catch (RuntimeException runtimeException) {
            String string4 = "\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002[" + file.getPath() + "]";
            throw new OgRuntimeException(string4, runtimeException);
        }
        finally {
            Closer.ioClose(printWriter);
        }
    }

    private String strChange(Matcher matcher) {
        String string = null;
        if (matcher.find()) {
            string = matcher.replaceAll(this.change);
        }
        return string;
    }

    private String strBefore(String string, Matcher matcher) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        while (matcher.find()) {
            bl = true;
            int n2 = matcher.start() + this.insOffset;
            stringBuilder.append(string.substring(n, n2));
            stringBuilder.append(this.change);
            n = n2;
        }
        String string2 = null;
        if (bl) {
            stringBuilder.append(string.substring(n));
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    private String strAfter(String string, Matcher matcher) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        while (matcher.find()) {
            bl = true;
            int n2 = matcher.end() + this.insOffset;
            stringBuilder.append(string.substring(n, n2));
            stringBuilder.append(this.change);
            n = n2;
        }
        String string2 = null;
        if (bl) {
            stringBuilder.append(string.substring(n));
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    @Override
    public String report() {
        if (this.findCount < this.cngCount) {
            this.findCount = this.cngCount;
        }
        String string = "[" + this.getClass().getName() + "]" + CR + "\tSearch Keyword    : " + this.keyword + CR + "\tSearch File Count : " + this.inCount + CR + "\tKey Find    Count : " + this.findCount + CR + "\tKey Change  Count : " + this.cngCount;
        return string;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder(1400).append("Process_Grep \u306f\u3001\u4e0a\u6d41\u304b\u3089\u53d7\u3051\u53d6\u3063\u305f FileLineModel\u304b\u3089\u3001\u6587\u5b57\u5217\u3092\u898b\u3064\u3051\u51fa\u3059").append(CR).append("ChainProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR).append(CR).append("\u6b63\u898f\u8868\u73fe\u306e keyword \u3092\u4e0a\u6d41\u304b\u3089\u53d7\u3051\u53d6\u3063\u305f FileLineModel \u304b\u3089\u691c\u7d22\u3057\u307e\u3059\u3002").append(CR).append("\u898b\u3064\u304b\u3063\u305f\u5bfe\u8c61\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u3001\u6307\u5b9a\u306e\u6587\u5b57\u5217\u3092\u7f6e\u63db\u3059\u308b\u5834\u5408\u306f\u3001-change \u304b").append(CR).append("-changeFile \u3067\u3001keyword \u3092\u7f6e\u63db\u3059\u308b\u6587\u5b57\u5217\u3092\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002").append(CR).append("\u7f6e\u63db\u3059\u308b\u6587\u5b57\u5217\u306b\u306f\u3001\t \u3068 \n \u306e\u7279\u6b8a\u6587\u5b57\u304c\u4f7f\u7528\u3067\u304d\u307e\u3059\u3002").append(CR).append(CR).append("\u51e6\u7406\u5bfe\u8c61\u306f\u3001\u901a\u5e38\u306f\u3001\uff11\u884c\u3065\u3064\u8aad\u307f\u53d6\u308a\u306a\u304c\u3089\u51e6\u7406\u3092\u884c\u3044\u307e\u3059\u3002\u5b58\u5728\u30c1\u30a7\u30c3\u30af\u306e\u5834\u5408\u306f\u3001").append(CR).append("\u898b\u3064\u304b\u3063\u305f\u6642\u70b9\u3067\u51e6\u7406\u3092\u4e2d\u6b62\u3057\u307e\u3059\u3002\u3053\u308c\u306f\u3001\u8a72\u5f53\u7b87\u6240\u3092\u30d4\u30c3\u30af\u30a2\u30c3\u30d7\u3059\u308b\u306e\u3067\u306f\u306a\u304f\u3001").append(CR).append("\u5b58\u5728\u3057\u3066\u3044\u308b\u304b\u3069\u3046\u304b\u3092\u5224\u65ad\u3057\u3066\u3001\u3042\u308c\u3070\u3001\u4e0b\u6d41\u306b\u6d41\u3059\u3068\u3044\u3046\u306e\u304c\u76ee\u7684\u3060\u304b\u3089\u3067\u3059\u3002").append(CR).append("keyword \u3092\u3001\u6539\u884c\u3092\u542b\u3080\u6b63\u898f\u8868\u73fe\u3067\u3001\u691c\u7d22\u30fb\u7f6e\u63db\u3059\u308b\u5834\u5408\u306f\u3001-useBulkRead \u5c5e\u6027\u3092").append(CR).append("true \u306b\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u3053\u308c\u306f\u3001\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u3092\u4e00\u62ec\u3057\u3066\u8aad\u307f\u8fbc\u307f\u307e\u3059\u3002").append(CR).append("-ignoreCase \u306f\u3001\u691c\u7d22\u6642\u306b\u30ad\u30fc\u306e\u5927\u6587\u5b57\u5c0f\u6587\u5b57\u3092\u7121\u8996\u3059\u308b\u3088\u3046\u306b\u6307\u5b9a\u3057\u307e\u3059\u3002").append(CR).append("-notEquals \u306f\u3001\u7d50\u679c(\u898b\u3064\u304b\u308c\u3070true)\u3092\u53cd\u8ee2(\u898b\u3064\u304b\u3089\u306a\u3051\u308c\u3070true)\u3057\u307e\u3059\u3002").append(CR).append("\u3053\u308c\u306f\u3001\u884c\u5358\u4f4d\u3067\u306f\u306a\u304f\u3001\u30d5\u30a1\u30a4\u30eb\u5358\u4f4d\u306b\u5224\u5b9a\u3057\u307e\u3059\u306e\u3067\u3001change \u6307\u5b9a\u3057\u305f\u5834\u5408").append(CR).append("\u3067\u3082\u3001\u5bfe\u8c61\u884c\u306f\u3001\u898b\u3064\u304b\u3063\u305f\u884c\u3067\u3059\u3002\u305f\u3060\u3057\u3001\u4e0b\u6d41\u306b\u5bfe\u3057\u3066\u3001\u898b\u3064\u304b\u3089\u306a\u3044").append(CR).append("\u5834\u5408\u3060\u3051\u51e6\u7406\u3092\u7d99\u7d9a\u3055\u305b\u307e\u3059\u3002").append(CR).append("-inEncode \u306f\u3001\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u6307\u5b9a\u306b\u306a\u308a\u307e\u3059\u3002").append(CR).append("-outEncode \u306f\u3001\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u3084\u3001changeFile\u3067\u6307\u5b9a\u306e\u7f6e\u63db\u6587\u5b57\u5217").append(CR).append("\u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u6307\u5b9a\u306b\u306a\u308a\u307e\u3059\u3002(changeFile \u306f\u3001\u5fc5\u305a \u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u3068)").append(CR).append("\u540c\u3058\u30a8\u30f3\u30b3\u30fc\u30c9\u3067\u3059\u3002").append(CR).append("\u3053\u308c\u3089\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u7121\u6307\u5b9a\u306e\u5834\u5408\u306f\u3001System.getProperty(\"file.encoding\") ").append(CR).append("\u3067\u6c42\u307e\u308b\u5024\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002").append(CR).append("-changeFile \u3092\u4f7f\u7528\u3059\u308b\u3053\u3068\u3067\u3001\u8907\u6570\u884c\u306e\u6587\u5b57\u5217\u306b\u7f6e\u63db\u3059\u308b\u3053\u3068\u304c\u53ef\u80fd\u3067\u3059\u3002").append(CR).append(CR).append("\u4e0a\u6d41(\u30d7\u30ed\u30bb\u30b9\u30c1\u30a7\u30a4\u30f3\u306e\u30c7\u30fc\u30bf\u306f\u4e0a\u6d41\u304b\u3089\u6e21\u3055\u308c\u307e\u3059\u3002)\u304b\u3089\u306eLineModel \u306e").append(CR).append("\u30d5\u30a1\u30a4\u30eb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3088\u308a\u3001\u6307\u5b9a\u306e\u6587\u5b57\u5217\u304c\u542b\u307e\u308c\u3066\u3044\u308b\u304b\u691c\u7d22\u3057\u307e\u3059\u3002").append(CR).append("\u4e0a\u6d41\u30d7\u30ed\u30bb\u30b9\u3067\u306f\u3001Name \u5c5e\u6027\u3068\u3057\u3066\u3001\u300eFile\u300f\u3092\u6301\u3061\u3001\u5024\u306f\u3001File\u30aa\u30d6\u30b8\u30a7\u30af\u30c8").append(CR).append("\u3067\u3042\u308b\u3001Process_FileSearch \u3092\u4f7f\u7528\u3059\u308b\u306e\u304c\u3001\u4fbf\u5229\u3067\u3059\u3002\u305d\u308c\u4ee5\u5916\u306e\u30af\u30e9\u30b9\u3092").append(CR).append("\u4f7f\u7528\u3059\u308b\u5834\u5408\u3067\u3082\u3001Name\u5c5e\u6027\u3068\u3001File \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6301\u3064 LineModel \u3092\u53d7\u3051\u6e21\u3057").append(CR).append("\u3067\u304d\u308c\u3070\u3001\u4f7f\u7528\u53ef\u80fd\u3067\u3059\u3002").append(CR).append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u7a7a\u767d\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u7a7a\u767d\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR).append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR).append(CR).append(CR).append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_Grep().usage());
    }

    static {
        MUST_PROPARTY.put("keyword", "\u691c\u7d22\u3059\u308b\u8a9e\u53e5(\u5fc5\u9808)");
        USABLE_PROPARTY = new LinkedHashMap<String, String>();
        USABLE_PROPARTY.put("ignoreCase", "\u691c\u7d22\u6642\u306b\u5927\u6587\u5b57\u5c0f\u6587\u5b57\u3092\u533a\u5225\u3057\u306a\u3044(true)\u304b\u3069\u3046\u304b\u3002" + CR + "(\u521d\u671f\u5024:\u533a\u5225\u3059\u308b[false])");
        USABLE_PROPARTY.put("notEquals", "\u691c\u7d22\u6642\u306b\u5224\u5b9a\u7d50\u679c\u3092\u53cd\u8ee2\u3055\u305b\u308b(true)\u304b\u3069\u3046\u304b\u3002" + CR + "(\u521d\u671f\u5024:\u53cd\u8ee2\u3055\u305b\u306a\u3044[false])");
        USABLE_PROPARTY.put("inEncode", "\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u30bf\u30a4\u30d7");
        USABLE_PROPARTY.put("outEncode", "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u3084\u7f6e\u63db\u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u30bf\u30a4\u30d7");
        USABLE_PROPARTY.put("change", "\u7f6e\u63db\u6587\u5b57\u5217 \u4f8b: -change=\"ABCD\" \\t \u3084 \\n \u306a\u3069\u306e\u7279\u6b8a\u6587\u5b57\u304c\u4f7f\u7528\u3067\u304d\u307e\u3059\u3002");
        USABLE_PROPARTY.put("changeFile", "\u7f6e\u63db\u6587\u5b57\u5217\u30d5\u30a1\u30a4\u30eb \u4f8b: -changeFile=change.txt" + CR + "-change \u3068\u3001-changeFile \u306f\u3001\u540c\u6642\u306b\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002" + CR + "\u7f6e\u63db\u6a5f\u80fd\u4f7f\u7528\u6642\u306f\u3001\u5fc5\u305a\u3001_backup \u3068\u3044\u3046\u30d5\u30a1\u30a4\u30eb\u304c\u4f5c\u6210\u3055\u308c\u307e\u3059\u3002");
        USABLE_PROPARTY.put("insert", "[HEAD/CHANGE/BEFORE/AFTER/TAIL]:\u7f6e\u63db\u3067\u306a\u304f\u633f\u5165\u3059\u308b\u5834\u5408\u306e\u4f4d\u7f6e\u3092\u6307\u5b9a\u3057\u307e\u3059(\u521d\u671f\u5024:CHANGE)" + CR + "\u30b9\u30da\u30fc\u30b9\u3067\u533a\u5207\u3063\u3066\u6570\u5b57\u3092\u8a18\u8ff0\u3059\u308b\u3068\u3001\u633f\u5165\u4f4d\u7f6e\u306b\u30aa\u30d5\u30bb\u30c3\u30c8\u3067\u304d\u307e\u3059\u3002");
        USABLE_PROPARTY.put("delete", "[false/true]:true\u306f\u3001\u7f6e\u63db\u3067\u306a\u304f\u524a\u9664\u3057\u307e\u3059(\u521d\u671f\u5024:false)");
        USABLE_PROPARTY.put("skipRowCount", "\u5148\u982d\u884c\u304b\u3089\u3001\u30b9\u30ad\u30c3\u30d7\u3059\u308b\u884c\u6570\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        USABLE_PROPARTY.put("useBackup", "[false/true]:true\u306f\u3001backup\u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210\u3057\u307e\u3059(\u521d\u671f\u5024:false)");
        USABLE_PROPARTY.put("useBulkRead", "[false/true]:true\u306f\u3001\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u3092\u4e00\u62ec\u8aad\u8fbc\u3057\u307e\u3059(\u521d\u671f\u5024:false)");
        USABLE_PROPARTY.put("useAllFind", "\u7f6e\u63db\u3067\u306f\u306a\u304f\u691c\u7d22\u3060\u3051\u6700\u5f8c\u307e\u3067\u884c\u3046\u5834\u5408\u3001true\u3092\u6307\u5b9a\u3057\u307e\u3059(\u521d\u671f\u5024:false)");
        USABLE_PROPARTY.put("useOmitCmnt", "\u30b3\u30e1\u30f3\u30c8\u90e8\u5206\u3092\u524a\u9664\u3057\u305f\u30d5\u30a1\u30a4\u30eb\u3067grep\u51e6\u7406\u3092\u884c\u3046\u304b\u3069\u3046\u304b\u3092\u6307\u5b9a(\u521d\u671f\u5024:false)");
        USABLE_PROPARTY.put("errAbend", "\u7570\u5e38\u767a\u751f\u6642\u306b\u3001\u51e6\u7406\u3092\u4e2d\u65ad(true)\u3059\u308b\u304b\u3001\u7d99\u7d9a(false)\u3059\u308b\u304b" + CR + "(\u521d\u671f\u5024:true:\u4e2d\u65ad\u3059\u308b)");
        USABLE_PROPARTY.put("display", "[false/true]:true\u306f\u3001\u691c\u7d22\u72b6\u6cc1\u3092\u8868\u793a\u3057\u307e\u3059(\u521d\u671f\u5024:false)");
        USABLE_PROPARTY.put("debug", "\u30c7\u30d0\u30c3\u30b0\u60c5\u5831\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
    }
}

