/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opengion.fukurou.fileexec.MsgUtil;

public class XLogger {
    private static final Level L_DEBUG = new LEVEL_DEBUG();
    private final Logger LOGGER;

    private XLogger(String string) {
        this.LOGGER = Logger.getLogger(string);
    }

    public static XLogger getLogger(String string) {
        return new XLogger(string);
    }

    public void info(Supplier<String> supplier) {
        this.LOGGER.info(supplier);
    }

    public void warning(Supplier<String> supplier) {
        this.LOGGER.warning(supplier);
    }

    public void warning(String string, Object ... objectArray) {
        this.LOGGER.warning(MsgUtil.errPrintln(string, objectArray));
    }

    public void warning(Throwable throwable, Supplier<String> supplier) {
        this.LOGGER.log(Level.WARNING, throwable, supplier);
    }

    public void warning(Throwable throwable, String string, Object ... objectArray) {
        this.LOGGER.log(Level.WARNING, MsgUtil.errPrintln(string, objectArray), throwable);
    }

    public void debug(Supplier<String> supplier) {
        this.LOGGER.log(L_DEBUG, supplier);
    }

    public void debug(int n, Function<Integer, String> function) {
        this.LOGGER.log(L_DEBUG, () -> (String)function.apply(n));
    }

    private static final class LEVEL_DEBUG
    extends Level {
        private static final long serialVersionUID = 681020170714L;

        public LEVEL_DEBUG() {
            super("DEBUG", 600);
        }
    }
}

