/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import javax.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.business.ArrayTableModel;
import org.opengion.fukurou.business.BizLogicHelper;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.HybsLoader;
import org.opengion.fukurou.util.HybsLoaderConfig;
import org.opengion.fukurou.util.HybsLoaderFactory;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;
import org.opengion.hayabusa.taglib.TransactionTag;

public class BizLogicTag
extends CommonTagSupport {
    private static final String VERSION = "567020130727";
    private static final long serialVersionUID = 567020130727L;
    public static final String CMD_ENTRY = "ENTRY";
    private static final String ERR_MSG_ID = "h_errMsg";
    private String command = "ENTRY";
    private String[] logics = null;
    private String dbid = null;
    private transient DBTableModel table = null;
    private String tableId = "h_tblmdl";
    private boolean selectedAll = false;
    private String modifyType = null;
    private String[] keys = null;
    private String[] vals = null;
    private boolean stopError = true;
    private boolean quotCheck = HybsSystem.sysBool("USE_SQL_INJECTION_CHECK");
    private boolean xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
    private transient ErrorMessage errMessage = null;
    private int errCode = 0;
    private int executeCount = -1;
    private ArrayTableModel arrTable = null;
    private HybsLoader loader = null;
    private String srcDir = HybsSystem.sys("REAL_PATH") + HybsSystem.sys("BIZLOGIC_SRC_PATH");
    private String classDir = HybsSystem.sys("REAL_PATH") + HybsSystem.sys("BIZLOGIC_CLASS_PATH");
    private boolean isAutoCompile = HybsSystem.sysBool("BIZLOGIC_AUTO_COMPILE");
    private boolean isHotDeploy = HybsSystem.sysBool("BIZLOGIC_HOT_DEPLOY");
    private boolean isMulti = false;
    protected boolean dispError = true;
    private static final String CLASS_PATH;

    @Override
    public int doStartTag() {
        if (CMD_ENTRY.equals(this.command)) {
            this.startQueryTransaction(this.tableId);
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        this.useQuotCheck(this.quotCheck);
        this.useXssCheck(this.xssCheck);
        this.makeVals();
        this.execute();
        String string = TaglibUtil.makeHTMLErrorTable(this.errMessage, this.getResource());
        if (string != null && string.length() > 0) {
            this.setSessionAttribute(ERR_MSG_ID, this.errMessage);
        }
        if (this.table != null && !this.commitTableObject(this.tableId, this.table)) {
            this.jspPrint("BizLoicTag \u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
            return 5;
        }
        this.setRequestAttribute("DB.ERR_MSG", string);
        if (this.dispError) {
            this.jspPrint(string);
        }
        if (this.errCode >= 2 && this.stopError) {
            return 5;
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.command = CMD_ENTRY;
        this.logics = null;
        this.dbid = null;
        this.table = null;
        this.tableId = "h_tblmdl";
        this.selectedAll = false;
        this.modifyType = null;
        this.keys = null;
        this.vals = null;
        this.stopError = true;
        this.quotCheck = HybsSystem.sysBool("USE_SQL_INJECTION_CHECK");
        this.xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
        this.errMessage = null;
        this.errCode = 0;
        this.executeCount = -1;
        this.arrTable = null;
        this.loader = null;
        this.srcDir = HybsSystem.sys("REAL_PATH") + HybsSystem.sys("BIZLOGIC_SRC_PATH");
        this.classDir = HybsSystem.sys("REAL_PATH") + HybsSystem.sys("BIZLOGIC_CLASS_PATH");
        this.isAutoCompile = HybsSystem.sysBool("BIZLOGIC_AUTO_COMPILE");
        this.isHotDeploy = HybsSystem.sysBool("BIZLOGIC_HOT_DEPLOY");
        this.isMulti = false;
        this.dispError = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        int n;
        int n2;
        String[] stringArray;
        Object object;
        int[] nArray = new int[]{};
        if (CMD_ENTRY.equals(this.command)) {
            this.table = (DBTableModel)this.getObject(this.tableId);
        }
        if (this.table != null) {
            nArray = this.getParameterRows();
            object = new String[nArray.length][this.table.getColumnCount()];
            stringArray = new String[nArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                object[n2] = (String[])this.table.getValues(nArray[n2]);
                stringArray[n2] = this.table.getModifyType(nArray[n2]);
            }
            this.arrTable = new ArrayTableModel(this.table.getNames(), (String[][])object, stringArray);
        }
        object = null;
        try {
            Map map;
            stringArray = (String[])BizLogicTag.findAncestorWithClass((Tag)this, TransactionTag.class);
            object = stringArray == null ? new TransactionReal(this.getApplicationInfo()) : stringArray.getTransaction();
            this.errMessage = new ErrorMessage();
            this.loader = HybsLoaderFactory.getLoader((HybsLoaderConfig)new HybsLoaderConfig(this.srcDir, this.classDir, this.isAutoCompile, this.isHotDeploy, CLASS_PATH));
            n2 = 0;
            for (n = 0; n < this.logics.length && (n2 = (int)(this.call(this.logics[n], (Transaction)object) ? 1 : 0)) != 0; ++n) {
            }
            if (this.arrTable != null && (map = this.arrTable.getModifyVals()) != null) {
                for (Map.Entry entry : map.entrySet()) {
                    int n3 = (Integer)entry.getKey();
                    String[] stringArray2 = (String[])entry.getValue();
                    this.table.setValues(stringArray2, nArray[n3]);
                }
            }
            this.executeCount = nArray.length;
            this.errCode = this.errMessage.getKekka();
            this.setRequestAttribute("DB.COUNT", String.valueOf(this.executeCount));
            this.setRequestAttribute("DB.ERR_CODE", String.valueOf(this.errCode));
            if (this.errCode < 2) {
                object.commit();
                if (this.table != null && nArray.length > 0) {
                    for (n = nArray.length - 1; n >= 0; --n) {
                        int n4 = nArray[n];
                        if ("D".equals(this.table.getModifyType(n4))) {
                            this.table.removeValue(n4);
                            continue;
                        }
                        this.table.resetModify(n4);
                    }
                }
            } else {
                object.rollback();
            }
        }
        finally {
            if (object != null) {
                object.close();
            }
        }
        stringArray = this.errMessage.toArray();
        ErrorMessage errorMessage = new ErrorMessage();
        for (n = 0; n < stringArray.length; ++n) {
            if (this.table != null && nArray.length > 0) {
                errorMessage.addMessage(stringArray[n].copy(nArray[stringArray[n].getNo()] + 1));
                continue;
            }
            errorMessage.addMessage(stringArray[n].copy(stringArray[n].getNo() + 1));
        }
        this.errMessage = errorMessage;
    }

    private boolean call(String string, Transaction transaction) {
        BizLogicHelper bizLogicHelper = new BizLogicHelper(string, this.loader);
        if (bizLogicHelper.isRequireTable()) {
            if (this.arrTable == null) {
                String string2 = "TableModel\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002logic=[" + string + "]";
                throw new HybsSystemException(string2);
            }
            if (this.arrTable.getRowCount() == 0) {
                return true;
            }
            bizLogicHelper.setTable(this.arrTable);
        }
        bizLogicHelper.setTransaction(transaction);
        bizLogicHelper.setDbid(this.dbid);
        bizLogicHelper.setKeys(this.keys);
        bizLogicHelper.setVals(this.vals);
        bizLogicHelper.setUserId(this.getUser().getUserID());
        bizLogicHelper.setParentPgId(this.getGUIInfoAttri("KEY"));
        bizLogicHelper.setLoader(this.loader);
        if (this.isDebug()) {
            bizLogicHelper.setDebug();
        }
        boolean bl = false;
        try {
            bl = bizLogicHelper.exec();
        }
        catch (Throwable throwable) {
            transaction.rollback();
            String string3 = "\u696d\u52d9\u30ed\u30b8\u30c3\u30af\u306e\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + throwable.getMessage();
            throw new HybsSystemException(string3, throwable);
        }
        this.errMessage.append(bizLogicHelper.getErrMsg());
        this.setRequestAttribute(bizLogicHelper.getClass().getSimpleName() + ".RETURN", bizLogicHelper.getReturn());
        this.setRequestAttribute("RETURN", bizLogicHelper.getReturn());
        if (this.isDebug()) {
            this.jspPrint(bizLogicHelper.getDebugMsg());
        }
        return bl;
    }

    private void makeVals() {
        if (this.keys != null && this.keys.length > 0) {
            boolean bl;
            boolean bl2 = bl = this.vals != null && this.vals.length != 0;
            if (bl) {
                if (this.keys.length != this.vals.length) {
                    String string = "keys\u3068Vals\u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002" + HybsSystem.CR + "  keys=" + Arrays.toString(this.keys) + HybsSystem.CR + "  vals=" + Arrays.toString(this.vals);
                    throw new HybsSystemException(string);
                }
            } else {
                this.vals = new String[this.keys.length];
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (bl) {
                    if (this.isMulti) {
                        this.vals[i] = StringUtil.array2csv((String[])this.getRequestParameterValues(this.vals[i]));
                        continue;
                    }
                    this.vals[i] = this.getRequestParameter(this.vals[i]);
                    continue;
                }
                this.vals[i] = this.isMulti ? StringUtil.array2csv((String[])this.getRequestValues(this.keys[i])) : this.getRequestValue(this.keys[i]);
            }
        }
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() >= 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setLogics(String string) {
        this.logics = this.getCSVParameter(string);
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setSelectedAll(String string) {
        this.selectedAll = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.selectedAll);
    }

    public void setModifyType(String string) {
        this.modifyType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.modifyType);
    }

    public void setKeys(String string) {
        this.keys = this.getCSVParameter(this.getRequestParameter(string));
    }

    public void setVals(String string) {
        this.vals = StringUtil.csv2Array((String)string);
    }

    public void setStopError(String string) {
        this.stopError = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.stopError);
    }

    public void setQuotCheck(String string) {
        this.quotCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.quotCheck);
    }

    public void setXssCheck(String string) {
        this.xssCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.xssCheck);
    }

    public void setMulti(String string) {
        this.isMulti = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isMulti);
    }

    @Override
    protected int[] getParameterRows() {
        int[] nArray;
        if (this.selectedAll) {
            int n = this.table.getRowCount();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
        } else {
            nArray = super.getParameterRows();
        }
        return nArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("command", (Object)this.command).println("logics", (Object[])this.logics).println("dbid", (Object)this.dbid).println("tableId", (Object)this.tableId).println("selectedAll", (Object)this.selectedAll).println("modifyType", (Object)this.modifyType).println("keys", (Object[])this.keys).println("vals", (Object[])this.vals).println("stopError", (Object)this.stopError).println("quotCheck", (Object)this.quotCheck).println("xssCheck", (Object)this.xssCheck).println("executeCount", (Object)this.executeCount).println("errCode", (Object)this.errCode).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('.').append(File.pathSeparatorChar);
        File file = new File(HybsSystem.sys("REAL_PATH") + "WEB-INF" + File.separator + "lib");
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            stringBuilder.append(fileArray[i].getAbsolutePath()).append(File.pathSeparatorChar);
        }
        stringBuilder.append(HybsSystem.sys("REAL_PATH") + "WEB-INF" + File.separator + "classes").append(File.pathSeparatorChar);
        stringBuilder.append(HybsSystem.sys("REAL_PATH") + HybsSystem.sys("BIZLOGIC_CLASS_PATH")).append(File.pathSeparatorChar);
        CLASS_PATH = stringBuilder.toString();
    }
}

