/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.compute.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.compute.VNCConsole;

@JsonRootName(value="console")
public class NovaVNCConsole
implements VNCConsole {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private VNCConsole.Type type;
    @JsonProperty
    private String url;

    @Override
    public VNCConsole.Type getType() {
        return this.type;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("type", (Object)this.type).add("url", (Object)this.url).toString();
    }

    public static NovaConsole getConsoleForType(VNCConsole.Type type) {
        if (type == VNCConsole.Type.SPICE) {
            return new NovaConsoleSPICE(type);
        }
        return new NovaConsoleVNC(type);
    }

    @JsonRootName(value="os-getSPICEConsole")
    public static class NovaConsoleSPICE
    extends NovaConsole {
        private static final long serialVersionUID = 1L;

        public NovaConsoleSPICE(VNCConsole.Type type) {
            super(type);
        }
    }

    @JsonRootName(value="os-getVNCConsole")
    public static class NovaConsoleVNC
    extends NovaConsole {
        private static final long serialVersionUID = 1L;

        public NovaConsoleVNC(VNCConsole.Type type) {
            super(type);
        }
    }

    public static class NovaConsole
    implements ModelEntity {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="type")
        protected String type;

        public NovaConsole(VNCConsole.Type type) {
            this.type = type.value();
        }
    }
}

