/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import java.io.File;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.report.DBTableReport_HTML;
import org.opengion.hayabusa.resource.ResourceFactory;
import org.opengion.hayabusa.resource.ResourceManager;

public class ReportConverter {
    private static final String CR = HybsSystem.CR;
    private final StringBuilder errMsg = new StringBuilder();
    private String[] headerKeys = null;
    private String[] headerVals = null;
    private String[] footerKeys = null;
    private String[] footerVals = null;
    private boolean pageEndCut = false;
    private File templateFile = null;
    private File firstTemplateFile = null;
    private DBTableModel table = null;
    private ResourceManager resource = null;
    private final String SYSTEM_ID;
    private final String YKNO;
    private final String LISTID;
    private final String HTML_DIR;
    private final String LANG;
    private final boolean DEBUG;
    private String modelDIR = null;
    private String modelFILE = null;
    private String hSQL = null;
    private String fSQL = null;
    private String bSQL = null;
    private boolean fgLOCAL = false;
    private boolean fgDIRECT = false;
    private static final String GE54_SELECT = "SELECT MODELDIR,MODELFILE,FGCUT,HSQL,FSQL,BSQL,FGLOCAL,FGDIRECT,SYSTEM_ID FROM GE54 WHERE FGJ = '1' AND  SYSTEM_ID IN (?,'**') AND  LISTID = ?";
    private static final int GE54_MODELDIR = 0;
    private static final int GE54_MODELFILE = 1;
    private static final int GE54_FGCUT = 2;
    private static final int GE54_HSQL = 3;
    private static final int GE54_FSQL = 4;
    private static final int GE54_BSQL = 5;
    private static final int GE54_FGLOCAL = 6;
    private static final int GE54_FGDIRECT = 7;
    private static final int GE54_SYSTEM_ID = 8;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");

    public ReportConverter(String string, String string2, String string3, String string4, String string5, boolean bl) {
        this.SYSTEM_ID = string;
        this.YKNO = string2;
        this.LISTID = string3;
        this.HTML_DIR = string4;
        this.LANG = string5;
        this.DEBUG = bl;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYSTEM_ID, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("ReportConverter", this.YKNO, this.LISTID);
        } else {
            this.appInfo = null;
        }
    }

    public boolean execute() {
        System.out.print("ReportConverter Started ... ");
        boolean bl = true;
        try {
            if (bl) {
                System.out.print("MDL CK,");
                this.templateFile = FileUtil.checkFile((String)this.modelDIR, (String)(this.modelFILE + ".html"));
                boolean bl2 = bl = this.templateFile != null;
                if (!bl) {
                    this.errMsg.append("ModelFile Not Found Error !").append(CR);
                    this.errMsg.append("MODELDIR=").append(this.modelDIR).append(CR);
                    this.errMsg.append("MODELFILE=").append(this.modelFILE + ".html").append(CR);
                }
            }
            if (bl) {
                this.firstTemplateFile = FileUtil.checkFile((String)this.modelDIR, (String)(this.modelFILE + "_FIRST.html"), (int)1);
            }
            if (bl && (bl = this.isHeaderFooter())) {
                System.out.print("HF SQL,");
            }
            if (bl && (bl = this.reportRun())) {
                System.out.print("RPT RUN,");
            }
        }
        catch (RuntimeException runtimeException) {
            this.errMsg.append("ReportConverter Execute Exception Error!").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append(StringUtil.stringStackTrace((Throwable)runtimeException));
            this.errMsg.append(CR);
            bl = false;
        }
        System.out.println("End.");
        return bl;
    }

    public boolean initialDataSet() {
        String[] stringArray = new String[]{this.SYSTEM_ID, this.LISTID};
        String[][] stringArray2 = DBUtil.dbExecute((String)GE54_SELECT, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
        if (stringArray2 == null || stringArray2.length == 0) {
            this.errMsg.append("Data does not exist in GE54 table.").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , ");
            this.errMsg.append("LISTID=[").append(this.LISTID).append("]");
            this.errMsg.append(CR);
            return false;
        }
        int n = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!this.SYSTEM_ID.equalsIgnoreCase(stringArray2[i][8])) continue;
            n = i;
            break;
        }
        this.modelDIR = StringUtil.nval((String)stringArray2[n][0], (String)this.modelDIR);
        this.modelFILE = StringUtil.nval((String)stringArray2[n][1], (String)this.modelFILE);
        this.pageEndCut = StringUtil.nval((String)stringArray2[n][2], (boolean)this.pageEndCut);
        if (this.DEBUG) {
            System.out.println("MODELDIR   = [" + this.modelDIR + "]");
            System.out.println("MODELFILE  = [" + this.modelFILE + "]");
            System.out.println("pageEndCut = [" + this.pageEndCut + "]");
        }
        this.hSQL = StringUtil.nval((String)stringArray2[n][3], (String)this.hSQL);
        this.fSQL = StringUtil.nval((String)stringArray2[n][4], (String)this.fSQL);
        this.bSQL = StringUtil.nval((String)stringArray2[n][5], (String)this.bSQL);
        if (this.bSQL == null || this.bSQL.length() == 0) {
            this.errMsg.append("Body SQL Columns does not exist in GE54 table.").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , ");
            this.errMsg.append("LISTID=[").append(this.LISTID).append("] ");
            this.errMsg.append(CR);
            return false;
        }
        this.fgLOCAL = stringArray2[n][6] != null && stringArray2[n][6].trim().equals("1");
        this.fgDIRECT = stringArray2[n][7] != null && stringArray2[n][7].trim().equals("1");
        return true;
    }

    private boolean isHeaderFooter() {
        Object[] objectArray;
        String[] stringArray;
        this.resource = this.fgLOCAL ? ResourceFactory.newInstance(this.SYSTEM_ID, this.LANG, false) : ResourceFactory.newInstance(this.LANG);
        if (this.fgDIRECT) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = this.SYSTEM_ID;
            stringArray = stringArray2;
            stringArray2[1] = this.YKNO;
        }
        String[] stringArray3 = stringArray;
        DBTableModel dBTableModel = DBTableModelUtil.makeDBTable(this.hSQL, stringArray3, this.resource, this.appInfo);
        if (dBTableModel != null && dBTableModel.getRowCount() > 0) {
            this.headerKeys = dBTableModel.getNames();
            objectArray = dBTableModel.getValues(0);
            this.headerVals = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                this.headerVals[i] = objectArray[i].toString().trim();
            }
        }
        if ((objectArray = DBTableModelUtil.makeDBTable(this.fSQL, stringArray3, this.resource, this.appInfo)) != null && objectArray.getRowCount() > 0) {
            this.footerKeys = objectArray.getNames();
            Object[] objectArray2 = objectArray.getValues(0);
            this.footerVals = new String[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                this.footerVals[i] = objectArray2[i].toString().trim();
            }
        }
        this.table = DBTableModelUtil.makeDBTable(this.bSQL, stringArray3, this.resource, this.appInfo);
        if (this.table.getRowCount() <= 0) {
            this.errMsg.append("Database Body row count is Zero.").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append(this.bSQL);
            this.errMsg.append(CR);
            return false;
        }
        if (this.table.isOverflow()) {
            this.errMsg.append("Database is Overflow. [");
            this.errMsg.append(this.table.getRowCount());
            this.errMsg.append("]").append(CR).append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append("Check SystemParameter Data in DB_MAX_ROW_COUNT Overflow");
            this.errMsg.append(CR);
            return false;
        }
        return true;
    }

    private boolean reportRun() {
        DBTableReport_HTML dBTableReport_HTML = new DBTableReport_HTML();
        dBTableReport_HTML.setDBTableModel(this.table);
        dBTableReport_HTML.setTemplateFile(this.templateFile);
        dBTableReport_HTML.setFirstTemplateFile(this.firstTemplateFile);
        dBTableReport_HTML.setOutputDir(this.HTML_DIR);
        dBTableReport_HTML.setOutputFileKey(this.YKNO);
        dBTableReport_HTML.setYkno(this.YKNO);
        dBTableReport_HTML.setHeaderKeys(this.headerKeys);
        dBTableReport_HTML.setHeaderVals(this.headerVals);
        dBTableReport_HTML.setFooterKeys(this.footerKeys);
        dBTableReport_HTML.setFooterVals(this.footerVals);
        dBTableReport_HTML.setPageEndCut(this.pageEndCut);
        dBTableReport_HTML.setResourceManager(this.resource);
        dBTableReport_HTML.setListId(this.LISTID);
        dBTableReport_HTML.writeReport();
        return true;
    }

    public String modelFile() {
        return this.modelFILE;
    }

    public String getErrMsg() {
        return this.errMsg.toString();
    }
}

