/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.penguin.math.statistics;

import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.opengion.penguin.math.statistics.HybsRegression;

public class HybsSimpleRegression
implements HybsRegression {
    private double slope;
    private double intercept;
    private double rsquare;

    public HybsSimpleRegression(double[][] dArray) {
        this.train(dArray);
    }

    public HybsSimpleRegression(double d, double d2) {
        this.slope = d;
        this.intercept = d2;
    }

    public HybsSimpleRegression() {
    }

    public void train(double[][] dArray) {
        SimpleRegression simpleRegression = new SimpleRegression();
        simpleRegression.addData(dArray);
        this.slope = simpleRegression.getSlope();
        this.intercept = simpleRegression.getIntercept();
        this.rsquare = simpleRegression.getRSquare();
    }

    public void setOption(double[] dArray) {
    }

    public double getSlope() {
        return this.slope;
    }

    public double getIntercept() {
        return this.intercept;
    }

    @Override
    public double getRSquare() {
        return this.rsquare;
    }

    @Override
    public double[] getCoefficient() {
        double[] dArray = new double[]{this.slope, this.intercept, this.rsquare};
        return dArray;
    }

    @Override
    public void setCoefficient(double[] dArray) {
        this.slope = dArray[0];
        this.intercept = dArray[1];
    }

    @Override
    public double predict(double ... dArray) {
        return this.intercept + this.slope * dArray[0];
    }

    public static void main(String[] stringArray) {
        double[][] dArrayArray = new double[][]{{1.0, 2.3}, {2.0, 3.4}, {3.0, 6.1}, {4.0, 8.2}};
        HybsSimpleRegression hybsSimpleRegression = new HybsSimpleRegression(dArrayArray);
        System.out.println(hybsSimpleRegression.getIntercept());
        System.out.println(hybsSimpleRegression.getSlope());
        System.out.println(hybsSimpleRegression.getRSquare());
        System.out.println(hybsSimpleRegression.predict(5.0));
    }
}

