/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.taglet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import java.io.IOException;
import org.opengion.fukurou.taglet.DocletTagWriter;
import org.opengion.fukurou.taglet.DocletUtil;
import org.opengion.fukurou.util.LogWriter;

public final class DocletParam {
    private static final String OG_PARAM_LVL = "og.paramLevel";
    private static final String OG_CRYPTOGRAPHY = "og.cryptography";
    private static final String ENCODE = "UTF-8";
    private static final int CNST = 1000;

    private DocletParam() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean start(RootDoc rootDoc) {
        String string = DocletUtil.getOption("-systemId", rootDoc.options());
        String string2 = DocletUtil.getOption("-outfile", rootDoc.options());
        DocletTagWriter docletTagWriter = null;
        try {
            docletTagWriter = new DocletTagWriter(string2, ENCODE);
            docletTagWriter.printTag("<?xml version=\"1.0\" encoding=\"", ENCODE, "\" ?>");
            docletTagWriter.printTag("<javadoc>");
            docletTagWriter.printTag("  <systemId>", string, "</systemId>");
            DocletParam.writeContents(rootDoc.classes(), docletTagWriter);
            docletTagWriter.printTag("</javadoc>");
        }
        catch (IOException iOException) {
            LogWriter.log(iOException);
        }
        finally {
            if (docletTagWriter != null) {
                docletTagWriter.close();
            }
        }
        return true;
    }

    private static void writeContents(ClassDoc[] classDocArray, DocletTagWriter docletTagWriter) {
        for (int i = 0; i < classDocArray.length; ++i) {
            ClassDoc classDoc = classDocArray[i];
            FieldDoc[] fieldDocArray = classDoc.fields();
            for (int j = 0; j < fieldDocArray.length; ++j) {
                FieldDoc fieldDoc = fieldDocArray[j];
                String string = fieldDoc.constantValueExpression();
                if (string != null && string.length() >= 2 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
                    string = string.substring(1, string.length() - 1);
                }
                string = DocletUtil.htmlFilter(string);
                String string2 = fieldDoc.name();
                String string3 = String.valueOf(j * 10 + 1000);
                Tag[] tagArray = fieldDoc.firstSentenceTags();
                String string4 = DocletUtil.commentText(fieldDoc.commentText());
                Tag[] tagArray2 = fieldDoc.tags(OG_PARAM_LVL);
                Tag[] tagArray3 = fieldDoc.tags(OG_CRYPTOGRAPHY);
                docletTagWriter.printTag("<fieldDoc>");
                docletTagWriter.printTag("  <paramId>", string2, "</paramId>");
                docletTagWriter.printTag("  <seq>", string3, "</seq>");
                docletTagWriter.printTag("  <param>", string, "</param>");
                docletTagWriter.printTag("  <title>", tagArray, "</title>");
                docletTagWriter.printTag("  <contents>", string4, "</contents>");
                docletTagWriter.printChar("  <paramLevel>", tagArray2, "</paramLevel>");
                docletTagWriter.printChar("  <fgcrypt>", tagArray3, "</fgcrypt>");
                docletTagWriter.printTag("</fieldDoc>");
            }
        }
    }

    public static int optionLength(String string) {
        if (string.equalsIgnoreCase("-outfile")) {
            return 2;
        }
        if (string.equalsIgnoreCase("-systemId")) {
            return 2;
        }
        return 0;
    }
}

