#include "clProgramClass.h"

//--------------------------------------------------------
//----------          clProgramClass          ------------
//--------------------------------------------------------
// -------------------------------------------------------

// -------------------------------------------------------
//! \brief  vOIuWFNgi[ϐp
//! \param  Ȃ.
//! \return Ȃ.
clProgramClass::clProgramClass()
{
    __CONSTRUCTOR;
}

// -------------------------------------------------------
//! \brief  vOIuWFNg̔j
//! \param  Ȃ.
//! \return Ȃ.
clProgramClass::~clProgramClass()
{
    __DESTRUCTOR;
    for(unsigned int i=0; i < clprogram.size(); ++i){
        clReleaseProgram(clprogram[i]);
    }
}

// -------------------------------------------------------
//! \brief  vOIuWFNg̍쐬
//! \param  filename   vOIuWFNg쐬錳ɂȂvO.
//! \param  context    ֘AtReLXg.
//! \param  device_id  ֘AfoCXID̃Xg.
//! \param  device_num IDXgɊ܂܂foCX̐.
//! \return Ȃ.
void clProgramClass::createProgramObject(const char         *filename,
                                         const cl_context   context, 
                                         const cl_device_id device_id)
{try{
    cl_int     status;
    const char *source = NULL;


    // \[XR[h[h
    source = loadProgramSource(filename);

    // vOIuWFNg̐
    this->filename.push_back(filename);
    this->clprogram.push_back(
        clCreateProgramWithSource(context,
                                  1,
                                  (const char **)&source,
                                  NULL,
                                  &status));
    if(this->clprogram.back() == (cl_program)0){
        delete [] source;
        throw clErrorClass(status, "failed to create program object.", __FUNCTION__);
    }
    //vOrh
    status = clBuildProgram(this->clprogram.back(),
                            1,
                            &device_id,
                            NULL,
                            NULL,
                            NULL);
    if(status != CL_SUCCESS){
        delete[] source;
        showBuildLog(this->clprogram.back(), device_id);
        throw clErrorClass(status, "failed to build program object.", __FUNCTION__);
    }
    delete [] source;
}
catch(clErrorClass &err){err.showErrMsg();}catch(...){std::cerr << "unknown error." << std::endl;}}

// -------------------------------------------------------
//! \brief  w肵t@Cǂݍ
//! \param  filename   vOIuWFNg쐬錳ɂȂvO.
//! \return Ȃ.
 inline const char *clProgramClass::loadProgramSource(const char *filename) throw(clErrorClass)
{
    FILE *inFile;
    char *source=NULL;
    size_t filesize = 0;

    inFile = fopen(filename ,"r");
    if(inFile == 0){
        perror("fopen");
        fprintf(stderr, "file: %s\n", filename);
        throw clErrorClass("kernel program file open failed.", __FUNCTION__);
    }
    while(fgetc(inFile) != EOF){filesize++;}    // t@C̃TCỸ`FbN
    fseek(inFile, 0L, SEEK_SET);                // t@C̐擪
    source = new char[filesize+1];              // t@C̃TCỸobt@擾
    fread(source, filesize, 1, inFile);         // t@C̓ǂݍ
    source[filesize] = 0;                       // ŌNULL𖄂ߍ
    fclose(inFile);

    return source;
}

// -------------------------------------------------------
//! \brief  rhO\
//! \param  program vOIuWFNg쐬錳ɂȂvO.
//! \param  device  Ώۂ̃foCX.
//! \return Ȃ.
inline void clProgramClass::showBuildLog(const cl_program   program,
                                         const cl_device_id device) const throw(clErrorClass)
{
    cl_int status;
    size_t size_ret;

    // rhO̒̕擾
    status = clGetProgramBuildInfo(program,
                                   device,
                                   CL_PROGRAM_BUILD_LOG,
                                   NULL,
                                   NULL,
                                   &size_ret);
    if(status != CL_SUCCESS){
        throw clErrorClass(status, "clGetProgramInfo get buffer size failed." , __FUNCTION__);
    }

    // rhO擾
    char *buffer = new char[size_ret];
    status = clGetProgramBuildInfo(program,
                                   device,
                                   CL_PROGRAM_BUILD_LOG,
                                   size_ret,
                                   buffer,
                                   NULL);
    if(status != CL_SUCCESS){
        delete [] buffer;
        throw clErrorClass(status, "clGetProgramInfo get buffer failed." , __FUNCTION__);
    }
    buffer[size_ret] = 0;
    std::cout << ">>> build log <<<" << std::endl;
    std::cout << buffer << std::endl;
    std::cout << ">>> end of build log <<<" << std::endl;

    DBG(press enter);
    NL(1);
    delete [] buffer;
}

// -------------------------------------------------------
//! \brief  t@CvOIuWFNg擾.
//! \param  program_index vO̎QƔԍ.
//! \return vOIuWFNgԋp.0
const cl_program clProgramClass::getProgram(const char *filename) const
{
    return this->clprogram[getProgramIndex(filename)];
}

// -------------------------------------------------------
//! \brief  t@CvOIuWFNg̎QƔԍ擾.
//! \param  filename t@C.
//! \return vOIuWFNg̎QƔԍԋp.
inline const unsigned int clProgramClass::getProgramIndex(const char *filename) const
{
    unsigned int index=0;
    for(index=0; index<this->filename.size(); ++index){
        if(this->filename[index] == filename){
            goto LOOP_SUCCESS;
        }
    }
    std::cerr << "file :\"" << filename << "\" not found." << std::endl;
	index=0;
LOOP_SUCCESS:
    return index;
}
