#include "clClass.h"

//--------------------------------------------------------
//----------              clClass             ------------
//--------------------------------------------------------
// -------------------------------------------------------

// -------------------------------------------------------
//! \brief  OpenCL̂ɕKvȃmpӂ.
//! \param  Ȃ.
//! \return Ȃ.
clClass::clClass()
{
    __CONSTRUCTOR;
}

// -------------------------------------------------------
//! \brief  OpenCL̂ɕKvȃmpӂ.
//! \param  Ȃ.
//! \return Ȃ.
void clClass::set(cl_device_id device_id)
{try{
    __CONSTRUCTOR;

    cl_int status;
    this->device_id = device_id;
    // device_idɊ֘AtĂvbgtH[擾
    status = clGetDeviceInfo(this->device_id,
                             CL_DEVICE_PLATFORM,
                             sizeof(cl_platform_id),
                             &this->platform_id,    // platform_id擾
                             NULL);
    if(status != CL_SUCCESS){
        throw clErrorClass(status, "get platformID failed.", __FUNCTION__);
    }

    // ReLXg擾
    this->context = clCreateContext(0,
                                    1,
                                    &this->device_id,
                                    NULL,
                                    NULL,
                                    &status);
    if(status != CL_SUCCESS){
        throw clErrorClass(status, "clCreateContextInfo failed.", __FUNCTION__);
    }

    // R}hL[擾
    this->command_queue = clCreateCommandQueue(this->context,
                                               this->device_id,
                                               NULL,
                                               &status);
    if(status != CL_SUCCESS){
        throw clErrorClass(status, "failed to create command queue.", __FUNCTION__);
    }

    this->C_platform     = new clPlatformClass(this->platform_id);
    this->C_device       = new clDeviceClass(this->device_id);
//    this->C_context      = new clContextClass(this->device_id);
//    this->C_commandqueue = new clCommandQueueClass(this->context, this->device_id);
    this->C_program      = new clProgramClass();
    this->C_kernel       = new clKernelClass();
    this->C_memory       = new clMemoryClass();
}catch(clErrorClass &err){err.showErrMsg();exit(1);}catch(...){std::cerr << "unknown error." << std::endl;}}

// -------------------------------------------------------
//! \brief  gpϐȂǂj.
//! \param  Ȃ.
//! \return Ȃ.
clClass::~clClass()
{
    __DESTRUCTOR;
    delete this->C_platform;
    delete this->C_device;
//    delete this->C_context;
//    delete this->C_commandqueue;
    delete this->C_program;
    delete this->C_kernel;
    delete this->C_memory;

    clReleaseContext(context);
    clReleaseCommandQueue(command_queue);
}












// vbgtH[֘A
// -------------------------------------------------------
//! \brief  vbgtH[ID擾.
//! \param  platform_index vbgtH[̎QƔԍ.
//! \return vbgtH[IDԋp.
const cl_platform_id clClass::getPlatformId() const
{
    return this->platform_id;
}

// -------------------------------------------------------
//! \brief  vbgtH[̎QƔԍƃvbgtH[̒m肽񂩂ڍ׏擾.
//! \param  platform_index vbgtH[̎QƔԍ.
//! \param  platform_info  m肽.
//! \return vbgtH[̏ڍ׏ԋp.
const char *clClass::getPlatformInfo(cl_platform_info platform_info) const
{
    return this->C_platform->getPlatformInfo(platform_info);
}

// -------------------------------------------------------
//! \brief  vbgtH[̎QƔԍƃvbgtH[̒m肽񂩂ڍ׏\.
//! \param  platform_index vbgtH[̎QƔԍ.
//! \param  platform_info  m肽.
//! \return Ȃ.
void clClass::showPlatformInfo(cl_platform_info platform_info) const
{
    this->C_platform->showPlatformInfo(platform_info);
}

// -------------------------------------------------------
//! \brief  vbgtH[̎QƔԍڍ׏ׂĕ\.
//! \param  platform_index vbgtH[̎QƔԍ.
//! \return Ȃ.
void clClass::showPlatformInfoAll() const
{
    this->C_platform->showPlatformInfoAll();
}







// foCX֘A
// -------------------------------------------------------
//! \brief  foCXID擾.
//! \param  Ȃ.
//! \return foCXIDԋp.
const cl_device_id clClass::getDeviceId() const
{
    return this->device_id;
}

// -------------------------------------------------------
//! \brief  foCX̏ڍ׏擾.
//! \param  platform_info  m肽.
//! \return foCX̏ڍ׏ԋp.
const char *clClass::getDeviceInfo(cl_device_info device_info ) const
{
    return this->C_device->getDeviceInfo(device_info);
}

// -------------------------------------------------------
//! \brief  foCX̏w肵ĕ\.
//! \param  device_info    m肽foCX̏.
//! \return Ȃ.
void clClass::showDeviceInfo(cl_device_info device_info) const
{
    this->C_device->showDeviceInfo(device_info);
}

// -------------------------------------------------------
//! \brief  foCX̏ڍ׏\.
//! \param  Ȃ.
//! \return Ȃ.
void clClass::showDeviceInfoAll() const
{
    this->C_device->showDeviceInfoAll();
}








//ReLXg֘A
// -------------------------------------------------------
//! \brief  ReLXg擾.
//! \param  Ȃ.
//! \return ReLXgԋp.
const cl_context clClass::getContext() const
{
    return this->context;
}






//R}hL[֘A
// -------------------------------------------------------
//! \brief  R}hL[擾.
//! \param  Ȃ.
//! \return R}hL[ԋp.
const cl_command_queue clClass::getCommandQueue() const
{
    return this->command_queue;
}






//vO֘A
// -------------------------------------------------------
//! \brief  t@Cw肵ăvOIuWFNg쐬.
/*! */
//! \param  filename t@C.
//! \return Ȃ.
void clClass::createProgramObject(const char *filename)
{
    this->C_program->createProgramObject(filename, 
                                         this->context,
                                         this->device_id);
}






//J[l֘A
// -------------------------------------------------------
//! \brief  t@Cw肵ăvOIuWFNg쐬.
/*! */
//! \param  filename t@C.
//! \return Ȃ.
void clClass::createKernel(const char *file_name ,const char *kernel_name)
{
    this->C_kernel->createKernel(this->C_program->getProgram(file_name),
                                 kernel_name);
}

// -------------------------------------------------------
//! \brief  J[lԋp.
//! \param  Ȃ.
//! \return J[lԋp.
const cl_kernel clClass::getKernel(std::string kernel_name) const
{
    return this->C_kernel->getKernel(kernel_name);
}

// -------------------------------------------------------
//! \brief  J[l̎QƂ擾.
//! \param  J[l̖O.
//! \return J[l̎QƂԋp.
const void clClass::setKernelArg(std::string  kernel_name,
                                 unsigned int arg_index,
                                 size_t       memory_size,
                                 std::string  memory_name) throw(clErrorClass)
{
    this->C_kernel->setKernelArgs(kernel_name,
                                  C_memory->getMemory(memory_name),
                                  arg_index,
                                  memory_size);
}

// -------------------------------------------------------
//! \brief  J[l̎QƂ擾.
//! \param  J[l̖O.
//! \return J[l̎QƂԋp.
const void clClass::setKernelArg(std::string  kernel_name,
                                 unsigned int arg_index,
                                 size_t       memory_size,
                                 void *memory) throw(clErrorClass)
{
    this->C_kernel->setKernelArgs(kernel_name,
                                  memory,
                                  arg_index,
                                  memory_size);
}





//֘A
// -------------------------------------------------------
//! \brief  t@Cw肵ăvOIuWFNg쐬.
//! \param  filename t@C.
//! \return Ȃ.
const void clClass::createMemory(cl_mem_flags flag, size_t memroy_size, void *mem_pointer, std::string name) const
{
    C_memory->createMemory(this->context,
                           flag,
                           memroy_size,
                           mem_pointer,
                           name);
}

cl_mem *clClass::getMemory(unsigned int index) const
{
    return C_memory->getMemory(index);
}

cl_mem *clClass::getMemory(std::string name) const
{
    return C_memory->getMemory(name);
}






// J[l̎sƂ
// -------------------------------------------------------
//! \brief  t@Cw肵ăvOIuWFNg쐬.
//! \param  filename t@C.
//! \return Ȃ.
void clClass::runKernel(std::string     kernel_name, 
                        cl_uint         num_dimension, 
                        const size_t    *offset,
                        size_t          *global_work_size, 
                        size_t          *local_work_size,
                        cl_uint         num_event,
                        const cl_event  *event_list,
                        cl_event        *event_ ) const
{
    cl_uint status;
    status = clEnqueueNDRangeKernel(this->command_queue,                    // R}hL[
                                    this->C_kernel->getKernel(kernel_name), // sJ[l
                                    num_dimension,                          // 
                                    offset,                                 // O[o[NXy[X̃ItZbg=0
                                    global_work_size,                       // O[õ[NXy[XTCY
                                    local_work_size,                        // [NO[ṽTCY
                                    num_event,                              // Cxg̐
                                    event_list,                             // Cxg̃Xg
                                    event_);                                // Cxgւ̃|C^
    if(status != CL_SUCCESS){
        clErrorClass err(status, "clEnqueueNDRangeKernel failed.", __FUNCTION__);
        err.showErrMsg();
    }
}

void clClass::runKernel(std::string     kernel_name, 
                        cl_uint         num_dimension, 
                        size_t          *global_work_size, 
                        size_t          *local_work_size,
                        cl_uint         num_event,
                        const cl_event  *event_list,
                        cl_event        *event_ ) const
{
    cl_uint status;
    status = clEnqueueNDRangeKernel(this->command_queue,                    // R}hL[
                                    this->C_kernel->getKernel(kernel_name), // sJ[l
                                    num_dimension,                          // 
                                    0,                                      // O[o[NXy[X̃ItZbg=0
                                    global_work_size,                       // O[õ[NXy[XTCY
                                    local_work_size,                        // [NO[ṽTCY
                                    num_event,                              // Cxg̐
                                    event_list,                             // Cxg̃Xg
                                    event_);                                // Cxgւ̃|C^
    if(status != CL_SUCCESS){
        clErrorClass err(status, "clEnqueueNDRangeKernel failed.", __FUNCTION__);
        err.showErrMsg();
    }
}

void clClass::runKernel(std::string   kernel_name, 
                        cl_uint       num_dimension, 
                        const size_t  *offset,
                        size_t        *global_work_size, 
                        size_t        *local_work_size) const
{
    cl_uint status;
    status = clEnqueueNDRangeKernel(this->command_queue,                    // R}hL[
                                    this->C_kernel->getKernel(kernel_name), // sJ[l
                                    num_dimension,                          // 
                                    offset,                                 // O[o[NXy[X̃ItZbg=0
                                    global_work_size,                       // O[õ[NXy[XTCY
                                    local_work_size,                        // [NO[ṽTCY
                                    0,                                      // Cxg̐
                                    NULL,                                   // Cxg̃Xg
                                    NULL);                                  // Cxgւ̃|C^
    if(status != CL_SUCCESS){
        clErrorClass err(status, "clEnqueueNDRangeKernel failed.", __FUNCTION__);
        err.showErrMsg();
    }
}

void clClass::runKernel(std::string  kernel_name, 
                        cl_uint      num_dimension, 
                        size_t       *global_work_size, 
                        size_t       *local_work_size) const
{
    cl_uint status;
    status = clEnqueueNDRangeKernel(this->command_queue,                    // R}hL[
                                    this->C_kernel->getKernel(kernel_name), // sJ[l
                                    num_dimension,                          // 
                                    0,                                      // O[o[NXy[X̃ItZbg=0
                                    global_work_size,                       // O[õ[NXy[XTCY
                                    local_work_size,                        // [NO[ṽTCY
                                    0,                                      // Cxg̐
                                    NULL,                                   // Cxg̃Xg
                                    NULL);                                  // Cxgւ̃|C^
    if(status != CL_SUCCESS){
        clErrorClass err(status, "clEnqueueNDRangeKernel failed.", __FUNCTION__);
        err.showErrMsg();
    }
}



// J[l̎sʂ擾
// sʂ擾
void clClass::getResult(std::string        kernel_name, 
	                    std::string        src_memory_name,
						cl_bool            block,
						size_t             offset,
						size_t             memory_size,
						void               *dst_memory,
						cl_uint            num_event,
						const cl_event     *event_list,
						cl_event           *event_ ) const
{
	cl_int status;
    status = clEnqueueReadBuffer(this->command_queue,
								 *this->C_memory->getMemory(src_memory_name), // 󂯎錋ʂi[Ă郁IuWFNg(src)
                                 block,                                             // ubLO邩Ȃ
                                 offset,                                            // ǂݍ݃f[^̃ItZbg
                                 memory_size,                                       // ǂݍރf[^̃TCY
                                 dst_memory,                                        // ʂ󂯎z(dst)
                                 num_event,                                         // Cxg̐
                                 event_list,                                        // Cxg̃Xg
                                 event_);                                           // Cxgւ̃|C^
    if(status != CL_SUCCESS){
        clErrorClass err(status, "clEnqueueReadBuffer failed.", __FUNCTION__);
        err.showErrMsg();
    }
}


void clClass::getResult(std::string        kernel_name, 
	                    std::string        src_memory_name,
						cl_bool            block,
						size_t             memory_size,
						void               *dst_memory,
						cl_uint            num_event,
						const cl_event     *event_list,
						cl_event           *event_ ) const
{
	cl_int status;
    status = clEnqueueReadBuffer(this->command_queue,
	                             *this->C_memory->getMemory(src_memory_name),       // 󂯎錋ʂi[Ă郁IuWFNg(src)
                                 block,                                             // ubLO邩Ȃ
                                 0,                                                 // ǂݍ݃f[^̃ItZbg
                                 memory_size,                                       // ǂݍރf[^̃TCY
                                 dst_memory,                                        // ʂ󂯎z(dst)
                                 num_event,                                         // Cxg̐
                                 event_list,                                        // Cxg̃Xg
                                 event_);                                           // Cxgւ̃|C^
    if(status != CL_SUCCESS){
        clErrorClass err(status, "clEnqueueReadBuffer failed.", __FUNCTION__);
        err.showErrMsg();
    }
}


void clClass::getResult(std::string        kernel_name, 
	                    std::string        src_memory_name,
						size_t             memory_size,
						void               *dst_memory,
						cl_uint            num_event,
						const cl_event     *event_list,
						cl_event           *event_ ) const
{
	cl_int status;
    status = clEnqueueReadBuffer(this->command_queue,
	                             *this->C_memory->getMemory(src_memory_name),       // 󂯎錋ʂi[Ă郁IuWFNg(src)
                                 CL_TRUE,                                             // ubLO邩Ȃ
                                 0,                                            // ǂݍ݃f[^̃ItZbg
                                 memory_size,                                       // ǂݍރf[^̃TCY
                                 dst_memory,                                        // ʂ󂯎z(dst)
                                 num_event,                                         // Cxg̐
                                 event_list,                                        // Cxg̃Xg
                                 event_);                                           // Cxgւ̃|C^
    if(status != CL_SUCCESS){
        clErrorClass err(status, "clEnqueueReadBuffer failed.", __FUNCTION__);
        err.showErrMsg();
    }
}


void clClass::getResult(std::string        kernel_name, 
	                    std::string        src_memory_name,
						cl_bool            block,
						size_t             offset,
						size_t             memory_size,
						void               *dst_memory) const
{
	cl_int status;
    status = clEnqueueReadBuffer(this->command_queue,
								 *this->C_memory->getMemory(src_memory_name), // 󂯎錋ʂi[Ă郁IuWFNg(src)
                                 block,                                             // ubLO邩Ȃ
                                 offset,                                            // ǂݍ݃f[^̃ItZbg
                                 memory_size,                                       // ǂݍރf[^̃TCY
                                 dst_memory,                                        // ʂ󂯎z(dst)
                                 0,                                                 // Cxg̐
                                 NULL,                                              // Cxg̃Xg
                                 NULL);                                             // Cxgւ̃|C^
    if(status != CL_SUCCESS){
        clErrorClass err(status, "clEnqueueReadBuffer failed.", __FUNCTION__);
        err.showErrMsg();
    }
}


void clClass::getResult(std::string        kernel_name, 
	                    std::string        src_memory_name,
						cl_bool            block,
						size_t             memory_size,
						void               *dst_memory) const
{
	cl_int status;
    status = clEnqueueReadBuffer(this->command_queue,
	                             *this->C_memory->getMemory(src_memory_name),       // 󂯎錋ʂi[Ă郁IuWFNg(src)
                                 block,                                             // ubLO邩Ȃ
                                 0,                                                 // ǂݍ݃f[^̃ItZbg
                                 memory_size,                                       // ǂݍރf[^̃TCY
                                 dst_memory,                                        // ʂ󂯎z(dst)
                                 0,                                                 // Cxg̐
                                 NULL,                                              // Cxg̃Xg
                                 NULL);                                             // Cxgւ̃|C^
    if(status != CL_SUCCESS){
        clErrorClass err(status, "clEnqueueReadBuffer failed.", __FUNCTION__);
        err.showErrMsg();
    }
}


void clClass::getResult(std::string        kernel_name, 
	                    std::string        src_memory_name,
						size_t             memory_size,
						void               *dst_memory) const
{
	cl_int status;
    status = clEnqueueReadBuffer(this->command_queue,
	                             *this->C_memory->getMemory(src_memory_name),       // 󂯎錋ʂi[Ă郁IuWFNg(src)
                                 CL_TRUE,                                           // ubLO邩Ȃ
                                 0,                                                 // ǂݍ݃f[^̃ItZbg
                                 memory_size,                                       // ǂݍރf[^̃TCY
                                 dst_memory,                                        // ʂ󂯎z(dst)
                                 0,                                                 // Cxg̐
                                 NULL,                                              // Cxg̃Xg
                                 NULL);                                             // Cxgւ̃|C^
    if(status != CL_SUCCESS){
        clErrorClass err(status, "clEnqueueReadBuffer failed.", __FUNCTION__);
        err.showErrMsg();
    }
}
