#include "calc.h"

double getPI_OMP(size_t size){
	double step = 1.0 / (double)size;
	double x;
	double sum = 0.0;
#pragma omp parallel for reduction (+:sum) private( x )
    for(int i=1; i <= (int)size ; i++){
       x = ((double)i - 0.5) * step;
       sum += 4.0 / ( 1.0 + x*x);
    }
	return sum * step;
}

double getPI(size_t size){
	double step = 1.0 / (double)size;
	double x;
	double sum = 0.0;
    for(int i=1; i <= (int)size ; i++){
       x = ((double)i - 0.5) * step;
       sum += 4.0 / ( 1.0 + x*x);
    }
	return sum * step;
}

void addVector_OMP(size_t NumElements, float *out,float *in1,float *in2){
#pragma omp parallel for
    for(int index=0; index<(int)NumElements; ++index){
		out[index]  = in1[index] + in2[index];
		out[index] += in1[index] - in2[index];
		out[index] += in1[index] * in2[index];
		out[index] += in1[index] / in2[index];
    }
}

void addVector(size_t NumElements, float *out,float *in1,float *in2){
    for(int index=0; index<(int)NumElements; ++index){
		out[index]  = in1[index] + in2[index];
		out[index] += in1[index] - in2[index];
		out[index] += in1[index] * in2[index];
		out[index] += in1[index] / in2[index];
    }
}
