/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core2.rasteranalyzer.threshold;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARBufferReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core2.rasteranalyzer.threshold.INyARRasterThresholdAnalyzer;

public class NyARRasterThresholdAnalyzer_DiffHistgram
implements INyARRasterThresholdAnalyzer {
    private int _threshold;

    private int createHistgram(int[] in_buf, NyARIntSize i_size, int[] o_histgram) throws NyARException {
        int[][] fil1 = new int[][]{{-1, -2, -1}, new int[3], {1, 2, 1}};
        int i = 0;
        while (i < 256) {
            o_histgram[i] = 0;
            ++i;
        }
        int y = 1;
        while (y < i_size.h - 1) {
            int x = 1;
            while (x < i_size.w - 1) {
                int v = in_buf[y * i_size.w + x];
                int sam2 = 0;
                int sam1 = 0;
                int yy = 0;
                while (yy < 3) {
                    int xx = 0;
                    while (xx < 3) {
                        int v2 = in_buf[(y + yy - 1) * i_size.w + (x + xx - 1)];
                        sam1 += v2 * fil1[xx][yy];
                        sam2 += v2 * fil1[yy][xx];
                        ++xx;
                    }
                    ++yy;
                }
                int sam = sam1 * sam1 + sam2 * sam2;
                int n = v;
                o_histgram[n] = o_histgram[n] + sam;
                ++x;
            }
            ++y;
        }
        int th = 0;
        int max = o_histgram[0];
        int i2 = 1;
        while (i2 < 256) {
            if (max < o_histgram[i2]) {
                th = i2;
                max = o_histgram[i2];
            }
            ++i2;
        }
        return th;
    }

    public void analyzeRaster(INyARRaster i_input) throws NyARException {
        INyARBufferReader buffer_reader = i_input.getBufferReader();
        assert (buffer_reader.isEqualBufferType(262145));
        int[] histgram = new int[256];
        this._threshold = this.createHistgram((int[])buffer_reader.getBuffer(), i_input.getSize(), histgram);
    }

    public void debugDrawHistgramMap(INyARRaster i_input, INyARRaster i_output) throws NyARException {
        INyARBufferReader in_buffer_reader = i_input.getBufferReader();
        INyARBufferReader out_buffer_reader = i_output.getBufferReader();
        assert (in_buffer_reader.isEqualBufferType(262145));
        assert (out_buffer_reader.isEqualBufferType(262145));
        NyARIntSize size = i_output.getSize();
        int[] out_buf = (int[])out_buffer_reader.getBuffer();
        int y = 0;
        while (y < size.h) {
            int x = 0;
            while (x < size.w) {
                out_buf[y * size.w + x] = 0;
                ++x;
            }
            ++y;
        }
        int[] histgram = new int[256];
        int threshold = this.createHistgram((int[])in_buffer_reader.getBuffer(), i_input.getSize(), histgram);
        int max_v = 0;
        int i = 0;
        while (i < 255) {
            if (max_v < histgram[i]) {
                max_v = histgram[i];
            }
            ++i;
        }
        i = 0;
        while (i < size.h) {
            out_buf[i * size.w + 0] = 128;
            out_buf[i * size.w + 128] = 128;
            out_buf[i * size.w + 255] = 128;
            ++i;
        }
        i = 0;
        while (i < 255) {
            out_buf[histgram[i] * (size.h - 1) / max_v * size.w + i] = 255;
            ++i;
        }
        i = 0;
        while (i < size.h) {
            out_buf[i * size.w + threshold] = 255;
            ++i;
        }
    }

    public int getThreshold() {
        return this._threshold;
    }

    public int getThreshold(int i_x, int i_y) {
        return this._threshold;
    }
}

