/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.transmat.optimize;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.transmat.fitveccalc.NyARFitVecCalculator;
import jp.nyatla.nyartoolkit.core.transmat.optimize.INyARRotTransOptimize;
import jp.nyatla.nyartoolkit.core.transmat.rotmatrix.NyARRotMatrix;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix33;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix34;

public class NyARRotTransOptimize_Base
implements INyARRotTransOptimize {
    private static final int AR_GET_TRANS_MAT_MAX_LOOP_COUNT = 5;
    private static final double AR_GET_TRANS_MAT_MAX_FIT_ERROR = 1.0;
    private final NyARPerspectiveProjectionMatrix _projection_mat_ref;
    private double[] __createRotationMap_b_map = new double[6];
    private double[] __createRotationMap_c_map = new double[6];
    private double[] __createRotationMap_f = new double[3];
    private final NyARDoublePoint3d __modifyMatrix_angle = new NyARDoublePoint3d();
    private final NyARDoubleMatrix34 __modifyMatrix_combo = new NyARDoubleMatrix34();
    private final NyARDoubleMatrix33[] __modifyMatrix_next_rot_matrix = NyARDoubleMatrix33.createArray(27);

    public NyARRotTransOptimize_Base(NyARPerspectiveProjectionMatrix i_projection_mat_ref) {
        this._projection_mat_ref = i_projection_mat_ref;
    }

    public final double optimize(NyARRotMatrix io_rotmat, NyARDoublePoint3d io_transvec, NyARFitVecCalculator i_calculator) throws NyARException {
        NyARDoublePoint2d[] fit_vertex = i_calculator.getFitSquare();
        NyARDoublePoint3d[] offset_square = i_calculator.getOffsetVertex().vertex;
        double err = -1.0;
        int i = 0;
        while (true) {
            err = this.modifyMatrix(io_rotmat, io_transvec, offset_square, fit_vertex);
            i_calculator.calculateTransfer(io_rotmat, io_transvec);
            err = this.modifyMatrix(io_rotmat, io_transvec, offset_square, fit_vertex);
            if (err < 1.0 || i == 4) break;
            i_calculator.calculateTransfer(io_rotmat, io_transvec);
            ++i;
        }
        return err;
    }

    private void createRotationMap(NyARDoublePoint3d i_angle, double i_factor, NyARDoubleMatrix33[] i_rot_matrix) {
        double ang1;
        double[] f = this.__createRotationMap_f;
        double[] b_map = this.__createRotationMap_b_map;
        double[] c_map = this.__createRotationMap_c_map;
        f[0] = -i_factor;
        f[1] = 0.0;
        f[2] = i_factor;
        int i = 0;
        while (i < 3) {
            ang1 = i_angle.y + f[i];
            b_map[i] = Math.sin(ang1);
            b_map[i + 3] = Math.cos(ang1);
            double ang2 = i_angle.z + f[i];
            c_map[i] = Math.sin(ang2);
            c_map[i + 3] = Math.cos(ang2);
            ++i;
        }
        int idx = 0;
        int t1 = 0;
        while (t1 < 3) {
            ang1 = i_angle.x + f[t1];
            double sina = Math.sin(ang1);
            double cosa = Math.cos(ang1);
            double CACA = cosa * cosa;
            double SASA = sina * sina;
            double SACA = sina * cosa;
            int t2 = 0;
            while (t2 < 3) {
                double sinb = b_map[t2];
                double cosb = b_map[t2 + 3];
                double SASB = sina * sinb;
                double CASB = cosa * sinb;
                double SACACB = SACA * cosb;
                double CACACB = CACA * cosb;
                double SASACB = SASA * cosb;
                int t3 = 0;
                while (t3 < 3) {
                    double sinc = c_map[t3];
                    double cosc = c_map[t3 + 3];
                    NyARDoubleMatrix33 mat_ptr = i_rot_matrix[idx];
                    mat_ptr.m00 = CACACB * cosc + SASA * cosc + SACACB * sinc - SACA * sinc;
                    mat_ptr.m01 = -CACACB * sinc - SASA * sinc + SACACB * cosc - SACA * cosc;
                    mat_ptr.m02 = CASB;
                    mat_ptr.m10 = SACACB * cosc - SACA * cosc + SASACB * sinc + CACA * sinc;
                    mat_ptr.m11 = -SACACB * sinc + SACA * sinc + SASACB * cosc + CACA * cosc;
                    mat_ptr.m12 = SASB;
                    mat_ptr.m20 = -CASB * cosc - SASB * sinc;
                    mat_ptr.m21 = CASB * sinc - SASB * cosc;
                    mat_ptr.m22 = cosb;
                    ++idx;
                    ++t3;
                }
                ++t2;
            }
            ++t1;
        }
    }

    private final void getNewMatrix(NyARDoubleMatrix33 i_rot, NyARDoublePoint3d i_trans, NyARDoubleMatrix34 o_combo) {
        NyARPerspectiveProjectionMatrix cp = this._projection_mat_ref;
        double cp3 = cp.m03;
        double cp0 = cp.m00;
        double cp1 = cp.m01;
        double cp2 = cp.m02;
        o_combo.m00 = cp0 * i_rot.m00 + cp1 * i_rot.m10 + cp2 * i_rot.m20;
        o_combo.m01 = cp0 * i_rot.m01 + cp1 * i_rot.m11 + cp2 * i_rot.m21;
        o_combo.m02 = cp0 * i_rot.m02 + cp1 * i_rot.m12 + cp2 * i_rot.m22;
        o_combo.m03 = cp0 * i_trans.x + cp1 * i_trans.y + cp2 * i_trans.z + cp3;
        cp0 = cp.m10;
        cp1 = cp.m11;
        cp2 = cp.m12;
        o_combo.m10 = cp0 * i_rot.m00 + cp1 * i_rot.m10 + cp2 * i_rot.m20;
        o_combo.m11 = cp0 * i_rot.m01 + cp1 * i_rot.m11 + cp2 * i_rot.m21;
        o_combo.m12 = cp0 * i_rot.m02 + cp1 * i_rot.m12 + cp2 * i_rot.m22;
        o_combo.m13 = cp0 * i_trans.x + cp1 * i_trans.y + cp2 * i_trans.z + cp3;
        cp0 = cp.m20;
        cp1 = cp.m21;
        cp2 = cp.m22;
        o_combo.m20 = cp0 * i_rot.m00 + cp1 * i_rot.m10 + cp2 * i_rot.m20;
        o_combo.m21 = cp0 * i_rot.m01 + cp1 * i_rot.m11 + cp2 * i_rot.m21;
        o_combo.m22 = cp0 * i_rot.m02 + cp1 * i_rot.m12 + cp2 * i_rot.m22;
        o_combo.m23 = cp0 * i_trans.x + cp1 * i_trans.y + cp2 * i_trans.z + cp3;
    }

    public final double modifyMatrix(NyARRotMatrix io_rot, NyARDoublePoint3d trans, NyARDoublePoint3d[] i_vertex3d, NyARDoublePoint2d[] i_vertex2d) throws NyARException {
        NyARDoublePoint3d angle = this.__modifyMatrix_angle;
        NyARDoubleMatrix34 combo = this.__modifyMatrix_combo;
        NyARDoubleMatrix33[] next_rot_matrix = this.__modifyMatrix_next_rot_matrix;
        double minerr = 0.0;
        int best_idx = 0;
        angle.copyFrom(io_rot.refAngle());
        double factor = 0.17453292519943295;
        int j = 0;
        while (j < 10) {
            minerr = 1.0E9;
            this.createRotationMap(angle, factor, next_rot_matrix);
            best_idx = 13;
            int i2 = 0;
            while (i2 < 27) {
                this.getNewMatrix(next_rot_matrix[i2], trans, combo);
                double err = 0.0;
                int i = 0;
                while (i < 4) {
                    double hx = combo.m00 * i_vertex3d[i].x + combo.m01 * i_vertex3d[i].y + combo.m02 * i_vertex3d[i].z + combo.m03;
                    double hy = combo.m10 * i_vertex3d[i].x + combo.m11 * i_vertex3d[i].y + combo.m12 * i_vertex3d[i].z + combo.m13;
                    double h = combo.m20 * i_vertex3d[i].x + combo.m21 * i_vertex3d[i].y + combo.m22 * i_vertex3d[i].z + combo.m23;
                    double x = i_vertex2d[i].x - hx / h;
                    double y = i_vertex2d[i].y - hy / h;
                    err += x * x + y * y;
                    ++i;
                }
                if (err < minerr) {
                    minerr = err;
                    best_idx = i2;
                }
                ++i2;
            }
            if (best_idx == 13) {
                factor *= 0.5;
            } else {
                angle.z += factor * (double)(best_idx % 3 - 1);
                angle.y += factor * (double)(best_idx / 3 % 3 - 1);
                angle.x += factor * (double)(best_idx / 9 % 3 - 1);
            }
            ++j;
        }
        io_rot.setAngle(angle.x, angle.y, angle.z);
        return minerr / 4.0;
    }
}

