/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.pca2d;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.pca2d.INyARPca2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix22;

public class NyARPca2d_MatrixPCA_O2
implements INyARPca2d {
    private static final double PCA_EPS = 1.0E-6;
    private static final int PCA_MAX_ITER = 100;
    private static final double PCA_VZERO = 1.0E-16;

    private static void PCA_QRM(NyARDoubleMatrix22 o_matrix, NyARDoublePoint2d dv) throws NyARException {
        double t;
        double dv_x = o_matrix.m00;
        double ev1 = o_matrix.m01;
        double dv_y = o_matrix.m11;
        double mat11 = 1.0;
        double mat00 = 1.0;
        double mat10 = 0.0;
        double mat01 = 0.0;
        int iter = 0;
        while (++iter <= 100) {
            double c;
            double w = (dv_x - dv_y) / 2.0;
            t = ev1 * ev1;
            double s = Math.sqrt(w * w + t);
            if (w < 0.0) {
                s = -s;
            }
            double x = dv_x - dv_y + t / (w + s);
            double y = ev1;
            if (Math.abs(x) >= Math.abs(y)) {
                if (Math.abs(x) > 1.0E-16) {
                    t = -y / x;
                    c = 1.0 / Math.sqrt(t * t + 1.0);
                    s = t * c;
                } else {
                    c = 1.0;
                    s = 0.0;
                }
            } else {
                t = -x / y;
                s = 1.0 / Math.sqrt(t * t + 1.0);
                c = t * s;
            }
            w = dv_x - dv_y;
            t = (w * s + 2.0 * c * ev1) * s;
            dv_x -= t;
            dv_y += t;
            ev1 += s * (c * w - 2.0 * s * ev1);
            x = mat00;
            y = mat10;
            mat00 = c * x - s * y;
            mat10 = s * x + c * y;
            x = mat01;
            y = mat11;
            mat01 = c * x - s * y;
            mat11 = s * x + c * y;
            if (Math.abs(ev1) > 1.0E-6 * (Math.abs(dv_x) + Math.abs(dv_y))) continue;
        }
        t = dv_x;
        if (dv_y > t) {
            t = dv_y;
            dv_y = dv_x;
            dv_x = t;
            o_matrix.m00 = mat10;
            o_matrix.m01 = mat11;
            o_matrix.m10 = mat00;
            o_matrix.m11 = mat01;
        } else {
            o_matrix.m00 = mat00;
            o_matrix.m01 = mat01;
            o_matrix.m10 = mat10;
            o_matrix.m11 = mat11;
        }
        dv.x = dv_x;
        dv.y = dv_y;
    }

    private void PCA_PCA(double[] i_x, double[] i_y, int i_number_of_data, NyARDoubleMatrix22 o_matrix, NyARDoublePoint2d o_ev, NyARDoublePoint2d o_mean) throws NyARException {
        double sx = 0.0;
        double sy = 0.0;
        int i = 0;
        while (i < i_number_of_data) {
            sx += i_x[i];
            sy += i_y[i];
            ++i;
        }
        sx /= (double)i_number_of_data;
        sy /= (double)i_number_of_data;
        double srow = Math.sqrt(i_number_of_data);
        double w10 = 0.0;
        double w11 = 0.0;
        double w00 = 0.0;
        int i2 = 0;
        while (i2 < i_number_of_data) {
            double x = (i_x[i2] - sx) / srow;
            double y = (i_y[i2] - sy) / srow;
            w00 += x * x;
            w10 += x * y;
            w11 += y * y;
            ++i2;
        }
        o_matrix.m00 = w00;
        o_matrix.m01 = o_matrix.m10 = w10;
        o_matrix.m11 = w11;
        NyARPca2d_MatrixPCA_O2.PCA_QRM(o_matrix, o_ev);
        if (o_ev.x < 1.0E-16) {
            o_ev.x = 0.0;
            o_matrix.m00 = 0.0;
            o_matrix.m01 = 0.0;
        }
        if (o_ev.y < 1.0E-16) {
            o_ev.y = 0.0;
            o_matrix.m10 = 0.0;
            o_matrix.m11 = 0.0;
        }
        o_mean.x = sx;
        o_mean.y = sy;
    }

    public void pca(double[] i_x, double[] i_y, int i_number_of_point, NyARDoubleMatrix22 o_evec, NyARDoublePoint2d o_ev, NyARDoublePoint2d o_mean) throws NyARException {
        this.PCA_PCA(i_x, i_y, i_number_of_point, o_evec, o_ev, o_mean);
        double sum = o_ev.x + o_ev.y;
        o_ev.x /= sum;
        o_ev.y /= sum;
    }
}

