/*============================================================================*
 *  FILE: 
 *     script.c
 *
 *  Description: 
 *     }NXNvg̓ǂݍ/o
 *
 *===========================================================================*/
#define SCRIPT_C
#include "local.h"

/*=========================================================================*/
/*   Function : readMacroDBData                                            */
/*                                                  }Nf[^̓ǂݏo */
/*=========================================================================*/
Err ReadMacroDBData(Char *dbName, UInt16 ver, UInt32 creator, UInt32 type,
                           UInt16 *cnt, UInt16 size, Char *dataPtr)
{
    Err              ret;
    UInt16           lp;
    NNshMacroRecord *lineData;
    DmOpenRef        dbRefR;

    *cnt = 0;
    if (dataPtr == NULL)
    {
        // obt@i[̈悪ȂAI[vs
        return (~errNone);
    }

    // f[^x[XJ(XNvgt@C)
    OpenDB_wCreator(dbName, ver, creator, type, false, &dbRefR);
    if (dbRefR == 0)
    {
        // G[AI
        return (~errNone);
    }

    // XNvg̃R[hmF
    GetDBCount_NNsh(dbRefR, cnt);

    // i[̈zƂ́Aobt@TCY܂łɂ
    if (*cnt > size)
    {
        *cnt = size;
    }

    // f[^̏
    lineData = (NNshMacroRecord *) dataPtr;
 
    // Of[^̃obt@ւ̓ǂݍ
    for (lp = 0; lp < *cnt; lp++)
    {
        // R[hǂݏo
        ret = GetRecord_NNsh(dbRefR, lp, sizeof(NNshMacroRecord), &lineData[lp]);
        if (ret != errNone)
        {
            // R[hǂݏosAf[^NAĎR[h
            MemSet(&lineData[lp], sizeof(NNshMacroRecord), 0x00);
        }
    }

    // Ƃ܂
    CloseDatabase_NNsh(dbRefR);
    return (errNone);
}

/*=========================================================================*/
/*   Function : WriteMacroDBData                                           */
/*                                                  }Nf[^̏o */
/*=========================================================================*/
Err WriteMacroDBData(Char *dbName, UInt16 ver, UInt32 creator, UInt32 type, 
                                                   UInt16 cnt, Char *dataPtr)
{
    UInt16           lp;
    DmOpenRef        dbRefW;
    NNshMacroRecord *lineData;

    // f[^x[XVKɊJ
    OpenDB_wCreator(dbName, ver, creator, type, true, &dbRefW);
    if (dbRefW == 0)
    {
        // G[AI
        return (~errNone);
    }

    // f[^̏
    lineData = (NNshMacroRecord *) dataPtr;
 
    // Of[^̃obt@ւ̓ǂݍ
    for (lp = 0; lp < cnt; lp++)
    {
        // R[ho
        lineData[lp].seqNum = lp + 1;
        (void) EntryRecord_NNsh(dbRefW, sizeof(NNshMacroRecord), &lineData[lp]);
    }

    // R[h̕בւ{
    QsortRecord_NNsh(dbRefW, NNSH_KEYTYPE_UINT16, 0);

    // Ƃ܂
    CloseDatabase_NNsh(dbRefW);
    return (errNone);
}

/*=========================================================================*/
/*   Function : AllocateMacroDBData                                        */
/*                                                      }Nf[^̊m */
/*=========================================================================*/
Char *AllocateMacroDBData(UInt16 len)
{
    Char *dataPtr;

    // f[^̏
    dataPtr = MemPtrNew_NNsh(sizeof(NNshMacroRecord) * len + MARGIN);
    if (dataPtr == NULL)
    {
        // mۃG[AI
        return (NULL);
    }
    MemSet(dataPtr, (sizeof(NNshMacroRecord) * len + MARGIN), 0x00);

    return (dataPtr);
}

/*=========================================================================*/
/*   Function : ReleaseMacroDBData                                         */
/*                                              mۂ}Nf[^̊J */
/*=========================================================================*/
void ReleaseMacroDBData(Char *dataPtr)
{
    if (dataPtr != NULL)
    {
        MemPtrFree(dataPtr);
    }
    return;
}
