//******************************************************************
//
//	MMC File Select and Bootloader for "LED Game for AVR"
//
//	2007.2.4	KAWAKAMI Yukio
//	2007.2.8	J[h CS̃|[g PC3ɕύX
//	2007.2.9	t@Cԍhbg̈ʒuŕ\
//	2007.2.15	MMCǂݍ݃[`œKEt@CpJiΉ
//******************************************************************

typedef	unsigned char	uchar;
typedef	unsigned int	uint;
typedef	unsigned long	ulong;
typedef unsigned short	ushort;

struct FDATE {
	unsigned short	ft_day	 : 5;
	unsigned short	ft_month : 4;
	unsigned short	ft_year	 : 7;
};

struct FTIME {
	unsigned short	ft_sec	: 5;
	unsigned short	ft_min	: 6;
	unsigned short	ft_hour	: 5;
};

struct DIRECTORY {
	uchar	filename[8];
	uchar	ext[3];
	uchar	att;
	uchar	not_use[10];
	struct FTIME	time;
	struct FDATE	date;
	unsigned short	cluster;
	ulong	size;
};

struct FILE_DATA {
	ulong	sec;
	uint	sc;
	uint	cluster;
	ushort	size;
	ushort	p;
};

#define		FAT12		1
#define		FAT16		2

#define		ON	1
#define		OFF	0
#define		TRUE	1
#define		FALSE	0

#define		NOP		asm volatile("nop\n"::)
#define		WDR		asm volatile("wdr\n"::)


#define SOFTSPI	1	// software SPI control 

#define MMC_PORT PORTB
#define MMC_PIN  PINB
#define MMC_DDR  DDRB

#define		MMC_MISO	4	// PORTB
#define		MMC_MOSI	3
#define		MMC_SCK		5

// MMC CSM蓖
#define		MMC_CS_PORT	PORTC
#define		MMC_CS_DDR	DDRC
#define		MMC_CS		3

#define		MMC_CS_ON	MMC_CS_PORT &= ~(1<<MMC_CS)
#define		MMC_CS_OFF	MMC_CS_PORT |= (1<<MMC_CS)



void cls(void);
void led_putch(unsigned char ch);
unsigned char getkey(void);
void print(char *str);

uchar SPI_in(void);
void SPI_out(uchar data);
uchar SPI_command(uchar com, ulong arg);

uchar read_VFAT_info(void);
uchar read_32(ulong addr, uchar *buff);

uchar mmc_read(ulong addr);
uchar mmc_init(void);

ulong cluster_to_adrs(uint cluster);
uint next_cluster(uint c);
uint read_word(ulong addr);

void open_file(struct DIRECTORY *dir, struct FILE_DATA *fd);
void next_sector(struct FILE_DATA *fd);
uchar check_file(struct DIRECTORY *dir);
int search_file(struct DIRECTORY *dir, int max);

int main(void);

void start_game(void);
uchar spm_main(struct FILE_DATA *fd);

