//video out

// PWM@\g킸Ƀ^C}荞݂ŃrfIo͂s

// http://www7.big.jp/~kerokero/avr/


#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/sleep.h>

//#include <avr/pgmspace.h>

//--------------------------------------
#define BYTE unsigned char
#define WORD unsigned short

//---------------------------------------------------------------------
//   h^ns`
//---------------------------------------------------------------------

struct PC{
	char :1;          // bit0
	char :1;          // bit1
	char VID_SYNC:1;  // bit2 rfIsyncM
	char VID_DOT:1;   // bit3 rfIdotM
	char :1;
	char :1;
	char :1;
	char :1;
};

#define pic (*(volatile struct PC*)&PINC)
#define pdc (*(volatile struct PC*)&DDRC)
#define poc (*(volatile struct PC*)&PORTC)


//NbNXs[hmenuProject - ConfigrationŐݒς
#ifndef F_CPU
	#define F_CPU 8000000	// CPUNbNg[Hz]
#endif
#define FREQ_H 15750	// horizontal frequency[Hz]


///////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////// rfIM
///////////////////////////////////////////////////////////////////////////
extern unsigned int ledvram[16*2];

int linesync=0;
char flagodd=0;
BYTE tick=0;


#define DOTH 10			//1pixel̃TCY[line]
#define VIDEOHEIGHT 16	//screen height[pixel]

void idle(void)
{
	sleep_mode();			//X[vJn...
}

BYTE tickback=0;

void video_vsync(void)
{
//	char i=60;
//	tickback = tick;
//	while(i--){
		while(tick == tickback){
			idle();
		}
		tickback = tick;
//	};
}

///////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////// 荞ݏ
// 1sec/15750Hz =  63.49...usec
// (1sec/60) / (1sec/15750) = 262.5

//   1`9:M
//       1`3OupX
//       4`6pX
//       7`9upX
//   10`21:eXgMȂ

#define SYNCSTA (0x10000-(F_CPU / FREQ_H))
#define OFFSETV 30

SIGNAL(SIG_OUTPUT_COMPARE1A)
{
	poc.VID_SYNC = 0;

	linesync++;
	if(linesync < OFFSETV){

		if(linesync < 7){	//(line001-line006)
			while(TCNT1 < (WORD)((F_CPU / FREQ_H)-20));

			poc.VID_SYNC = 1;
			return;
		}else{
			while(TCNT1L < (BYTE)(F_CPU / 160000));
			poc.VID_SYNC = 1;
			return;
		}
	}
	//line022-

		unsigned int temp;
		char dotcnt=16;
		BYTE row;

		while(TCNT1L < (BYTE)(F_CPU / 160000));
		poc.VID_SYNC = 1;

		row = (BYTE)(linesync - OFFSETV) / DOTH;

		if(row >= VIDEOHEIGHT){
			if(linesync == (262+flagodd)){	//262 or 263line1t[
				linesync = 0;
				flagodd ^= 1;
				tick++;
			}
			return;
		}
		temp = ledvram[row];

		while(TCNT1L < (BYTE)160);

		while(dotcnt--){
			poc.VID_DOT = ((temp & 0x8000)!=0);

			asm("nop");
			temp <<= 1;
		}
		poc.VID_DOT = 0;
	return;
}


////////////////////////////////////////////////////
/////////////////////////// 
////////////////////////////////////////////////////

void video_init(void)
{
	TCCR1A = (0<<WGM11)|(0<<WGM10);    //
	TCCR1B = (0<<WGM13)|(1<<WGM12)|1;  //1
	OCR1A = (F_CPU / 15750)-8; // 1secƂ̔rv荞ݐ

	TIMSK1 |= (1<<OCIE1A);

    TIFR1 |= (1 << OCF1A);    // tONA

	/// |[go
	pdc.VID_SYNC = 1;
	pdc.VID_DOT = 1;
}

/////////////////////////////////////////////////////

