//---------------------------------------------------------------------
//(16x16Dot)LED Game for AVR
// by Takuya Matsubara / NICO Corp. 2006-2008
// http://www.nicotak.com/avr/
//
// PACPAC
// E㉺EXCb`ŃXN[
//
// PWM@\g킸Ƀ^C}荞݂ŃrfIo͂s
// OUK{
//---------------------------------------------------------------------
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include "led.h"
#include "ledx.h"
#include "beep.h"
#include "sw.h"
#include "rand.h"
#include "video.h"


#define EXP_MAX 10	//p^[MAX
#define SPSIZE 3	// chara size[pixel]

char pat_myclose[]={
	0b010,
	0b111,
	0b010
};

char pat_myopen[4][SPSIZE]={
	{
		0b101,
		0b101,
		0b010
	},{
		0b011,
		0b100,
		0b011
	},{
		0b010,
		0b101,
		0b101
	},{
		0b110,
		0b001,
		0b110
	}
};


char pat_mydead[5][SPSIZE]={
	{
		0b101,
		0b101,
		0b010
	},{
		0b000,
		0b101,
		0b010
	},{
		0b000,
		0b000,
		0b010
	},{
		0b101,
		0b000,
		0b101
	},{
		0b000,
		0b000,
		0b000
	}
};


char pat_monster[4][SPSIZE]={
	{
		0b010,
		0b111,
		0b111
	},{
		0b011,
		0b110,
		0b111
	},{
		0b010,
		0b101,
		0b111
	},{
		0b110,
		0b011,
		0b111
	}
};

char pat_power[]={
	0b010,
	0b111,
	0b010
};

#define LAYER_MAX 2

unsigned long vmap[LAYER_MAX][29]=
{
	{
   //0123456789abcdef0123456789abcdef
	0b11111111111111111111111111111000,		//0
	0b10000000000000000000000000001000,		//1
	0b10000000000000000000000000001000,		//2
	0b10000000000000000000000000001000,		//3
	0b10001111111110001111111110001000,		//4
	0b10000000000000000000000000001000,		//5
	0b10000000000000000000000000001000,		//6
	0b10000000000000000000000000001000,		//7
	0b10001000111111111111100010001000,		//8
	0b10001000000000000000000010001000,		//9
	0b10001000000000000000000010001000,		//10
	0b10001000000000000000000010001000,		//11
	0b10001111100010001000111110001000,		//12
	0b10000000000010001000000000001000,		//13
	0b10000000000010001000000000001000,		//14
	0b10000000000010001000000000001000,		//15
	0b10001111100011111000111110001000,		//16
	0b10000000000000000000000000001000,		//17
	0b10000000000000000010000000001000,		//18
	0b10000000000000000000000000001000,		//19
	0b10001000111110001111100010001000,		//20
	0b10001000000000000000000010001000,		//21
	0b10001000000000000000000010001000,		//22
	0b10001000000000000000000010001000,		//23
	0b10001111111110001111111110001000,		//24
	0b10000000000000000000000000001000,		//25
	0b10000000000000000000000000001000,		//26
	0b10000000000000000000000000001000,		//27
	0b11111111111111111111111111111000		//28
	},{
	}
};


typedef struct {
	char x1;	// X
	char y1;	// Y
} ST_IDO;   // \

ST_IDO delta2[4]={
	{ 0,-2},  /**/
	{ 2, 0},  /*E*/
	{ 0, 2},  /**/
	{-2, 0}   /**/
};

ST_IDO delta[4]={
	{ 0,-1},  /**/
	{ 1, 0},  /*E*/
	{ 0, 1},  /**/
	{-1, 0}   /**/
};

#define IDO_UP    0
#define IDO_RIGHT 1
#define IDO_DOWN  2
#define IDO_LEFT  3

PROGMEM unsigned int bindat[]={
0x0000,   /* RED 00 LED game*/
0x4760,   /* RED 01 */
0x4450,   /* RED 02 */
0x4750,   /* RED 03 */
0x4450,   /* RED 04 */
0x7760,   /* RED 05 */
0x0000,   /* RED 06 */
0x0000,   /* RED 07 */
0x0000,   /* RED 08 */
0x64ae,   /* RED 09 */
0x8ae8,   /* RED 10 */
0xaaae,   /* RED 11 */
0xaea8,   /* RED 12 */
0x6aae,   /* RED 13 */
0x0000,   /* RED 14 */
0x0000,   /* RED 15 */
0x0000,   /*  */
0x0000,   /*  */
0x0000,   /*  */
0x0000,   /*  */
0x0000,   /*  */
0x0000,   /*  */
0x0000,   /*  */
0x0000,   /*  */
0x0000,   /*  */
0x0000,   /*  */
0x0000,   /*  */
0x0000,   /*  */
0x0000,   /*  */
0x0000,   /*  */
0x0000,   /*  */
0x0000,   /*  */
};

void led_printd(int x);
void led_print(char *p);
void led_disploop(int i);

void led_disploop(int i)
{
	while(i--){
		video_vsync();
	}
}

void dispscroll(int page)
{
	unsigned int vmap2[16];
	unsigned int i,j;
	PGM_P p= (PGM_P)bindat;

	p += page*32;

	for(i=0; i<16; i++){
		vmap2[i] = pgm_read_word(p);
		p+=2;
	}

	led_scroll(1,0);
	led_disploop(60);
	for(j=0; j<16; j++){
		led_scroll(1,0);
		for(i=0; i<16; i++){
			if(vmap2[i] & (0x8000 >> j))
				led_pset(15,i,1);
		}
		led_disploop(60);
	}
}

//---------------------------------------------------------------------
void led_printd(int x)
{
	unsigned char temp;
	int ketaval=1000;

	while (ketaval != 0) {
		temp = x / ketaval;
		led_putch('0'+temp);
		x -= (ketaval*temp);
		ketaval /= 10;
	}
}

//---------------------------------------------------------------------
void led_print(char *p)
{
	while(*p != 0){
		led_putch(*p++);
	}
}

//---------------------------------------------------------------------
//void beep_str(char *str)
//{
//	int hz;
//
//	while(*str != 0){
//		hz = (*str - 'A')*50 + 150;
//		beep_set(hz,1);
//		while(beep_getcnt()){
//			led_disp();
//		}
//		str++;
//	}
//}

char fnc_abs(char a)
{
	if(a < 0){
		return(-a);
	}else{
		return(a);
	}
}

unsigned int *pVram;	//
char sx,sy;				//XN[WBʂ̍

//---------------------------------------------------------------------
// 3x3pixel̃LN^[\
// x:XW(L̒S̍W)
// y:YW(L̒S̍W)
// *dat:p^[Bchar^|C^
void led_spput(char x,char y, char *dat,char color)
{
	char i;
	unsigned int temp;

	x-=sx;
	y-=sy;
	x--;
	y--;
	for(i=0; i<SPSIZE; i++){
		if((y>=0)&&(y<=15)){		
			if(x >= 0)
				temp = (((unsigned int)*dat << (16-SPSIZE)) >> x);
			else
				temp = (((unsigned int)*dat << (16-SPSIZE)) << (-x));

			if(color & 1){ *(pVram+y   ) |= temp; }
			if(color & 2){ *(pVram+y+16) |= temp; }
		}
		y++;
		dat++;
	}
}


//---------------------------------------------------------------------
char vmap_point(int dx,int dy)
{
	if(vmap[0][dy] & (0x80000000 >> dx))
		return(1);

	return(0);
}

typedef struct {
	char x;		// XW
	char y;		// YW
	int ido;	// 
	char flag;
} ST_MONSTER;   // \

void monster_init(ST_MONSTER *pMon)
{
	pMon->x = 3*4+2;
	pMon->y = 3*4+2;
	pMon->ido = IDO_UP;
	pMon->flag = 0;
}

//---------------------------------------------------------------------
void vmap_pset(int dx, int dy, char dot)
{
	if(dot){
		vmap[0][dy] |= (0x80000000 >> dx);
		vmap[1][dy] |= (0x80000000 >> dx);
	}else{
		vmap[0][dy] &= ~(0x80000000 >> dx);
		vmap[1][dy] &= ~(0x80000000 >> dx);
	}
}

#define SCRLLIMIT 7
#define SCRLX2	(29-16)

#define ENDFLAG_IDLE     0
#define ENDFLAG_GAMEOVER 1
#define ENDFLAG_NEXT     2

void vmap_print(char x,char y)
{
	int i;

	//----------XN[vC[ɒǏ]
	if ((x-sx) < SCRLLIMIT) {	// 
		if(sx>0)sx--;
	}else if ((x-sx) > (15-SCRLLIMIT)) {	// 
		if(sx<SCRLX2)sx++;
	}
	if ((y-sy) < SCRLLIMIT) {	// 
		if(sy>0)sy--;
	}else if ((y-sy) > (15-SCRLLIMIT)) {	// 
		if(sy<SCRLX2)sy++;
	}

	//}bvVRAM̗ΐFLED̈փRs[
	//ԐFLED̈̓NA
	for(i=0; i<16; i++){
		*(pVram+i   ) = (vmap[0][i+sy] >> (16-sx))& 0xffff;
		*(pVram+i+16) = (vmap[1][i+sy] >> (16-sx))& 0xffff;
	}
}

//---------------------------------------------------------------------
// C
int main(void)
{
	#define CHANGECNT 5	// CHANGE
	#define MONSTER_MAX 2	// X^[ő吔

	ST_MONSTER mon[MONSTER_MAX];
	ST_MONSTER *pMon;

	unsigned int  keycnt;
	char tx,ty;
	char x,y;
	char movecnt;
	char startcnt;	//Q[JnJE^(0ȏゾƃX^[g)
	char endflag;	//ItO
	char powerflag;	//p[GTtO
	int myido,tido;
	int i,j;
	char dotcnt;
	char powercnt;
	char stage;
	int score;

	sw_init(SW_ALL);	//XCb`
	led_init();
	led_off();
	rand_init();
	beep_init();
	video_init();

	pVram = led_getvram();

	sei();
//	dispscroll(0);
//	dispscroll(1);

	movecnt=0;

	stage=1;
	score=0;
	while(1){
		led_init();
		led_locate(0,0);
		led_print("STG.");
		led_printd(stage);
		led_disploop(120);

		sx= 8;	//XN[W
		sy= 0;
		x = 3*4+2;	//vC[LW
		y = 4*4+2;
		myido = IDO_LEFT;
		powerflag = 0b1111;
		powercnt = 0;

		//--------}bvɃhbgzu	
		dotcnt=0;
		for(j=0; j<7; j++){
			for(i=0; i<7; i++){
				if((i==3)&&(j==3)){
				}else{
					vmap_pset(i*4+2, j*4+2, 1);			
					dotcnt++;
				}
			}
		}

		//-------X^[̏
		pMon = &mon[0];
		for(i=0; i<MONSTER_MAX; i++){
			monster_init(pMon++);
		}

		endflag = ENDFLAG_IDLE;
		startcnt=20;
		beep_set(500,10);
		while(endflag==ENDFLAG_IDLE){
			video_vsync();

			keycnt++;
			if(keycnt < CHANGECNT) continue;
			keycnt=0;

			//}bvVRAMփRs[
			vmap_print(x,y);

			if(startcnt > 0){	//-------
				startcnt--;
				led_spput(x, y, pat_myclose,3);	//close
				continue;
			}

			//---------------vC[L
			if(((x & 0b11)==2)&&((y & 0b11)==2)){	//H
				j = -1;
				if (sw_get(SW_RIGHT)) {	// RXCb`
					j = IDO_RIGHT;
				}else if (sw_get(SW_LEFT)) {	// LXCb`
					j = IDO_LEFT;
				}else if (sw_get(SW_DOWN)) {	// DXCb`
					j = IDO_DOWN;
				}else if (sw_get(SW_UP)) {	// UXCb`
					j = IDO_UP;
				}

				if(j != -1){
					if(vmap_point(x+delta2[j].x1, y+delta2[j].y1)==0){
						myido = j;
					}
				}
				if(vmap_point(x+delta2[myido].x1, y+delta2[myido].y1)==0){
					x += delta[myido].x1;
					y += delta[myido].y1;
				}
			}else{
				x += delta[myido].x1;
				y += delta[myido].y1;
				if(vmap_point(x,y)){	// hbgHׂ
					beep_set(200,1);
					vmap_pset(x, y, 0);	//}bvhbg
					score++;
					dotcnt--;
					if(dotcnt==0){
						endflag=ENDFLAG_NEXT;
					}
				}
			}

			movecnt = (movecnt+1) & 0b11;
			//--------------vC[L\
			if(movecnt & 0b10)
				led_spput(x, y, pat_myopen[myido],3);	//open
			else
				led_spput(x, y, pat_myclose,3);	//close

			//-------------p[GT
			if(movecnt & 0b10){
				for(i=0;i<4;i++){
					if((powerflag &(1<<i))==0)continue;
					tx = (i & 1)*24+2;
					ty = (i >> 1)*24+2;
					led_spput(tx, ty, pat_power,3);	//
					if((fnc_abs(x-tx)<3)&&(fnc_abs(y-ty)<3)){
						powercnt=35;	//GTJEg
						powerflag &= ~(1<<i);

						for(j=0; j<MONSTER_MAX; j++){
							mon[j].flag=1;
						}
						break;
					}
				}
				if(powercnt){	//p[GT擾
					beep_set(444,1);
					powercnt--;
					if(powercnt==0){
						for(j=0; j<MONSTER_MAX; j++){
							mon[j].flag=0;
						}
					}
				}
			}

			//---------X^[
			pMon = &mon[0];
			for(i=0; i<MONSTER_MAX; i++){
				tx = pMon->x;
				ty = pMon->y;
				tido = pMon->ido;
				if(((tx & 0b11)==2)&&((ty & 0b11)==2)){	//H
					if(rand_get(3)){
					}else{	//----------ǐ
						if(rand_get(2)){
							if(tx > x)
								tido= IDO_LEFT;
							else
								tido = IDO_RIGHT;
						}else{
							if(ty > y)
								tido = IDO_UP;
							else
								tido = IDO_DOWN;
						}
					}
					if(pMon->flag){				//p[GTƓ
						tido =(tido+2)& 0b11;	//180x]
					}
					if(vmap_point(tx+delta2[tido].x1, ty+delta2[tido].y1)==0){//O
						tx += delta[tido].x1;
						ty += delta[tido].y1;
					}else{
						if(rand_get(2)){
							tido++;
							if(tido > 3) tido=0;
						}else{
							tido--;
							if(tido < 0) tido=3;
						}
					}
					pMon->ido = tido;
				}else{
					tx += delta[tido].x1;
					ty += delta[tido].y1;
				}
				pMon->x = tx;
				pMon->y = ty;
				led_spput(tx, ty, pat_monster[tido],pMon->flag+1);	//

				if((fnc_abs(x-tx)<3)&&(fnc_abs(y-ty)<3)){	//vC[ƓGڐG
					if(pMon->flag){
						monster_init(pMon);	//X^[
						for(j=0; j<10; j++){
							beep_set(150+j*100,1);
							led_disploop(120);
						}
						score+=50;
					}else{
						endflag=ENDFLAG_GAMEOVER;
					}
				}
				pMon++;
			}
		}

		if(endflag==ENDFLAG_GAMEOVER){
			for(j=0; j<5; j++){
				led_init();
				vmap_print(x,y);	//}bvVRAMփRs[
				beep_set(550-j*100,2);
				led_spput(x, y, pat_mydead[j],3);
				led_disploop(40);
			}
			led_init();
			led_locate(0,4);
			led_printd(score);
			led_disploop(100);

			score=0;
			stage=1;
		}else{
			for(j=0;j<8;j++){
				for(i=0;i<16;i++){
					*(pVram+i) ^= 0xffff;
				}
				led_disploop(40);
			}
			stage++;
		}
	}
}


