//---------------------------------------------------------------------
//(16x16Dot)LED Game for AVR  by Takuya Matsubara / NICO Corp. 2006
// http://www.nicotak.com/avr/
//
//  ISPpVAʐM֐
//
//---------------------------------------------------------------------
#include <avr/io.h>
#include "sio.h"

#define BAUDRATE 9600        //{[[g

#ifndef F_CPU
#define   F_CPU   8000000    //CPUNbNg 8MHz
#endif

#define  PRESCALE   1        //vXP[l
#define  PRESCALECR 1        //vXP[ݒl
#define  SIO_PORT PORTB      //ISPp|[g
#define  SIO_PIN  PINB       //ISPp|[g
#define  SIO_DDR  DDRB       //ISPp|[go͐ݒ
#define  SIO_TX   4          //Mrbg
#define  SIO_RX   3          //Mrbg
#define  SIO_TIFR    TIFR1   //^C}1tO
#define  SIO_MAXCNT  0x10000 //^C}ől

#define SIO_TCNT    ((F_CPU/PRESCALE)/BAUDRATE)

//-----------------------------------------------------------------------
// VA|[g
// E^C}1gp܂B̃vOŃ^C}1gpĂƎg܂B
// EISPRlN^̃|[gݒ肵܂B
void sio_init(void)
{
    SIO_DDR |=  (1<<SIO_TX);
    SIO_DDR &= ~(1<<SIO_RX);
    SIO_PORT &= ~(1<<SIO_TX);
    SIO_PORT |= (1<<SIO_RX);

    TCCR1A= 0;                // ^C}1 [h 
    TCCR1B= PRESCALECR;       // ^C}1 vXP[ݒ
}


//-----------------------------------------------------------------------
// 1bitEGCg
void sio_bitwait(void)
{
    while(!(SIO_TIFR & (1 << TOV1)));
    // TOV1rbg1ɂȂ܂

    TCNT1 = SIO_MAXCNT-SIO_TCNT;
    SIO_TIFR |= (1 << TOV1);  // TIFR̃rbgNA
}

//-----------------------------------------------------------------------
// 1oCgM
// sio_txdatFMf[^0x00-0xff
int sio_tx(char sio_txdat)
{
    unsigned char mask = 0x01;

    //X^[grbg
    SIO_PORT |= (1<<SIO_TX);
    TCNT1 = SIO_MAXCNT-SIO_TCNT;
    SIO_TIFR |= (1 << TOV1);  // TIFR̃rbgNA
    sio_bitwait();

    //f[^rbg0-7
    while(mask != 0){    
        if(sio_txdat & mask)
            SIO_PORT &= ~(1<<SIO_TX);
        else
            SIO_PORT |= (1<<SIO_TX);

        mask = mask<<1;
        sio_bitwait();
    }
    //Xgbvrbg
    SIO_PORT &= ~(1<<SIO_TX);
    sio_bitwait();
    return(0);
}

//-----------------------------------------------------------------------
// 1oCgM
// ߂l: Mf[^0x00`0xFF / 0xFFFF(-1)̏ꍇ̓^CAEgG[
int sio_rx(void)
{
    #define TIMEOUT 30000
    int timeo;
    unsigned char sio_rxdat;
    unsigned char mask = 0x01;

    for(timeo=0; timeo<TIMEOUT; timeo++)
    {    
        if(SIO_PIN & (1<<SIO_RX)){  //X^[grbgo
               TCNT1 = SIO_MAXCNT-(SIO_TCNT/2);
            SIO_TIFR |= (1 << TOV1);  // TIFR̃rbgNA
            break;
        }
    }
    if(timeo>=TIMEOUT)return(-1);

    //X^[grbg ǂݔ΂
    sio_bitwait();

    //f[^rbg0-7
    sio_rxdat=0;
    while(mask != 0){    
        sio_bitwait();

        if((SIO_PIN & (1<<SIO_RX))==0)
            sio_rxdat |= mask;

        mask = mask<<1;
    }

    sio_bitwait();    //Xgbvrbgǂݔ΂

    return((int)sio_rxdat);
}

//-----------------------------------------------------------------------
// 񑗐M
// *strF̃|C^BI[NULL(0)
void sio_txstr(char *str)
{
    while(*str != 0)
    {
        sio_tx(*str++);
    }
}
