package jp.co.newral.workmgr.web.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.newral.workmgr.common.bean.UsrVO;
import jp.co.newral.workmgr.service.bean.UsrBean;
import jp.co.newral.workmgr.service.blogic.MgrDateChangeConfirmBLogic;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction;

/**
 * ЈύXmFANVB
 *
 * ЈύXmFrWlXWbNĂсAЈύXmFʂ\B
 * (ύX͉ʂœ͂ꂽʏɕ\̂)
 */
public class MgrDateChangeConfirmAction extends AbstractBLogicAction<UsrBean> {

	/**
     * ONXB
     */
    private static Log log = LogFactory.getLog(AbstractBLogicAction.class);

    
	/**
     * srWlXWbNNXB
     */
    private MgrDateChangeConfirmBLogic mgrDateChangeConfirmBLogic = null;

    /**
     * rWlXWbNԋpB
     *
     * @return ێrWlXWbN
     */
    public MgrDateChangeConfirmBLogic getMgrDateChangeConfirmBLogic() {
        return mgrDateChangeConfirmBLogic;
    }

    /**
     * rWlXWbNݒ肷B
     *
     * @param mgrDateChangeConfirmBLogic rWlXWbN
     */
    public void setMgrDateChangeConfirmBLogic(MgrDateChangeConfirmBLogic mgrDateChangeConfirmBLogic) {
        this.mgrDateChangeConfirmBLogic = mgrDateChangeConfirmBLogic;
    }

    /**
     * [AhXDBo^pɕҏW
     * ( [AhX    "@newral.co.jp" ǉ)
     * ( [AhX  ""              )
     *
     * @param   mailAddressPram : ύXʂœ͂ꂽ[AhX
     * @return  mailAddress     : "@newral.co.jp" ǋL[AhX or ""
     */
    public String mailAddressFormat(String mailAddressPram) {
        
    	String mailAddress;    	
    	int length     = mailAddressPram.length();
    	
    	//----------------------------------------------//
    	// ύXʂŃ[AhX͂Ăꍇ //
    	//----------------------------------------------//
    	if(length > 1) {
            //͂ꂽύX[AhX "@newral.co.jp" ǉ
    		mailAddress = mailAddressPram + "@newral.co.jp";
    	
    	//------------------------------------------------//
        // ύXʂŃ[AhX͂ĂȂꍇ //
        //------------------------------------------------//	
    	}else{	
    		// ftHg
    		mailAddress = "";
    	}
    	return mailAddress;
    }

    
    /**
     * rWlXWbNsAЈo^擾AԋpB
     *
     * @param usrBean Јo^擾̂߂̕ϐێUsrBean
     * @return Јo^ێBLogicResult
     * @throws Exception O
     */
    @Override

    public BLogicResult doExecuteBLogic(UsrBean usrBean)
        throws Exception {

        log.debug("MgrDateChangeConfirmAction IN");
        
        //͂ꂽύX[AhX "@newral.co.jp" ǉ
        usrBean.setChangeMailAddress(mailAddressFormat(usrBean.getChangeMailAddress()));
        
        //ގДN̒lȂƂ̏
    	String OutCompanyYhm = usrBean.getChangeOutCompanyYhm();
        int len = OutCompanyYhm.length();
    	if(len != 8){
        	usrBean.setChangeOutCompanyYhm("-");
        }
    	//ύX\IDԍ(selectId)staffId֑
        usrBean.setStaffId(usrBean.getSelectId());
        
        //BLogicResult̐Aʂ̐ݒ
        BLogicResult result = new BLogicResult();
        
        
        //rWlXWbN̎sAʂ̎擾
        UsrVO uvo = usrBean.getUvo();
        UsrBean usrBeanBuf = usrBean;
        
        result.setResultString("success");
        result.setResultObject(usrBeanBuf);
        BLogicMessages messages = new BLogicMessages();
        messages.add("mgr.message",
                new BLogicMessage("mgr.message", uvo.getStaffName()));
        result.setMessages(messages);        
        
        
        log.debug("MgrDateChangeConfirmAction OUT");

        return result;
    }

}
