/*
* Copyright (c) 2007 NTT DATA Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package jp.co.newral.workmgr.common.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
* NGXgp[^̃GR[fBOݒsB
* <p/>
* ServletAPIo[W2.3ȏɂėLB<br>
*/
public class SetCharacterEncodingFilter implements Filter {

	/** Oo(ύX) */
	private Log log = LogFactory.getLog(SetCharacterEncodingFilter.class);
	
	/**
	* GR[fBOB
	*/
	protected String encoding = null;

	/**
	* tB^[RtBOB
	*/
	protected FilterConfig filterConfig = null;

	/**
	* NCAgŎw肳ꂽGR[fBO𖳎邩ǂ̃tOB
	*/
	protected boolean ignore = true;

	/**
	* IB
	*/
	public void destroy() {
		this.encoding = null;
		this.filterConfig = null;
	}

	/**
	* tB^[
	* NGXgp[^w肳ꂽGR[fBOɐݒ肷B
	*
	* @param request NGXg
	* @param response X|X
	* @param chain tB^[`F[
	* @exception IOException IOO
	* @exception ServletException O
	*/
	public void doFilter(ServletRequest request, ServletResponse response,
		FilterChain chain) throws IOException, ServletException {
		log.debug("doFilter_IN");	/* (ύX) */

			if (ignore || (request.getCharacterEncoding() == null)) {
			String encoding = selectEncoding(request);
			if (encoding != null) {
				request.setCharacterEncoding(encoding);
			}
		}
		chain.doFilter(request, response);
		log.debug("doFilter_OUT(OK)");	/* (ύX) */
	}

	/**
	* B
	*
	* @param filterConfig tB^[ݒ
	* @exception ServletException O
	*/
	public void init(FilterConfig filterConfig) throws ServletException {
		log.debug("init_IN");	/* (ύX) */

		this.filterConfig = filterConfig;
		this.encoding = filterConfig.getInitParameter("encoding");

		String value = filterConfig.getInitParameter("ignore");
		if (value == null) {
			this.ignore = true;
		} else if (value.equalsIgnoreCase("true")) {
			this.ignore = true;
		} else if (value.equalsIgnoreCase("yes")) {
			this.ignore = true;
		} else {
			this.ignore = false;
		}
		log.debug("init_OUT(OK)");	/* (ύX)  */
	}

	/**
	* GR[fBOIB
	*
	* @param request NGXg
	* @return GR[fBO
	*/
	protected String selectEncoding(ServletRequest request) {
		return this.encoding;
	}
}
