package jp.co.newral.workmgr.common.filter;

import java.util.List;
import java.util.ArrayList;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.newral.workmgr.common.bean.UsrVO;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.fw.web.thin.AuthorizationController;

/**
 * F؃`FbN(ANZX`FbN)sB
 *
 */

public class SampleAuthorizationController implements AuthorizationController {

	
	/** Oo(ύX) */
	private Log log = LogFactory.getLog(SampleAuthorizationController.class);	
    
    
    /**
     *  F؃`FbN(ANZX`FbN)sȂpX񃊃Xg擾L[B
     */
    private static final String AUTHENTICATED_NOCHECK_PATH_PREFIX
                                 = "access.control.authenticated.escape.";

    
    /**
     *  F؃`FbN(ANZX`FbN)sȂpX񃊃Xg擾L[B
     */
    private List<String> noCheckList = null;
 	

    /**
    * NGXg̃pXɑ΂āA
    * w肳ꂽHTTPZbVF؍ς݂ł邩ǂ𔻒肷B
    *
    * @param   pathInfo   pX
    * @param   req        HTTPNGXg
    *
    * @return  F؂ɐ true  (ANZXȂ)
    *           F؂Ɏs false (ANZX)
    */
    public boolean isAuthorized(String pathInfo, ServletRequest req) {

        //ZbV [UsrVO] , [managerFlag]擾B
        HttpSession session = ((HttpServletRequest) req).getSession();
        UsrVO uvo = (UsrVO) session.getAttribute("USER_VALUE_OBJECT");
        //log.debug("managerFlag = [" + uvo.getManagerFlag() + "]");
                

        //------------------------------------------------------------------------------------------//
        // Ǘ҂ł͂Ȃ[U[Ǘҗp̉ʂɃANZX悤Ƃꍇ̂݃ANZX //
        //------------------------------------------------------------------------------------------//
        String nextHedPath = pathInfo.substring(0,4);
        if(("/mgr".equals(nextHedPath)) && (uvo.getManagerFlag() != 1)){
            //log.debug("return false");
        	return false;
        }
        
        //log.debug("return true");
        return true;
    }


    /**
     * F؃`FbN(ANZX`FbN)KvsKv𔻒肷
     * 
     * @param   req       HTTPNGXg
     * 
     * @return@Kv    true
     *           sKv  false
     */
    public boolean isCheckRequired(ServletRequest req) {

//    	log.debug("ANZX`FbN");
    	//--------------------------------------------------------------//
    	// pX擾B                                       //
    	//   Eϐ[pathInfo] ɂ͎ɎgppX̕񂪓Ă  //
    	//      (: OCʂ  "/login.do" )                    // 
    	//--------------------------------------------------------------//
    	String pathInfo = RequestUtil.getPathInfo(req);
//        log.debug("pathInfo = [" + pathInfo + "]");

        if (noCheckList == null) {
        	noCheckList = new ArrayList<String>();
//            log.debug("noCheckList = [" + noCheckList + "]");

            for (int i = 1; ; i++) {
            	//-----------------------------------------------------------------------------//
            	// F؃`FbN(ANZX`FbN)sȂ񃊃Xg擾                //
            	// (ApplicationResources.properties t@CŎŒ`pX1擾) //
            	//-----------------------------------------------------------------------------//
            	String path = PropertyUtil.getProperty(AUTHENTICATED_NOCHECK_PATH_PREFIX + i);
//                log.debug("path = [" + path + "]");
                                
                if (path == null) {
                    break;
                }
                //------------------------------------------------------------------//
                // 擾F؃`FbN(ANZX`FbN)sȂ񃊃Xg //
                // 1o^                                                  //
                //------------------------------------------------------------------//
                noCheckList.add(path);
            }

        }
        
        for (String path : noCheckList) {
//        	log.debug("path        = [" + path + "]");
//        	log.debug("noCheckList = [" + noCheckList + "]");
            
        	//---------------------------------------------------//
        	// Rs[ł邩ǂ̔ (stringCopy()) //
        	//                                                   //
        	//     EɃRs[łꍇtrue ԋp     //
        	//     ERs[łȂꍇfalseԋp     //
        	//---------------------------------------------------//
        	String nextHedPath;
            if(stringCopy(pathInfo)){          	
            	//ɃRs[ł̂łnj
            	nextHedPath = pathInfo.substring(0,4);	
            }else{
            	//F؃`FbN(ANZX`FbN)肪svȏꍇ false ԋp  ʏ֖̏߂
            	return false;
            }
            
            //-----------------------------------------------------------------------------------------------------------------//
            // pathInfo.startsWith(path)  pathInfo  path 񂪎w肳ꂽŎn܂邩ǂ𒲂ׂ                  //
            //                              vȂ true, svȂ false                                                    //
            //                                                                                                                 //
            //             E[pathInfo]   ɎgppX̕                                                           //
            //             E[path]       F؃`FbN(ANZX`FbN)sȂ񃊃Xg(for[v1) //
            //-----------------------------------------------------------------------------------------------------------------//
//        	log.debug("pathInfo.startsWith(path) = [" + pathInfo.startsWith(path) + "]");
            if ( (pathInfo.startsWith(path)) ) {
            	
            	//-----------------------------------------------------------------------//
            	// "/mgr".equals(pathInfo)   "/" [pathInfo] ̕rsNX //
            	//                             vȂvȂ true, svȂ false   //
            	//                                                                       //
            	//            E[pathInfo]   ɎgppX̕                  //
            	//-----------------------------------------------------------------------//
            	if(!("/mgr".equals(nextHedPath)) || !("/usr".equals(nextHedPath))){
//                    log.debug("[/mgr].equals(pathInfo)      = [" + "/mgr".equals(pathInfo) + "]");
//                    log.debug("[/usr].equals(pathInfo)      = [" + "/usr".equals(pathInfo) + "]");
                	
                	//F؃`FbN(ANZX`FbN)肪svȏꍇ false ԋp  ʏ֖̏߂
                	return false;                	
                }
            	
            }
        }

        //F؃`FbN(ANZX`FbN)肪Kvȏꍇ true ԋp  isAuthorizedNX 
		return true;
    }	

    
    /**
     * 𐳏ɃRs[ł邩ǂ̔
     * G[tO̒g𔻒肵ĕԋpB
     *
     * @return  I   true
     *           O   false
     *          
     */
    public boolean stringCopy(String pathInfo) {
    		try{
    			//pathInfo.substring(0,4)  ϐ[pathInfo]  w蕶Rs[NXB(̏ꍇ0ځ`4ڂRs[)
    			String nextHedPath = pathInfo.substring(0,4);
    			return true;
    		}catch (Exception ex){
    			return false;
    		}
    }


}
