/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.AmbientLightRetained;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.EnvironmentSet;
import javax.media.j3d.J3dDebug;
import javax.media.j3d.LightRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.OrderedCollection;
import javax.media.j3d.PointLightRetained;
import javax.media.j3d.RenderBin;
import javax.media.j3d.VirtualUniverse;

class LightBin
implements ObjectUpdate {
    int maxLights = -1;
    LightRetained[] lights = null;
    int[] lightsRef = null;
    int numEmptySlots = -1;
    RenderBin renderBin = null;
    LightBin next = null;
    LightBin prev = null;
    EnvironmentSet environmentSetList = null;
    ArrayList insertEnvSet = new ArrayList();
    int canvasDirty = 0;
    int lightDirtyMaskCache = 0;
    int lightDirtyMask = 0;
    ArrayList pointLts = new ArrayList();
    int[] pointLtsSlotIndex;
    OrderedCollection orderedCollection = null;
    boolean onUpdateList = false;
    BackgroundRetained geometryBackground = null;

    LightBin(int n, RenderBin renderBin, boolean bl) {
        this.maxLights = n;
        this.numEmptySlots = n;
        this.lights = new LightRetained[n];
        this.lightsRef = new int[n];
        this.renderBin = renderBin;
    }

    void reset(boolean bl) {
        this.prev = null;
        this.next = null;
        this.orderedCollection = null;
        this.environmentSetList = null;
        this.onUpdateList = false;
        this.geometryBackground = null;
        if (J3dDebug.debug) {
            for (int i = 0; i < this.maxLights; ++i) {
                J3dDebug.doAssert(this.lights[i] == null, "lights[i] == null");
                J3dDebug.doAssert(this.lightsRef[i] == 0, "lightsRef[i] == 0");
            }
        }
    }

    void setOrderedInfo(OrderedCollection orderedCollection) {
        this.orderedCollection = orderedCollection;
    }

    boolean willEnvironmentSetFit(EnvironmentSet environmentSet) {
        int n;
        int n2 = n = environmentSet.lights.size();
        block0: for (int i = 0; i < n; ++i) {
            LightRetained lightRetained = (LightRetained)environmentSet.lights.get(i);
            if (lightRetained instanceof AmbientLightRetained) continue;
            for (int j = 0; j < this.maxLights; ++j) {
                if (this.lights[j] != lightRetained) continue;
                --n2;
                continue block0;
            }
        }
        return n2 <= this.numEmptySlots;
    }

    void addEnvironmentSet(EnvironmentSet environmentSet, RenderBin renderBin) {
        int n = environmentSet.lights.size();
        block0: for (int i = 0; i < n; ++i) {
            int n2;
            LightRetained lightRetained = (LightRetained)environmentSet.lights.get(i);
            if (lightRetained instanceof AmbientLightRetained) continue;
            for (n2 = 0; n2 < this.maxLights; ++n2) {
                if (this.lights[n2] != lightRetained) continue;
                if (lightRetained.lightOn) {
                    environmentSet.enableMask |= (long)(1 << n2);
                }
                int n3 = n2;
                this.lightsRef[n3] = this.lightsRef[n3] + 1;
                environmentSet.ltPos[i] = n2;
                break;
            }
            if (n2 != this.maxLights) continue;
            for (n2 = 0; n2 < this.maxLights; ++n2) {
                if (this.lights[n2] != null) continue;
                this.lights[n2] = lightRetained;
                this.lightsRef[n2] = 1;
                if (lightRetained instanceof PointLightRetained) {
                    this.pointLts.add(lightRetained);
                    int n4 = 0;
                    if (this.pointLtsSlotIndex != null) {
                        n4 = this.pointLtsSlotIndex.length;
                    }
                    if (n4 < this.pointLts.size()) {
                        int[] nArray = new int[n4 + 8];
                        for (int j = 0; j < n4; ++j) {
                            nArray[j] = this.pointLtsSlotIndex[j];
                        }
                        this.pointLtsSlotIndex = nArray;
                    }
                    this.pointLtsSlotIndex[this.pointLts.size() - 1] = n2;
                }
                if (lightRetained.lightOn) {
                    environmentSet.enableMask |= (long)(1 << n2);
                }
                environmentSet.ltPos[i] = n2;
                --this.numEmptySlots;
                continue block0;
            }
        }
        environmentSet.lightBin = this;
        environmentSet.enableMaskCache = environmentSet.enableMask;
        this.insertEnvSet.add(environmentSet);
        if (!this.onUpdateList) {
            renderBin.objUpdateList.add(this);
            this.onUpdateList = true;
        }
    }

    public void updateObject() {
        int n;
        if (this.insertEnvSet.size() > 0) {
            EnvironmentSet environmentSet = (EnvironmentSet)this.insertEnvSet.get(0);
            if (this.environmentSetList == null) {
                this.environmentSetList = environmentSet;
            } else {
                environmentSet.next = this.environmentSetList;
                this.environmentSetList.prev = environmentSet;
                this.environmentSetList = environmentSet;
            }
            for (n = 1; n < this.insertEnvSet.size(); ++n) {
                environmentSet = (EnvironmentSet)this.insertEnvSet.get(n);
                environmentSet.next = this.environmentSetList;
                this.environmentSetList.prev = environmentSet;
                this.environmentSetList = environmentSet;
            }
        }
        this.insertEnvSet.clear();
        if (this.canvasDirty != 0) {
            Canvas3D[] canvas3DArray = this.renderBin.view.getCanvases();
            for (n = 0; n < canvas3DArray.length; ++n) {
                canvas3DArray[n].canvasDirty |= this.canvasDirty;
            }
            this.lightDirtyMask = this.lightDirtyMaskCache;
            this.canvasDirty = 0;
            this.lightDirtyMaskCache = 0;
        }
        this.onUpdateList = false;
    }

    void removeEnvironmentSet(EnvironmentSet environmentSet) {
        environmentSet.lightBin = null;
        if (this.insertEnvSet.contains(environmentSet)) {
            this.insertEnvSet.remove(this.insertEnvSet.indexOf(environmentSet));
        } else {
            int n;
            int n2 = environmentSet.lights.size();
            block0: for (n = 0; n < n2; ++n) {
                LightRetained lightRetained = (LightRetained)environmentSet.lights.get(n);
                for (int i = 0; i < this.maxLights; ++i) {
                    if (this.lights[i] != lightRetained) continue;
                    int n3 = i;
                    this.lightsRef[n3] = this.lightsRef[n3] - 1;
                    if (this.lightsRef[i] != 0) continue block0;
                    if (lightRetained instanceof PointLightRetained) {
                        this.pointLts.remove(this.pointLts.indexOf(lightRetained));
                    }
                    this.lights[i] = null;
                    this.lightDirtyMaskCache &= ~(1 << i);
                    this.lightDirtyMask &= ~(1 << i);
                    ++this.numEmptySlots;
                    continue block0;
                }
            }
            if (environmentSet.prev == null) {
                this.environmentSetList = environmentSet.next;
                if (environmentSet.next != null) {
                    environmentSet.next.prev = null;
                }
            } else {
                environmentSet.prev.next = environmentSet.next;
                if (environmentSet.next != null) {
                    environmentSet.next.prev = environmentSet.prev;
                }
            }
            Canvas3D[] canvas3DArray = this.renderBin.view.getCanvases();
            for (n = 0; n < canvas3DArray.length; ++n) {
                canvas3DArray[n].environmentSet = null;
            }
        }
        environmentSet.prev = null;
        environmentSet.next = null;
        if (this.environmentSetList == null && this.insertEnvSet.size() == 0) {
            this.renderBin.removeLightBin(this);
            this.geometryBackground = null;
        }
    }

    void render(Canvas3D canvas3D) {
        canvas3D.setStateToUpdate(0, this);
        EnvironmentSet environmentSet = this.environmentSetList;
        while (environmentSet != null) {
            environmentSet.render(canvas3D);
            environmentSet = environmentSet.next;
        }
    }

    void updateAttributes(Canvas3D canvas3D) {
        int n = VirtualUniverse.mc.frameCount;
        if (canvas3D.lightBin != this) {
            double d;
            if (this.geometryBackground == null) {
                d = canvas3D.canvasViewCache.getVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.vworldToVpc);
            } else {
                d = canvas3D.canvasViewCache.getInfVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.infVworldToVpc);
            }
            for (int i = 0; i < this.maxLights; ++i) {
                if (this.lights[i] == null || canvas3D.lights[i] == this.lights[i] && canvas3D.frameCount[i] == n) continue;
                canvas3D.lights[i] = this.lights[i];
                canvas3D.frameCount[i] = n;
                this.lights[i].update(canvas3D.ctx, i, d);
            }
            canvas3D.lightBin = this;
            canvas3D.canvasDirty &= 0xFFFFFFBF;
            canvas3D.enableMask = -1L;
        } else if ((canvas3D.canvasDirty & 0x40) != 0) {
            double d;
            if (this.geometryBackground == null) {
                d = canvas3D.canvasViewCache.getVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.vworldToVpc);
            } else {
                d = canvas3D.canvasViewCache.getInfVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.infVworldToVpc);
            }
            int n2 = 0;
            int n3 = this.lightDirtyMask;
            while (n3 != 0) {
                if ((n3 & 1) != 0) {
                    this.lights[n2].update(canvas3D.ctx, n2, d);
                    canvas3D.lights[n2] = this.lights[n2];
                    canvas3D.frameCount[n2] = n;
                }
                n3 >>= 1;
                ++n2;
            }
            canvas3D.canvasDirty &= 0xFFFFFFBF;
        } else if (this.pointLts.size() > 0 && (canvas3D.canvasDirty & 0x8000) != 0) {
            double d;
            if (this.geometryBackground == null) {
                d = canvas3D.canvasViewCache.getVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.vworldToVpc);
            } else {
                d = canvas3D.canvasViewCache.getInfVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.infVworldToVpc);
            }
            for (int i = 0; i < this.pointLts.size(); ++i) {
                LightRetained lightRetained = (LightRetained)this.pointLts.get(i);
                lightRetained.update(canvas3D.ctx, this.pointLtsSlotIndex[i], d);
                canvas3D.lights[this.pointLtsSlotIndex[i]] = lightRetained;
                canvas3D.frameCount[this.pointLtsSlotIndex[i]] = n;
            }
        }
    }
}

